/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: RoleReverseTestServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */
package com.sun.ts.tests.servlet.spec.security.secbasic;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public class RoleReverseTestServlet extends HttpServlet {


    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {


        PrintWriter out = response.getWriter();
        out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");

        // Output whether the user is in any of the known or an unknown role.
        // Surround these with !'s so they are easier to search for.
        // (i.e. we can search for !true! or !false!)
        out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
        out.println("isUserInRole(\"MGR\"): !" + request.isUserInRole("MGR") + "!<BR>");
        out.println("isUserInRole(\"VP\"): !" + request.isUserInRole("VP") + "!<BR>");
        out.println("isUserInRole(\"EMP\"): !" + request.isUserInRole("EMP") + "!<BR>");
    }
}




