/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.eclipse.fx.ui.controls.form.NodeDecorator;
import org.eclipse.fx.ui.preferences.page.FieldEditor;

public class StringFieldEditor
extends FieldEditor<String> {
    private HBox textFieldContainer = new HBox();
    private TextField textField = new TextField();

    public StringFieldEditor(String name, String label) {
        super(name, label);
        this.textField.setMaxWidth(Double.MAX_VALUE);
        this.textFieldContainer.getChildren().add((Object)this.textField);
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.textFieldContainer);
        NodeDecorator.apply((Node)this.textField, this.statusProperty());
    }

    protected final HBox getTextContainer() {
        return this.textFieldContainer;
    }

    protected final TextField getTextField() {
        return this.textField;
    }

    public StringFieldEditor(String name) {
        this(name, null);
    }

    @Override
    protected void doLoad() {
        this.textField.setText(this.getMemento().get(this.getName(), ""));
    }

    @Override
    protected void doRestoreDefaults() {
        this.textField.setText(this.getMemento().getDefaultString(this.getName()));
    }

    @Override
    protected void doPersist() {
        this.getMemento().put(this.getName(), this.textField.getText());
    }

    @Override
    protected ObservableValue<String> getValue() {
        return this.textField.textProperty();
    }
}

