/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.inject.Inject;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccessExtension;
import org.eclipse.xtext.generator.IFileSystemAccessExtension2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class FileSystemSupportBasedFileSystemAccess
extends AbstractFileSystemAccess2
implements IFileSystemAccess,
IFileSystemAccessExtension,
IFileSystemAccessExtension2,
IFileSystemAccessExtension3 {
    @Inject
    @Extension
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private MutableFileSystemSupport fileSystemSupport;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String projectName;

    protected Path getPath(String fileName, String outputConfigurationName) {
        Map<String, String> _pathes = this.getPathes();
        String path = _pathes.get(outputConfigurationName);
        return new Path("/" + this.projectName + "/" + path + "/" + fileName);
    }

    @Override
    public void generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
        Path path = this.getPath(fileName, outputConfigurationName);
        this.fileSystemSupport.setContents(path, contents);
    }

    @Override
    public URI getURI(String fileName, String outputConfiguration) {
        try {
            Path _path = this.getPath(fileName, outputConfiguration);
            java.net.URI _uRI = this.fileSystemSupport.toURI(_path);
            URL _uRL = _uRI.toURL();
            String _file = _uRL.getFile();
            return URI.createFileURI((String)_file);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void generateFile(String fileName, String outputConfigurationName, InputStream content) throws RuntimeIOException {
        Path path = this.getPath(fileName, outputConfigurationName);
        this.fileSystemSupport.setContentsAsStream(path, content);
    }

    @Override
    public InputStream readBinaryFile(String fileName, String outputConfigurationName) throws RuntimeIOException {
        Path path = this.getPath(fileName, outputConfigurationName);
        return this.fileSystemSupport.getContentsAsStream(path);
    }

    @Override
    public CharSequence readTextFile(String fileName, String outputConfigurationName) throws RuntimeIOException {
        Path path = this.getPath(fileName, outputConfigurationName);
        return this.fileSystemSupport.getContents(path);
    }

    public void setFileSystemSupport(MutableFileSystemSupport fileSystemSupport) {
        this.fileSystemSupport = fileSystemSupport;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

