/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.key;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.input.KeyCode;
import org.eclipse.fx.ui.controls.JavaFXCompatUtil;
import org.eclipse.fx.ui.keybindings.KeyLookup;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component
public final class FxKeyLookup
implements KeyLookup {
    private final Map<String, Integer> modifierKeyTable = new HashMap<String, Integer>();
    private final Map<Integer, String> nameTable = new HashMap<Integer, String>();
    private final Map<String, Integer> naturalKeyTable = new HashMap<String, Integer>();
    public static final int ALT = 65536;
    public static final int SHIFT = 131072;
    public static final int CTRL = 262144;
    public static final int COMMAND = 0x400000;
    public static final int MODIFIER_MASK = 0x470000;
    public static final int NO_KEY = 0;
    private static final boolean isMac = "macosx".equals(FrameworkUtil.getBundle(FxKeyLookup.class).getBundleContext().getProperty("osgi.os"));
    private static final String ZERO_LENGTH_STRING = "";

    public FxKeyLookup() {
        Integer alt = 65536;
        Integer command = 0x400000;
        Integer ctrl = 262144;
        Integer shift = 131072;
        this.modifierKeyTable.put("ALT", alt);
        this.nameTable.put(alt, "ALT");
        this.modifierKeyTable.put("COMMAND", command);
        this.nameTable.put(command, "COMMAND");
        this.modifierKeyTable.put("CTRL", ctrl);
        this.nameTable.put(ctrl, "CTRL");
        this.modifierKeyTable.put("SHIFT", shift);
        this.nameTable.put(shift, "SHIFT");
        this.modifierKeyTable.put("M1", isMac ? command : ctrl);
        this.modifierKeyTable.put("M2", shift);
        this.modifierKeyTable.put("M3", alt);
        this.modifierKeyTable.put("M4", isMac ? ctrl : command);
        Integer code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.DOWN);
        this.naturalKeyTable.put("ARROW_DOWN", code);
        this.nameTable.put(code, "ARROW_DOWN");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.LEFT);
        this.naturalKeyTable.put("ARROW_LEFT", code);
        this.nameTable.put(code, "ARROW_LEFT");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.RIGHT);
        this.naturalKeyTable.put("ARROW_RIGHT", code);
        this.nameTable.put(code, "ARROW_RIGHT");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.UP);
        this.naturalKeyTable.put("ARROW_UP", code);
        this.nameTable.put(code, "ARROW_UP");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.BACK_SPACE);
        this.naturalKeyTable.put("BS", code);
        this.nameTable.put(code, "BS");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.CAPS);
        this.naturalKeyTable.put("CAPS_LOCK", code);
        this.nameTable.put(code, "CAPS_LOCK");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.ENTER);
        this.naturalKeyTable.put("CR", code);
        this.nameTable.put(code, "CR");
        this.naturalKeyTable.put("ENTER", code);
        this.naturalKeyTable.put("RETURN", code);
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.DELETE);
        this.naturalKeyTable.put("DEL", code);
        this.nameTable.put(code, "DEL");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.END);
        this.naturalKeyTable.put("END", code);
        this.nameTable.put(code, "END");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.ESCAPE);
        this.naturalKeyTable.put("ESC", code);
        this.nameTable.put(code, "ESC");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F1);
        this.naturalKeyTable.put("F1", code);
        this.nameTable.put(code, "F1");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F2);
        this.naturalKeyTable.put("F2", code);
        this.nameTable.put(code, "F2");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F3);
        this.naturalKeyTable.put("F3", code);
        this.nameTable.put(code, "F3");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F4);
        this.naturalKeyTable.put("F4", code);
        this.nameTable.put(code, "F4");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F5);
        this.naturalKeyTable.put("F5", code);
        this.nameTable.put(code, "F5");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F6);
        this.naturalKeyTable.put("F6", code);
        this.nameTable.put(code, "F6");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F7);
        this.naturalKeyTable.put("F7", code);
        this.nameTable.put(code, "F7");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F8);
        this.naturalKeyTable.put("F8", code);
        this.nameTable.put(code, "F8");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F9);
        this.naturalKeyTable.put("F9", code);
        this.nameTable.put(code, "F9");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F10);
        this.naturalKeyTable.put("F10", code);
        this.nameTable.put(code, "F10");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F11);
        this.naturalKeyTable.put("F11", code);
        this.nameTable.put(code, "F11");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F12);
        this.naturalKeyTable.put("F12", code);
        this.nameTable.put(code, "F12");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F13);
        this.naturalKeyTable.put("F13", code);
        this.nameTable.put(code, "F13");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F14);
        this.naturalKeyTable.put("F14", code);
        this.nameTable.put(code, "F14");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F15);
        this.naturalKeyTable.put("F15", code);
        this.nameTable.put(code, "F15");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F16);
        this.naturalKeyTable.put("F16", code);
        this.nameTable.put(code, "F16");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F17);
        this.naturalKeyTable.put("F17", code);
        this.nameTable.put(code, "F17");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F18);
        this.naturalKeyTable.put("F18", code);
        this.nameTable.put(code, "F18");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F19);
        this.naturalKeyTable.put("F19", code);
        this.nameTable.put(code, "F19");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.F20);
        this.naturalKeyTable.put("F20", code);
        this.nameTable.put(code, "F20");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.HOME);
        this.naturalKeyTable.put("HOME", code);
        this.nameTable.put(code, "HOME");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.INSERT);
        this.naturalKeyTable.put("INSERT", code);
        this.nameTable.put(code, "INSERT");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUM_LOCK);
        this.naturalKeyTable.put("NUM_LOCK", code);
        this.nameTable.put(code, "NUM_LOCK");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD0);
        this.naturalKeyTable.put("NUMPAD_0", code);
        this.nameTable.put(code, "NUMPAD_0");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD1);
        this.naturalKeyTable.put("NUMPAD_1", code);
        this.nameTable.put(code, "NUMPAD_1");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD2);
        this.naturalKeyTable.put("NUMPAD_2", code);
        this.nameTable.put(code, "NUMPAD_2");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD3);
        this.naturalKeyTable.put("NUMPAD_3", code);
        this.nameTable.put(code, "NUMPAD_3");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD4);
        this.naturalKeyTable.put("NUMPAD_4", code);
        this.nameTable.put(code, "NUMPAD_4");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD5);
        this.naturalKeyTable.put("NUMPAD_5", code);
        this.nameTable.put(code, "NUMPAD_5");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD6);
        this.naturalKeyTable.put("NUMPAD_6", code);
        this.nameTable.put(code, "NUMPAD_6");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD7);
        this.naturalKeyTable.put("NUMPAD_7", code);
        this.nameTable.put(code, "NUMPAD_7");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD8);
        this.naturalKeyTable.put("NUMPAD_8", code);
        this.nameTable.put(code, "NUMPAD_8");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.NUMPAD9);
        this.naturalKeyTable.put("NUMPAD_9", code);
        this.nameTable.put(code, "NUMPAD_9");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.ADD);
        this.naturalKeyTable.put("NUMPAD_ADD", code);
        this.nameTable.put(code, "NUMPAD_ADD");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.DECIMAL);
        this.naturalKeyTable.put("NUMPAD_DECIMAL", code);
        this.nameTable.put(code, "NUMPAD_DECIMAL");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.PAGE_DOWN);
        this.naturalKeyTable.put("PAGE_DOWN", code);
        this.nameTable.put(code, "PAGE_DOWN");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.PAGE_UP);
        this.naturalKeyTable.put("PAGE_UP", code);
        this.nameTable.put(code, "PAGE_UP");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.PAUSE);
        this.naturalKeyTable.put("PAUSE", code);
        this.nameTable.put(code, "PAUSE");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.PRINTSCREEN);
        this.naturalKeyTable.put("PRINT_SCREEN", code);
        this.nameTable.put(code, "PRINT_SCREEN");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.SCROLL_LOCK);
        this.naturalKeyTable.put("SCROLL_LOCK", code);
        this.nameTable.put(code, "SCROLL_LOCK");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.SPACE);
        this.naturalKeyTable.put("SPACE", code);
        this.nameTable.put(code, "SPACE");
        code = JavaFXCompatUtil.getCode((KeyCode)KeyCode.TAB);
        this.naturalKeyTable.put("TAB", code);
        this.nameTable.put(code, "TAB");
    }

    public final String formalNameLookup(int key) {
        Integer keyObject = key;
        String value = this.nameTable.get(keyObject);
        if (value instanceof String) {
            return value;
        }
        return ZERO_LENGTH_STRING + (char)key;
    }

    public final int formalKeyLookup(String name) {
        Integer value = this.naturalKeyTable.get(name);
        if (value instanceof Integer) {
            return value;
        }
        return 0;
    }

    public final int formalModifierLookup(String name) {
        Integer value = this.modifierKeyTable.get(name);
        if (value instanceof Integer) {
            return value;
        }
        return 0;
    }

    public final int getAlt() {
        return 65536;
    }

    public final int getCommand() {
        return 0x400000;
    }

    public final int getCtrl() {
        return 262144;
    }

    public final int getShift() {
        return 131072;
    }
}

