/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.ChangeOption;
import org.eclipse.egerrit.internal.core.command.ChangeStatus;
import org.eclipse.egerrit.internal.core.command.DeleteDraftCommand;
import org.eclipse.egerrit.internal.core.command.DeleteReviewedCommand;
import org.eclipse.egerrit.internal.core.command.GetChangeCommand;
import org.eclipse.egerrit.internal.core.command.GetFilesCommand;
import org.eclipse.egerrit.internal.core.command.GetIncludedInCommand;
import org.eclipse.egerrit.internal.core.command.GetMergeableCommand;
import org.eclipse.egerrit.internal.core.command.GetRelatedChangesCommand;
import org.eclipse.egerrit.internal.core.command.GetReviewedFilesCommand;
import org.eclipse.egerrit.internal.core.command.ListCommentsCommand;
import org.eclipse.egerrit.internal.core.command.ListDraftsCommand;
import org.eclipse.egerrit.internal.core.command.ListReviewersCommand;
import org.eclipse.egerrit.internal.core.command.QueryChangesCommand;
import org.eclipse.egerrit.internal.core.command.SetReviewedCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.IncludedInInfo;
import org.eclipse.egerrit.internal.model.MergeableInfo;
import org.eclipse.egerrit.internal.model.ModelHelpers;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RelatedChangesInfo;
import org.eclipse.egerrit.internal.model.ReviewerInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EStructuralFeature;

public class QueryHelpers {
    private static final String EXECUTING_QUERY = "Executing query";

    public static ChangeInfo[] lookupPartialChangeInfoFromSubject(GerritClient gerritClient, String subject, IProgressMonitor monitor) throws MalformedURLException {
        try {
            monitor.beginTask(EXECUTING_QUERY, -1);
            QueryChangesCommand command = gerritClient.queryChanges();
            command.addOption(new ChangeOption[]{ChangeOption.LABELS});
            command.addOption(new ChangeOption[]{ChangeOption.DETAILED_LABELS});
            command.addOption(new ChangeOption[]{ChangeOption.DETAILED_ACCOUNTS});
            command.addOption(new ChangeOption[]{ChangeOption.MESSAGES});
            command.addOption(new ChangeOption[]{ChangeOption.ALL_REVISIONS});
            command.addOption(new ChangeOption[]{ChangeOption.ALL_COMMITS});
            command.addOption(new ChangeOption[]{ChangeOption.CURRENT_ACTIONS});
            try {
                command.addQuery(QueryHelpers.setFreeText(subject));
                ChangeInfo[] changeInfoArray = command.call();
                return changeInfoArray;
            }
            catch (EGerritException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static String setFreeText(String subject) {
        String query = "message:\"" + subject + "\"";
        return query;
    }

    public static ChangeInfo lookupPartialChangeInfoFromChangeId(GerritClient gerrit, String change_id, IProgressMonitor monitor) {
        try {
            monitor.beginTask(EXECUTING_QUERY, -1);
            GetChangeCommand command = null;
            command = gerrit.getChange(change_id);
            command.addOption(ChangeOption.LABELS);
            command.addOption(ChangeOption.DETAILED_LABELS);
            command.addOption(ChangeOption.DETAILED_ACCOUNTS);
            command.addOption(ChangeOption.MESSAGES);
            command.addOption(ChangeOption.ALL_REVISIONS);
            command.addOption(ChangeOption.ALL_COMMITS);
            command.addOption(ChangeOption.CURRENT_ACTIONS);
            try {
                ChangeInfo changeInfo = (ChangeInfo)command.call();
                return changeInfo;
            }
            catch (EGerritException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e.getMessage()));
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadComments(GerritClient gerrit, RevisionInfo revision) {
        QueryHelpers.loadFiles(gerrit, revision);
        if (revision.isCommentsLoaded()) {
            return;
        }
        ListCommentsCommand command = gerrit.getListComments(revision.getChangeInfo().getId(), revision.getId());
        Map comments = null;
        try {
            comments = (Map)command.call();
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e.getMessage()));
            return;
        }
        ChangeInfo changeInfo = revision.getChangeInfo();
        synchronized (changeInfo) {
            for (Map.Entry fileComment : comments.entrySet()) {
                FileInfo files = (FileInfo)revision.getFiles().get(fileComment.getKey());
                if (files == null) continue;
                files.getComments().clear();
                files.getComments().addAll((Collection)fileComment.getValue());
            }
            revision.setCommentsLoaded(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDrafts(GerritClient gerrit, RevisionInfo revision) {
        if (gerrit.getRepository().getServerInfo().isAnonymous()) {
            return;
        }
        QueryHelpers.loadFiles(gerrit, revision);
        ListDraftsCommand command = gerrit.listDraftsComments(revision.getChangeInfo().getId(), revision.getId());
        Map drafts = null;
        try {
            drafts = (Map)command.call();
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e.getMessage()));
            return;
        }
        ChangeInfo changeInfo = revision.getChangeInfo();
        synchronized (changeInfo) {
            if (drafts.entrySet().isEmpty()) {
                Collection files = revision.getFiles().values();
                files.stream().filter(f -> f.getDraftComments().size() != 0).forEach(f -> f.getDraftComments().clear());
                return;
            }
            for (Map.Entry draftComment : drafts.entrySet()) {
                FileInfo files = (FileInfo)revision.getFiles().get(draftComment.getKey());
                if (files == null) continue;
                if (files.getDraftComments().size() != 0) {
                    files.getDraftComments().clear();
                }
                files.getDraftComments().addAll((Collection)draftComment.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsReviewed(GerritClient gerrit, FileInfo fileInfo) {
        if (gerrit.getRepository().getServerInfo().isAnonymous()) {
            return;
        }
        ChangeInfo changeInfo = fileInfo.getRevision().getChangeInfo();
        synchronized (changeInfo) {
            if (fileInfo.isReviewed()) {
                return;
            }
            SetReviewedCommand command = gerrit.setReviewed(fileInfo.getRevision().getChangeInfo().getId(), fileInfo.getRevision().getId(), fileInfo.getPath());
            try {
                command.call();
                fileInfo.setReviewed(true);
            }
            catch (EGerritException ex) {
                EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + ex.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsNotReviewed(GerritClient gerrit, FileInfo fileInfo) {
        if (gerrit.getRepository().getServerInfo().isAnonymous()) {
            return;
        }
        ChangeInfo changeInfo = fileInfo.getRevision().getChangeInfo();
        synchronized (changeInfo) {
            if (!fileInfo.isReviewed()) {
                return;
            }
            DeleteReviewedCommand command = gerrit.deleteReviewed(fileInfo.getRevision().getChangeInfo().getId(), fileInfo.getRevision().getId(), fileInfo.getPath());
            try {
                command.call();
                fileInfo.setReviewed(false);
            }
            catch (EGerritException ex) {
                EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + ex.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fullyLoaded(ChangeInfo toRefresh) {
        ChangeInfo changeInfo = toRefresh;
        synchronized (changeInfo) {
            block4: {
                if (toRefresh.getLoadingLevel() != 0) break block4;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeNewInformation(ChangeInfo toRefresh, ChangeInfo newChangeInfo) {
        ChangeInfo changeInfo = toRefresh;
        synchronized (changeInfo) {
            if (toRefresh.getUpdated() != null && toRefresh.getUpdated().equals(newChangeInfo.getUpdated()) && QueryHelpers.fullyLoaded(toRefresh)) {
                return;
            }
            toRefresh.set_number(newChangeInfo.get_number());
            toRefresh.setChange_id(newChangeInfo.getChange_id());
            toRefresh.setStatus(newChangeInfo.getStatus());
            toRefresh.setStarred(newChangeInfo.isStarred());
            toRefresh.setSubject(newChangeInfo.getSubject());
            toRefresh.setCreated(newChangeInfo.getCreated());
            toRefresh.setReviewed(newChangeInfo.isReviewed());
            toRefresh.setInsertions(newChangeInfo.getInsertions());
            toRefresh.setDeletions(newChangeInfo.getDeletions());
            toRefresh.setTopic(newChangeInfo.getTopic());
            toRefresh.setMergeable(newChangeInfo.isMergeable());
            toRefresh.getLabels().clear();
            toRefresh.getLabels().addAll((Collection)newChangeInfo.getLabels());
            QueryHelpers.mergeRevisions(toRefresh, newChangeInfo);
            if (newChangeInfo.getCurrent_revision() != null && newChangeInfo.getRevisions().get((Object)newChangeInfo.getCurrent_revision()) != null) {
                toRefresh.setCurrent_revision(newChangeInfo.getCurrent_revision());
            } else {
                toRefresh.setCurrent_revision(toRefresh.getRevisionByNumber(ModelHelpers.getHighestRevisionNumber((Collection)toRefresh.getRevisions().values())).getId());
            }
            if (toRefresh.getUserSelectedRevision() == null) {
                toRefresh.setUserSelectedRevision((RevisionInfo)toRefresh.getRevisions().get((Object)toRefresh.getCurrent_revision()));
            }
            toRefresh.eSet((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__PERMITTED_LABELS, (Object)newChangeInfo.getPermitted_labels());
            toRefresh.eSet((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__ACTIONS, (Object)newChangeInfo.getActions());
            toRefresh.getMessages().clear();
            toRefresh.getMessages().addAll((Collection)newChangeInfo.getMessages());
            toRefresh.setUpdated(newChangeInfo.getUpdated());
            toRefresh.setLoadingLevel(1);
        }
    }

    private static void mergeRevisions(ChangeInfo toRefresh, ChangeInfo newChangeInfo) {
        Set oldKeys = toRefresh.getRevisions().keySet();
        toRefresh.getRevisions().values().forEach(rev -> rev.setCommentsLoaded(false));
        toRefresh.getRevisions().values().forEach(rev -> {
            String revId = rev.getId();
            if (newChangeInfo.getRevisions().get((Object)revId) != null) {
                rev.getActions().clear();
                rev.getActions().putAll(((RevisionInfo)newChangeInfo.getRevisions().get((Object)revId)).getActions());
                rev.setCommit(((RevisionInfo)newChangeInfo.getRevisions().get((Object)revId)).getCommit());
                rev.setRef(((RevisionInfo)newChangeInfo.getRevisions().get((Object)revId)).getRef());
                rev.setDraft(((RevisionInfo)newChangeInfo.getRevisions().get((Object)revId)).isDraft());
            }
        });
        HashSet<String> deletedKeys = new HashSet<String>();
        for (String key : oldKeys) {
            if (newChangeInfo.getRevisions().get((Object)key) != null) continue;
            deletedKeys.add(key);
        }
        deletedKeys.stream().forEach(arg_0 -> ((EMap)toRefresh.getRevisions()).removeKey(arg_0));
        oldKeys.stream().forEach(arg_0 -> ((EMap)newChangeInfo.getRevisions()).removeKey(arg_0));
        toRefresh.getRevisions().putAll(newChangeInfo.getRevisions());
    }

    public static void loadBasicInformation(GerritClient gerrit, ChangeInfo toRefresh) {
        ChangeInfo newChangeInfo = QueryHelpers.queryBasicInformation(gerrit, toRefresh.getId());
        QueryHelpers.mergeNewInformation(toRefresh, newChangeInfo);
    }

    private static ChangeInfo queryBasicInformation(GerritClient gerrit, String id) {
        GetChangeCommand command = gerrit.getChange(id);
        command.addOption(ChangeOption.LABELS);
        command.addOption(ChangeOption.DETAILED_LABELS);
        command.addOption(ChangeOption.DETAILED_ACCOUNTS);
        command.addOption(ChangeOption.MESSAGES);
        command.addOption(ChangeOption.ALL_REVISIONS);
        command.addOption(ChangeOption.ALL_COMMITS);
        command.addOption(ChangeOption.CURRENT_ACTIONS);
        ChangeInfo res = null;
        try {
            res = (ChangeInfo)command.call();
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e.getMessage()));
        }
        return res;
    }

    public static void loadRevisionDetails(GerritClient gerrit, RevisionInfo revision) {
        if (revision == null) {
            throw new IllegalAccessError("Revision can't be null.");
        }
        QueryHelpers.loadFiles(gerrit, revision);
        QueryHelpers.loadReviewedFiles(gerrit, revision);
        QueryHelpers.loadComments(gerrit, revision);
        QueryHelpers.loadDrafts(gerrit, revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadReviewedFiles(GerritClient gerrit, RevisionInfo revision) {
        if (gerrit.getRepository().getServerInfo().isAnonymous()) {
            return;
        }
        GetReviewedFilesCommand command = gerrit.getReviewed(revision.getChangeInfo().getId(), revision.getId());
        try {
            String[] reviewedFiles = (String[])command.call();
            ChangeInfo changeInfo = revision.getChangeInfo();
            synchronized (changeInfo) {
                String[] stringArray = reviewedFiles;
                int n = reviewedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String reviewed = stringArray[n2];
                    FileInfo fileToMarkReviewed = (FileInfo)revision.getFiles().get((Object)reviewed);
                    if (fileToMarkReviewed != null) {
                        fileToMarkReviewed.setReviewed(true);
                    }
                    ++n2;
                }
            }
        }
        catch (EGerritException eGerritException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFiles(GerritClient gerrit, RevisionInfo revision) {
        ChangeInfo changeInfo = revision.getChangeInfo();
        synchronized (changeInfo) {
            if (revision.isFilesLoaded()) {
                return;
            }
        }
        GetFilesCommand command = gerrit.getFiles(revision.getChangeInfo().getId(), revision.getId());
        try {
            Map result = (Map)command.call();
            ChangeInfo changeInfo2 = revision.getChangeInfo();
            synchronized (changeInfo2) {
                revision.getFiles().putAll(result);
                revision.setFilesLoaded(true);
            }
        }
        catch (EGerritException eGerritException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSameTopic(GerritClient gerritClient, ChangeInfo element) {
        ChangeInfo[] sameTopicChangeInfo = null;
        ChangeInfo changeInfo = element;
        synchronized (changeInfo) {
            if (element.getTopic() == null) {
                return;
            }
        }
        try {
            QueryChangesCommand command = gerritClient.queryChanges();
            command.addTopic(element.getTopic());
            sameTopicChangeInfo = command.call();
            ChangeInfo changeInfo2 = element;
            synchronized (changeInfo2) {
                if (sameTopicChangeInfo != null) {
                    element.getSameTopic().clear();
                    ChangeInfo[] changeInfoArray = sameTopicChangeInfo;
                    int n = sameTopicChangeInfo.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ChangeInfo changeInfo3 = changeInfoArray[n2];
                        element.getSameTopic().add((Object)changeInfo3);
                        ++n2;
                    }
                }
            }
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMergeable(GerritClient gerritClient, ChangeInfo element) {
        ChangeInfo changeInfo = element;
        synchronized (changeInfo) {
            if ("MERGED".equals(element.getStatus()) || "ABANDONED".equals(element.getStatus())) {
                return;
            }
        }
        try {
            GetMergeableCommand command = gerritClient.getMergeable(element);
            MergeableInfo mergeableInfo = (MergeableInfo)command.call();
            ChangeInfo changeInfo2 = element;
            synchronized (changeInfo2) {
                element.setMergeableInfo(mergeableInfo);
                element.setMergeable(mergeableInfo.isMergeable());
            }
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadIncludedIn(GerritClient gerritClient, ChangeInfo element) {
        try {
            GetIncludedInCommand command = gerritClient.getIncludedIn(element.getId());
            IncludedInInfo res = null;
            res = (IncludedInInfo)command.call();
            ChangeInfo changeInfo = element;
            synchronized (changeInfo) {
                element.setIncludedIn(res);
            }
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadReviewers(GerritClient gerritClient, ChangeInfo element) {
        try {
            ListReviewersCommand command = gerritClient.getReviewers(element.getId());
            ReviewerInfo[] reviewers = (ReviewerInfo[])command.call();
            ChangeInfo changeInfo = element;
            synchronized (changeInfo) {
                element.getComputedReviewers().clear();
                ReviewerInfo[] reviewerInfoArray = reviewers;
                int n = reviewers.length;
                int n2 = 0;
                while (n2 < n) {
                    ReviewerInfo reviewerInfo = reviewerInfoArray[n2];
                    element.getComputedReviewers().add((Object)reviewerInfo);
                    ++n2;
                }
            }
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRelatedChanges(GerritClient gerritClient, ChangeInfo fChangeInfo) {
        if (gerritClient.getRepository().getServerInfo().isAnonymous()) {
            return;
        }
        try {
            GetRelatedChangesCommand command = gerritClient.getRelatedChanges(fChangeInfo.getId(), fChangeInfo.getCurrent_revision());
            RelatedChangesInfo res = (RelatedChangesInfo)command.call();
            ChangeInfo changeInfo = fChangeInfo;
            synchronized (changeInfo) {
                fChangeInfo.setRelatedChanges(res);
            }
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConflictsWith(GerritClient gerritClient, ChangeInfo element) {
        ChangeInfo[] conflictsWithChangeInfo = null;
        ChangeInfo changeInfo = element;
        synchronized (changeInfo) {
            if ("MERGED".equals(element.getStatus()) || "ABANDONED".equals(element.getStatus())) {
                return;
            }
        }
        try {
            QueryChangesCommand command = gerritClient.queryChanges();
            command.addConflicts(element.getChange_id());
            command.addMergeable();
            command.addStatus(ChangeStatus.OPEN);
            conflictsWithChangeInfo = command.call();
            ArrayList<ChangeInfo> conflictsWithChangeInfolistNew = new ArrayList<ChangeInfo>();
            if (conflictsWithChangeInfo != null) {
                ChangeInfo[] changeInfoArray = conflictsWithChangeInfo;
                int n = conflictsWithChangeInfo.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeInfo conflictChangeInfo = changeInfoArray[n2];
                    if (conflictChangeInfo.getChange_id().compareTo(element.getChange_id()) != 0) {
                        conflictsWithChangeInfolistNew.add(conflictChangeInfo);
                    }
                    ++n2;
                }
            }
            ChangeInfo changeInfo2 = element;
            synchronized (changeInfo2) {
                element.getConflictsWith().clear();
                element.getConflictsWith().addAll(conflictsWithChangeInfolistNew);
            }
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
        }
    }

    public static void loadDetailedInformation(GerritClient gerritClient, ChangeInfo toLoad) {
        QueryHelpers.loadSameTopic(gerritClient, toLoad);
        QueryHelpers.loadConflictsWith(gerritClient, toLoad);
        QueryHelpers.loadIncludedIn(gerritClient, toLoad);
        QueryHelpers.loadMergeable(gerritClient, toLoad);
        QueryHelpers.loadReviewers(gerritClient, toLoad);
        QueryHelpers.loadRelatedChanges(gerritClient, toLoad);
    }

    public static void deleteDraft(GerritClient gerritClient, CommentInfo toDelete) {
        RevisionInfo revision = ModelHelpers.getRevision((CommentInfo)toDelete);
        DeleteDraftCommand deleteDraft = gerritClient.deleteDraft(revision.getChangeInfo().getId(), revision.getId(), toDelete.getId());
        try {
            deleteDraft.call();
            ModelHelpers.getFileInfo((CommentInfo)toDelete).getDraftComments().remove((Object)toDelete);
        }
        catch (EGerritException eGerritException) {}
    }
}

