/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.process.OpenCompareProcess;
import org.eclipse.egerrit.internal.ui.editors.ModelLoader;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.table.model.FilesTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.ui.table.provider.DynamicMenuBuilder;
import org.eclipse.egerrit.internal.ui.table.provider.FileTableLabelProvider;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UIFilesTable {
    public static final String FILES_TABLE = "filesTable";
    private final int TABLE_STYLE = 66304;
    private final String EDITOR_KEY = "fileEditortip";
    private TableViewer fViewer;
    private IDoubleClickListener fdoubleClickListener;
    private GerritClient fGerritClient;
    private ChangeInfo fChangeInfo;
    private ModelLoader loader;
    private DynamicMenuBuilder dynamicMenu = new DynamicMenuBuilder();

    public UIFilesTable(GerritClient gerritClient, ChangeInfo changeInfo) {
        this.fGerritClient = gerritClient;
        this.fChangeInfo = changeInfo;
        this.loader = ModelLoader.initialize(gerritClient, changeInfo);
        this.loader.loadCurrentRevision();
    }

    public TableViewer createTableViewerSection(Composite aParent) {
        this.fViewer = new TableViewer(aParent, 66306);
        this.buildAndLayoutTable();
        this.adjustTableData();
        ReviewTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new ReviewTableSorter(2));
        return this.fViewer;
    }

    private void buildAndLayoutTable() {
        Table table = this.fViewer.getTable();
        FilesTableModel[] tableInfo = FilesTableModel.values();
        int size = tableInfo.length;
        int index = 0;
        while (index < size) {
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        GridData gribData = new GridData(4, 4, true, true);
        gribData.minimumWidth = tableInfo[0].getWidth();
        this.fViewer.getTable().setLayoutData((Object)gribData);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setData((Object)FILES_TABLE);
        this.dynamicMenu.addPulldownMenu((ColumnViewer)this.fViewer, this.fGerritClient);
    }

    private TableViewerColumn createTableViewerColumn(ITableModel tableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(tableInfo.getName());
        column.setWidth(tableInfo.getWidth());
        column.setAlignment(tableInfo.getAlignment());
        column.setResizable(tableInfo.getResize());
        column.setMoveable(tableInfo.getMoveable());
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    private void adjustTableData() {
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 10, 1));
        this.fdoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof StringToFileInfoImpl) {
                    FileInfo selectedFile = ((StringToFileInfoImpl)element).getValue();
                    OpenCompareProcess openCompare = new OpenCompareProcess();
                    openCompare.handleOpenCompare(UIFilesTable.this.fViewer.getTable().getShell(), UIFilesTable.this.fGerritClient, UIFilesTable.this.fChangeInfo, selectedFile, UIFilesTable.this.fChangeInfo.getUserSelectedRevision());
                }
            }
        };
        this.fViewer.addDoubleClickListener(this.fdoubleClickListener);
        if (!this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
            this.fViewer.getTable().addMouseListener((MouseListener)this.toggleReviewedStateListener());
        }
        this.filesTabDataBindings();
    }

    private MouseAdapter toggleReviewedStateListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection;
                ViewerCell viewerCell = UIFilesTable.this.fViewer.getCell(new Point(e.x, e.y));
                if (viewerCell != null && viewerCell.getColumnIndex() == 0 && (selection = UIFilesTable.this.fViewer.getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    FileInfo fileInfo = ((StringToFileInfoImpl)element).getValue();
                    UIFilesTable.this.toggleReviewed(fileInfo);
                }
            }
        };
    }

    private void toggleReviewed(FileInfo fileInfo) {
        if (fileInfo.isReviewed()) {
            QueryHelpers.markAsNotReviewed(this.fGerritClient, fileInfo);
        } else {
            QueryHelpers.markAsReviewed(this.fGerritClient, fileInfo);
        }
        this.fViewer.refresh();
    }

    protected void filesTabDataBindings() {
        if (this.fViewer != null) {
            FeaturePath changerev = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION, ModelPackage.Literals.REVISION_INFO__FILES});
            IObservableList revisionsChanges = EMFProperties.list((FeaturePath)changerev).observe((Object)this.fChangeInfo);
            FeaturePath reviewed = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__REVIEWED});
            FeaturePath commentsCount = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__COMMENTS_COUNT});
            FeaturePath draftCount = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__DRAFTS_COUNT});
            ObservableListContentProvider contentProvider = new ObservableListContentProvider();
            this.fViewer.setContentProvider((IContentProvider)contentProvider);
            IObservableMap[] watchedProperties = Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{EMFProperties.value((FeaturePath)reviewed), EMFProperties.value((FeaturePath)commentsCount), EMFProperties.value((FeaturePath)draftCount)});
            this.fViewer.setLabelProvider((IBaseLabelProvider)new FileTableLabelProvider(watchedProperties));
            this.fViewer.setInput((Object)revisionsChanges);
        }
    }

    public void dispose() {
        this.loader.dispose();
    }
}

