/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReplyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent aEvent) {
        IEditorInput activeEditorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)aEvent);
        if (activeEditorInput instanceof GerritMultipleInput) {
            GerritMultipleInput input = (GerritMultipleInput)activeEditorInput;
            DiffTreeViewer viewer = input.getUpperSection().getDiffTreeViewer();
            try {
                input.saveChanges((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                return 4;
            }
            if (input.getLeftSide().equals("WORKSPACE") || input.getLeftSide().equals("BASE")) {
                UIUtils.displayInformation(Messages.ReplyHandlerTitle, Messages.ReplyHandlerMessage);
            } else {
                RevisionInfo revisionInfo = (RevisionInfo)input.getChangeInfo().getRevisions().get((Object)input.getLeftSide());
                UIUtils.replyToChange(viewer.getControl().getShell(), revisionInfo, null, input.gerritClient, true, null);
                input.fireInputChange();
            }
        }
        return Status.OK_STATUS;
    }

    public boolean isEnabled() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof CompareEditor) {
            GerritMultipleInput input = (GerritMultipleInput)((CompareEditor)editor).getEditorInput();
            return !input.gerritClient.getRepository().getServerInfo().isAnonymous();
        }
        return false;
    }
}

