/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.LabelInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ReplyDialog
extends InputDialog {
    private EMap<String, LabelInfo> labelsInfo;
    private Map<String, EList<String>> permittedLabels;
    private Composite keyComposite;
    private Composite radioButtonComposite;
    private Composite detailTextComposite;
    private ScrolledComposite scrolledDraftArea;
    private static final String DISPLAYWIDGET = "displayWidget";
    private Map<String, Integer> lastUserVotes = new LinkedHashMap<String, Integer>();
    private RevisionInfo fRevisionInfo;
    private GerritClient fGerritClient;

    public ReplyDialog(Shell shell, String reason, RevisionInfo revisionToReplyTo, GerritClient gerritClient, ChangeMessageInfo messageInfo) {
        super(shell, Messages.ReplyDialog_0, ReplyDialog.buildMessage(reason, revisionToReplyTo), ReplyDialog.buildMessageText(messageInfo), null);
        this.fRevisionInfo = revisionToReplyTo;
        this.fGerritClient = gerritClient;
        this.permittedLabels = revisionToReplyTo.getChangeInfo().getSortedPermittedLabels();
        this.labelsInfo = revisionToReplyTo.getChangeInfo().getLabels();
        boolean isVoteAllowed = revisionToReplyTo.getId().equals(revisionToReplyTo.getChangeInfo().getCurrent_revision());
        if (!isVoteAllowed) {
            this.labelsInfo = null;
        }
    }

    private static String buildMessageText(ChangeMessageInfo messageInfo) {
        if (messageInfo == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String message = messageInfo.getMessage();
        sb.append("> ");
        message = message.replaceAll("\n", "\n> ");
        sb.append(message);
        sb.append("\n\n");
        return sb.toString();
    }

    private static String buildMessage(String reason, RevisionInfo revisionToReplyTo) {
        if (reason == null) {
            return ReplyDialog.buildDefaultMessage(revisionToReplyTo);
        }
        return String.valueOf(reason) + ReplyDialog.buildDefaultMessage(revisionToReplyTo);
    }

    private static String buildDefaultMessage(RevisionInfo revisionToReplyTo) {
        return String.valueOf(Messages.ReplyDialog_1) + UIUtils.getPatchSetString(revisionToReplyTo);
    }

    protected int getInputTextStyle() {
        return 2626;
    }

    protected int getShellStyle() {
        return 1232;
    }

    protected Control createDialogArea(final Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridData)this.getText().getLayoutData()).heightHint = 150;
        ((GridData)this.getText().getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.getText().getLayoutData()).verticalAlignment = 4;
        this.createMessageArea(composite);
        GridLayout compositeLayout = (GridLayout)composite.getLayout();
        compositeLayout.verticalSpacing = 0;
        compositeLayout.marginHeight = 0;
        composite.setLayout((Layout)compositeLayout);
        if (this.labelsInfo != null) {
            this.createMiddleRadioSection(composite);
        }
        parent.getShell().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (ReplyDialog.this.keyComposite != null) {
                    int widthKey = ReplyDialog.this.getMinimalWidth(ReplyDialog.this.keyComposite, -1);
                    int widthRadio = ReplyDialog.this.getMinimalWidth(ReplyDialog.this.radioButtonComposite, -1);
                    int widthdetail = ReplyDialog.this.getMinimalWidth(ReplyDialog.this.detailTextComposite, 350);
                    int widthTotal = 0;
                    widthTotal = widthKey < 25 || widthRadio < 25 || widthdetail < 25 ? 250 : widthKey + widthRadio + widthdetail;
                    Point size = parent.getShell().computeSize(widthTotal, -1);
                    parent.getShell().setMinimumSize(size);
                    parent.getShell().setSize(size);
                } else {
                    Point size = parent.getShell().computeSize(-1, -1);
                    parent.getShell().setMinimumSize(size);
                    parent.getShell().setSize(size);
                }
                if (ReplyDialog.this.hasDrafts(ReplyDialog.this.fRevisionInfo)) {
                    ReplyDialog.this.scrolledDraftArea.layout();
                }
                Rectangle parentRec = parent.getShell().getBounds();
                Rectangle clientArea = parent.getClientArea();
                Point centerPos = new Point(parentRec.x + parentRec.width - clientArea.width, parentRec.y);
                parent.getShell().setLocation(centerPos);
                parent.getShell().removeControlListener((ControlListener)this);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.getText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 13) {
                    ReplyDialog.this.getOkButton().notifyListeners(13, new Event());
                }
            }
        });
        this.resetErrorSection(composite);
        return parent;
    }

    private void resetErrorSection(Composite composite) {
        Control[] compChild = composite.getChildren();
        if (compChild != null) {
            GridData gridData;
            if (compChild[0] instanceof Label) {
                Label lbl = (Label)compChild[0];
                gridData = (GridData)lbl.getLayoutData();
                gridData.grabExcessVerticalSpace = false;
                lbl.setLayoutData((Object)gridData);
                lbl.setSize(lbl.computeSize(-1, -1));
            }
            if (compChild.length > 2 && compChild[2] instanceof Text) {
                Text txt = (Text)compChild[2];
                gridData = (GridData)txt.getLayoutData();
                gridData.minimumHeight = 0;
                gridData.grabExcessVerticalSpace = false;
                txt.setLayoutData((Object)gridData);
                txt.setSize(txt.computeSize(-1, -1));
            }
        }
    }

    private int getMinimalWidth(Composite composite, int minWidth) {
        int min = 0;
        Point sizeComposite = composite.computeSize(-1, -1);
        min = minWidth < 0 ? sizeComposite.x : (sizeComposite.x > minWidth || sizeComposite.x == 0 ? minWidth : sizeComposite.x);
        return min;
    }

    private boolean hasDrafts(RevisionInfo revInfo) {
        Collection files = revInfo.getFiles().values();
        for (FileInfo fileInfo : files) {
            if (fileInfo.getDraftComments().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void createMessageArea(Composite parent) {
        if (this.hasDrafts(this.fRevisionInfo)) {
            this.scrolledDraftArea = new ScrolledComposite(parent, 768);
            GridData grid = new GridData(1808);
            grid.heightHint = 50;
            this.scrolledDraftArea.setLayoutData((Object)grid);
            final Composite composite = new Composite((Composite)this.scrolledDraftArea, 0);
            GridLayout glComposite = new GridLayout(1, false);
            glComposite.marginTop = 0;
            glComposite.marginHeight = 0;
            composite.setLayout((Layout)glComposite);
            GridData gdComposite = new GridData(4, 4, true, true, 1, 1);
            gdComposite.heightHint = 150;
            composite.setLayoutData((Object)gdComposite);
            composite.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    Rectangle size = composite.getParent().getClientArea();
                    composite.setSize(composite.computeSize(size.width, -1));
                    ReplyDialog.this.scrolledDraftArea.setMinWidth(size.x);
                    Rectangle compoHeight = composite.getBounds();
                    ReplyDialog.this.scrolledDraftArea.setMinHeight(compoHeight.height);
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            this.createLink(composite);
            this.scrolledDraftArea.setContent((Control)composite);
            Point p = composite.computeSize(-1, -1, true);
            this.scrolledDraftArea.setMinHeight(p.y);
            this.scrolledDraftArea.setMinWidth(p.x);
            this.scrolledDraftArea.setExpandHorizontal(true);
            this.scrolledDraftArea.setExpandVertical(true);
        }
    }

    private void createLink(Composite composite) {
        Collection files = this.fRevisionInfo.getFiles().values();
        for (FileInfo fileInfo : files) {
            if (fileInfo.getDraftComments().isEmpty()) continue;
            Link linkFile = new Link(composite, 0);
            linkFile.setToolTipText(Messages.ReplyDialog_2);
            linkFile.setText("<a>" + fileInfo.getPath() + "</a>");
            linkFile.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            linkFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileInfo fileInfo = (FileInfo)ReplyDialog.this.fRevisionInfo.getFiles().get((Object)e.text);
                    if (fileInfo != null) {
                        UIUtils.open(ReplyDialog.this.fGerritClient, fileInfo, ReplyDialog.this.fRevisionInfo.getChangeInfo(), "BASE");
                        ReplyDialog.this.cancelPressed();
                    }
                }
            });
            Iterator commentsIter = fileInfo.getDraftComments().iterator();
            StringBuilder sb = new StringBuilder();
            while (commentsIter.hasNext()) {
                CommentInfo comment = (CommentInfo)commentsIter.next();
                sb.append("\t " + comment.getLine() + "\t ");
                sb.append(String.valueOf(comment.getMessage()) + "\n");
            }
            Text commentLabel = new Text(composite, 66);
            commentLabel.setBackground(composite.getBackground());
            commentLabel.setEditable(false);
            commentLabel.setText(sb.toString());
            GridData grid = new GridData(16384, 128, true, true, 1, 1);
            commentLabel.setLayoutData((Object)grid);
        }
    }

    private void createMiddleRadioSection(Composite parent) {
        int height;
        int maxRadio;
        if (this.hasDrafts(this.fRevisionInfo)) {
            Label separator = new Label(parent, 258);
            GridData sepGrid = new GridData(768);
            sepGrid.grabExcessHorizontalSpace = true;
            separator.setLayoutData((Object)sepGrid);
        }
        if ((maxRadio = this.getMaxCountLabels()) <= 0) {
            return;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout glComposite = new GridLayout(3, false);
        glComposite.marginTop = 3;
        composite.setLayout((Layout)glComposite);
        GridData gdComposite = new GridData(4, 16384, true, false, 1, 1);
        gdComposite.minimumHeight = height = 75 + 30 * (this.permittedLabels.size() - 1);
        gdComposite.heightHint = height;
        composite.setLayoutData((Object)gdComposite);
        this.keyComposite = this.createComposite(composite, 16384, 1, false);
        this.radioButtonComposite = this.createComposite(composite, 0x1000000, 1, false);
        this.detailTextComposite = this.createComposite(composite, 16384, 1, true);
        this.createRadioButtonSelection();
    }

    private Composite createComposite(Composite parent, int horizontalSwt, int numColumn, boolean grabHorizon) {
        Composite composite = new Composite(parent, 0);
        GridLayout glComposite = new GridLayout(numColumn, false);
        glComposite.marginTop = 3;
        composite.setLayout((Layout)glComposite);
        GridData gdComposite = new GridData(horizontalSwt, 0x1000000, grabHorizon, false);
        composite.setLayoutData((Object)gdComposite);
        return composite;
    }

    private Composite createButtonComposite(Composite composite, int maxRadio) {
        Composite radioComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(maxRadio, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginTop = 0;
        radioComposite.setLayout((Layout)gridLayout);
        return radioComposite;
    }

    private void createRadioButtonSelection() {
        int maxRadio = this.getMaxCountLabels();
        if (maxRadio <= 0) {
            return;
        }
        Composite headerLabels = this.getRadioButtonHeaderLabels(maxRadio);
        Point sizeRadio = null;
        Point fontSize = UIUtils.computeFontSize(this.detailTextComposite);
        String loginUser = this.fGerritClient.getRepository().getServerInfo().getUserName();
        this.lastUserVotes = this.fRevisionInfo.getChangeInfo().getUserLastLabelSet(loginUser);
        for (Map.Entry<String, EList<String>> permittedlabel : this.permittedLabels.entrySet()) {
            sizeRadio = this.createARowRadioLabel(permittedlabel, maxRadio, fontSize.x);
        }
        Point headerSize = headerLabels.getSize();
        GridLayout layout = (GridLayout)headerLabels.getLayout();
        int radioHeight = fontSize.y;
        if (sizeRadio != null) {
            int space = (sizeRadio.x - headerSize.x) / layout.numColumns;
            layout.marginWidth = space / 2;
            layout.horizontalSpacing = space;
            headerLabels.setLayout((Layout)layout);
            radioHeight = sizeRadio.y;
        }
        this.reAdjustRadioLayout(fontSize, radioHeight);
    }

    private Point createARowRadioLabel(Map.Entry<String, EList<String>> permittedlabel, int maxRadio, int fontWidth) {
        EList<String> listPermitted = permittedlabel.getValue();
        Point sizeRadio = null;
        Label rowLabel = new Label(this.keyComposite, 1);
        rowLabel.setText(permittedlabel.getKey());
        Label detailLabel = new Label(this.detailTextComposite, 0);
        GridData grid = new GridData(4, 16384, true, false);
        grid.minimumWidth = fontWidth * 500;
        detailLabel.setLayoutData((Object)grid);
        Composite radioComposite = this.createButtonComposite(this.radioButtonComposite, maxRadio);
        radioComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        int middlePoint = (maxRadio + 1) / 2;
        int minValue = Integer.parseInt((String)listPermitted.get(0));
        int numEmptyBefore = middlePoint + minValue - 1;
        int numEmptyAfter = middlePoint - Integer.parseInt((String)listPermitted.get(listPermitted.size() - 1)) - 1;
        this.createFillerRadioButtons(numEmptyBefore, radioComposite);
        Button[] radios = new Button[listPermitted.size()];
        int i = 0;
        while (i < listPermitted.size()) {
            int userVotes;
            radios[i] = new Button(radioComposite, 16);
            radios[i].setData(listPermitted.get(i));
            radios[i].setData((String)listPermitted.get(i), (Object)permittedlabel.getKey());
            radios[i].setData(DISPLAYWIDGET, (Object)detailLabel);
            String description = this.labelSelectionDescription(permittedlabel.getKey(), (String)listPermitted.get(i));
            radios[i].setToolTipText(description);
            int n = userVotes = this.lastUserVotes.get(permittedlabel.getKey()) != null ? this.lastUserVotes.get(permittedlabel.getKey()) : 0;
            if (Integer.parseInt(((String)listPermitted.get(i)).trim()) == userVotes) {
                radios[i].setSelection(true);
                detailLabel.setText(description);
            }
            radios[i].addListener(13, this.radioGroupListener());
            ++i;
        }
        this.createFillerRadioButtons(numEmptyAfter, radioComposite);
        radioComposite.pack();
        sizeRadio = radioComposite.getSize();
        return sizeRadio;
    }

    private void reAdjustRadioLayout(Point fontSize, int radioHeight) {
        int topMargin = 0;
        int verticalSpacing = radioHeight - fontSize.y + 4;
        Point compSize = this.radioButtonComposite.computeSize(-1, -1);
        GridData radioData = (GridData)this.radioButtonComposite.getLayoutData();
        radioData.minimumWidth = compSize.x;
        this.radioButtonComposite.setLayoutData((Object)radioData);
        GridData gridData = (GridData)this.keyComposite.getLayoutData();
        gridData.heightHint = compSize.y;
        this.keyComposite.setLayoutData((Object)gridData);
        GridLayout keyLayout = (GridLayout)this.keyComposite.getLayout();
        keyLayout.marginTop = topMargin;
        keyLayout.verticalSpacing = verticalSpacing;
        this.keyComposite.setLayout((Layout)keyLayout);
        Point size = this.keyComposite.computeSize(-1, -1);
        this.keyComposite.setSize(size);
        GridData gridDataDetail = (GridData)this.detailTextComposite.getLayoutData();
        gridDataDetail.heightHint = compSize.y;
        this.detailTextComposite.setLayoutData((Object)gridDataDetail);
        GridLayout detailLayout = (GridLayout)this.detailTextComposite.getLayout();
        detailLayout.marginTop = topMargin;
        detailLayout.verticalSpacing = verticalSpacing;
        this.detailTextComposite.setLayout((Layout)detailLayout);
        this.detailTextComposite.setSize(this.detailTextComposite.computeSize(-1, -1));
    }

    private Composite getRadioButtonHeaderLabels(int maxRadioChoice) {
        EList<String> listPermitted = null;
        for (Map.Entry<String, EList<String>> permittedlabel : this.permittedLabels.entrySet()) {
            listPermitted = permittedlabel.getValue();
            if (listPermitted.size() == maxRadioChoice) break;
        }
        new Label(this.keyComposite, 0);
        new Label(this.detailTextComposite, 0);
        Composite radioComposite = this.createButtonComposite(this.radioButtonComposite, maxRadioChoice);
        radioComposite.setLayoutData((Object)new GridData(4, 4, true, true, maxRadioChoice, 1));
        if (listPermitted != null) {
            Label[] radioLabels = new Label[listPermitted.size()];
            int i = 0;
            while (i < listPermitted.size()) {
                radioLabels[i] = new Label(radioComposite, 16);
                radioLabels[i].setText((String)listPermitted.get(i));
                ++i;
            }
            radioComposite.pack();
        }
        return radioComposite;
    }

    private void createFillerRadioButtons(int num, Composite radioComposite) {
        if (num > 0) {
            Button[] emptyRadios = new Button[num];
            int i = 0;
            while (i < num) {
                emptyRadios[i] = new Button(radioComposite, 16);
                emptyRadios[i].setVisible(false);
                ++i;
            }
        }
    }

    private int getMaxCountLabels() {
        int maxButtons = 0;
        int count = 0;
        for (Map.Entry<String, EList<String>> permittedlabel : this.permittedLabels.entrySet()) {
            count = permittedlabel.getValue().size();
            maxButtons = Math.max(maxButtons, count);
        }
        return maxButtons;
    }

    private Listener radioGroupListener() {
        return event -> {
            Widget wid = event.widget;
            Object obj = wid.getData();
            String keyLabel = (String)wid.getData((String)obj);
            String tootip = ((Button)wid).getToolTipText();
            Object objWidget = wid.getData(DISPLAYWIDGET);
            Label toShow = (Label)objWidget;
            toShow.setText(tootip);
            toShow.pack();
            String st = (String)obj;
            if (st.startsWith("+")) {
                st = st.substring(1);
            }
            this.lastUserVotes.put(keyLabel, Integer.parseInt(st.trim()));
        };
    }

    private String labelSelectionDescription(String key, String value) {
        String ret = "";
        if (this.labelsInfo != null && !this.labelsInfo.isEmpty()) {
            LabelInfo info = (LabelInfo)this.labelsInfo.get((Object)key);
            return (String)info.getValues().get((Object)value);
        }
        return ret;
    }

    public Map<String, Integer> getRadiosSelection() {
        return this.lastUserVotes;
    }
}

