/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.List;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.internal.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class AbstractSelectionDialog
extends SelectionDialog {
    protected StructuredViewer fViewer = null;

    public AbstractSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected abstract String getDialogSettingsId();

    protected abstract Object getViewerInput();

    protected abstract StructuredViewer createViewer(Composite var1);

    protected abstract boolean isValid();

    protected IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    protected abstract ILabelProvider getLabelProvider();

    protected String getHelpContextId() {
        return null;
    }

    protected void addViewerListeners(StructuredViewer viewer) {
    }

    protected void addCustomHeaderControls(Composite parent) {
    }

    protected void addCustomFooterControls(Composite parent) {
    }

    protected void initializeControls() {
        this.getButton(0).setEnabled(this.isValid());
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        this.initializeControls();
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite comp = (Composite)super.createDialogArea(parent);
        this.addCustomHeaderControls(comp);
        String label = this.getMessage();
        if (label != null && label.trim().length() != 0) {
            SWTFactory.createWrapLabel(comp, label, 1);
        }
        if ((label = this.getViewerLabel()) != null && label.trim().length() != 0) {
            SWTFactory.createLabel(comp, label, 1);
        }
        this.fViewer = this.createViewer(comp);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fViewer.setContentProvider(this.getContentProvider());
        this.fViewer.setInput(this.getViewerInput());
        List selectedElements = this.getInitialElementSelections();
        if (selectedElements != null && !selectedElements.isEmpty()) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(selectedElements));
        }
        this.addViewerListeners(this.fViewer);
        this.addCustomFooterControls(comp);
        Dialog.applyDialogFont((Control)comp);
        String help = this.getHelpContextId();
        if (help != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, help);
        }
        return comp;
    }

    protected abstract String getViewerLabel();

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = EGFCoreUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsId());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsId());
        }
        return section;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(350, 350);
            }
        }
        return new Point(350, 350);
    }
}

