/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.egf.pattern.engine.AssemblyHelper;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyContentProvider;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

public class JavaAssemblyHelper
extends AssemblyHelper {
    public static final String GENERATE_METHOD = "generate";
    public static final String CONSTRUCTOR_MARKER = "//Here is the constructor";

    public JavaAssemblyHelper(Pattern pattern, JavaAssemblyContentProvider contentProvider) {
        super(pattern, (AssemblyContentProvider)contentProvider);
    }

    protected void addVariableInitialization() throws PatternException {
        int indexOf = this.content.indexOf(CONSTRUCTOR_MARKER);
        if (indexOf == -1) {
            throw new IllegalStateException();
        }
        this.content.insert(indexOf + CONSTRUCTOR_MARKER.length() + 1, this.contentHelper.getMethodContent(this.pattern.getInitMethod()));
    }

    protected void beginOrchestration() throws PatternException {
        String local;
        this.content.append("public void generate (Object argument) throws Exception {").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("InternalPatternContext ctx = (InternalPatternContext)argument;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("IQuery.ParameterDescription paramDesc = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("Map<String, String> queryCtx = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        super.beginOrchestration();
        if (!this.pattern.getAllParameters().isEmpty()) {
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                this.appendQueryCode(this.content, parameter);
            }
            this.content.append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                this.content.append("for (Object ").append(local).append(" : ").append(this.getParameterListName(parameter)).append(" ) {").append(EGFCommonConstants.LINE_SEPARATOR);
            }
            this.content.append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("generate((PatternContext)argument");
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                this.content.append(", ").append(local);
            }
            this.content.append(");").append(EGFCommonConstants.LINE_SEPARATOR);
            int i = 0;
            while (i < this.pattern.getAllParameters().size()) {
                this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR);
                ++i;
            }
        } else {
            this.content.append("generate((PatternContext)argument);").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        this.content.append("if (ctx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ctx.getReporter().executionFinished(ctx.getBuffer().toString(), ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("    ctx.getBuffer().setLength(0);}").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("public String generate(PatternContext ctx");
        if (!this.pattern.getAllParameters().isEmpty()) {
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                this.content.append(", Object ").append(local);
            }
        }
        this.content.append(") throws Exception {").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("InternalPatternContext ictx = (InternalPatternContext)ctx;").append(EGFCommonConstants.LINE_SEPARATOR);
        if (!this.pattern.getAllParameters().isEmpty()) {
            this.content.append("Map<String, Object> parameterValues = new HashMap<String, Object>();").append(EGFCommonConstants.LINE_SEPARATOR);
            for (PatternParameter parameter : this.pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                String type = ParameterTypeHelper.INSTANCE.getTypeLiteral(parameter.getType());
                this.content.append(type).append(" ").append(parameter.getName()).append(" = (").append(type).append(")").append(local).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
                this.content.append("parameterValues.put(\"").append(parameter.getName()).append("\", ").append(local).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        this.content.append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void endOrchestration() throws PatternException {
        this.content.append(EGFCommonConstants.LINE_SEPARATOR).append("String loop = ictx.getBuffer().toString();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (!this.pattern.getAllParameters().isEmpty()) {
            this.content.append("if (ictx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("    ictx.getReporter().loopFinished(loop, ictx, parameterValues);").append(EGFCommonConstants.LINE_SEPARATOR);
            this.content.append("ictx.getBuffer().setLength(0);}").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        this.content.append("return loop;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternVariable var : this.pattern.getVariables()) {
            this.content.append("protected ").append(ParameterTypeHelper.INSTANCE.getTypeLiteral(var.getType())).append(" ").append(var.getName()).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        }
    }

    private String getParameterListName(PatternParameter parameter) {
        return String.valueOf(parameter.getName()) + "List";
    }

    private void appendQueryCode(StringBuilder localContent, PatternParameter parameter) throws PatternException {
        Query query = parameter.getQuery();
        if (query == null) {
            localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
            localContent.append("//this pattern can only be called by another (i.e. it's not an entry point in execution)").append(EGFCommonConstants.LINE_SEPARATOR);
            return;
        }
        localContent.append("paramDesc = new IQuery.ParameterDescription(\"").append(parameter.getName()).append("\", \"").append(parameter.getType()).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
        localContent.append("queryCtx = new HashMap<String, String>();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (query != null && query.getQueryContext() != null) {
            for (String key : query.getQueryContext().keySet()) {
                localContent.append("queryCtx.put(\"").append(key).append("\", \"").append((String)query.getQueryContext().get((Object)key)).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = ");
        localContent.append("QueryHelper.load(ctx, \"").append(query.getExtensionId()).append("\").execute(paramDesc, queryCtx, ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
    }
}

