/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.helper;

import java.lang.reflect.Method;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.ui.EGFCommonUIPlugin;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class EditorHelper {
    public static void setSelectionToViewer(IEditorPart part, URI uri) {
        if (part == null || !(part instanceof IEditingDomainProvider)) {
            return;
        }
        if (uri == null || !uri.hasFragment()) {
            return;
        }
        EditingDomain editingDomain = ((IEditingDomainProvider)part).getEditingDomain();
        EObject eObject = editingDomain.getResourceSet().getEObject(uri, true);
        if (eObject == null) {
            return;
        }
        try {
            Class[] types = new Class[]{Class.forName("java.util.Collection")};
            Method method = part.getClass().getMethod("setSelectionToViewer", types);
            if (method != null) {
                Object[] params = new Object[]{Collections.singletonList(eObject)};
                method.invoke((Object)part, params);
            }
        }
        catch (Throwable t) {
            ThrowableHandler.handleThrowable(EGFCommonUIPlugin.getDefault().getPluginID(), t);
        }
    }

    public static IEditorPart openEditor(EObject eObject) throws PartInitException {
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if (uri == null) {
            return null;
        }
        return EditorHelper.openEditor(uri);
    }

    public static String computeEditorId(String fileName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(fileName);
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public static IEditorPart openEditor(URI uri) throws PartInitException {
        if (uri == null) {
            return null;
        }
        IEditorPart part = EditorHelper.restoreAlreadyOpenedEditor(uri);
        if (part == null) {
            IURIEditorInput editorInput = null;
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (workspaceResource instanceof IFile) {
                    editorInput = EclipseUtil.createFileEditorInput((IFile)workspaceResource);
                    return EditorHelper.openEditor((IEditorInput)editorInput, uri);
                }
            } else {
                return EditorHelper.openEditor((IEditorInput)new URIEditorInput(uri.trimFragment()), uri);
            }
        }
        return part;
    }

    private static IEditorPart openEditor(IEditorInput input, URI uri) throws PartInitException {
        if (input != null && uri != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            return page.openEditor(input, EditorHelper.computeEditorId(uri.trimFragment().lastSegment()));
        }
        return null;
    }

    private static IEditorPart restoreAlreadyOpenedEditor(URI uri) {
        if (uri == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = workbenchPage.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorReference editorReference = iEditorReferenceArray[n6];
                        try {
                            URI innerURI;
                            IEditorInput editorInput = editorReference.getEditorInput();
                            if (editorInput != null && (innerURI = EditorHelper.getURI(editorInput)) != null && innerURI.equals((Object)uri)) {
                                return editorReference.getEditor(true);
                            }
                        }
                        catch (PartInitException partInitException) {}
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static URI getURI(IEditorInput editorInput) {
        URI result = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            result = EclipseUtil.getURI(editorInput);
        }
        if (result == null) {
            result = editorInput instanceof URIEditorInput ? ((URIEditorInput)editorInput).getURI().trimFragment() : URI.createURI((String)editorInput.getName());
        }
        return result;
    }

    public static class EclipseUtil {
        static final Class<?> FILE_CLASS;
        static final Class<?> FILE_REVISION_CLASS;
        static final Method FILE_REVISION_GET_URI_METHOD;
        static final Class<?> URI_EDITOR_INPUT_CLASS;

        static {
            Class<IFile> fileClass = null;
            try {
                fileClass = IFile.class;
            }
            catch (Throwable throwable) {}
            FILE_CLASS = fileClass;
            Class fileRevisionClass = null;
            Method fileRevisionGetURIMethod = null;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.team.core");
            if (bundle != null && (bundle.getState() & 0x2C) != 0) {
                try {
                    fileRevisionClass = bundle.loadClass("org.eclipse.team.core.history.IFileRevision");
                    fileRevisionGetURIMethod = fileRevisionClass.getMethod("getURI", new Class[0]);
                }
                catch (Throwable throwable) {}
            }
            FILE_REVISION_CLASS = fileRevisionClass;
            FILE_REVISION_GET_URI_METHOD = fileRevisionGetURIMethod;
            Class<IURIEditorInput> uriEditorInputClass = null;
            try {
                uriEditorInputClass = IURIEditorInput.class;
            }
            catch (Throwable throwable) {}
            URI_EDITOR_INPUT_CLASS = uriEditorInputClass;
        }

        public static URI getURI(IEditorInput editorInput) {
            Object fileRevision;
            IFile file;
            if (FILE_CLASS != null && (file = (IFile)editorInput.getAdapter(FILE_CLASS)) != null) {
                return URI.createPlatformPluginURI((String)file.getFullPath().toString(), (boolean)true);
            }
            if (FILE_REVISION_CLASS != null && (fileRevision = editorInput.getAdapter(FILE_REVISION_CLASS)) != null) {
                try {
                    return URI.createURI((String)((java.net.URI)FILE_REVISION_GET_URI_METHOD.invoke(fileRevision, new Object[0])).toString());
                }
                catch (Throwable t) {
                    EGFCommonUIPlugin.getDefault().logError(t);
                }
            }
            if (URI_EDITOR_INPUT_CLASS != null && editorInput instanceof IURIEditorInput) {
                return URI.createURI((String)((IURIEditorInput)editorInput).getURI().toString()).trimFragment();
            }
            return null;
        }

        public static IFile getIFile(IEditorInput editorInput) {
            if (FILE_CLASS != null) {
                return (IFile)editorInput.getAdapter(FILE_CLASS);
            }
            return null;
        }

        public static IURIEditorInput createFileEditorInput(IFile file) {
            return new FileEditorInput(file);
        }
    }
}

