/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.execution;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.model.pattern.CallBackHandler;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallHelper {
    public static void execute(String patternId, PatternContext ctx) throws ExtensionHelper.MissingExtensionException, PatternException {
        PatternHelper createCollector = PatternHelper.createCollector();
        Pattern pattern = createCollector.getPattern(patternId);
        PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
        String reason = extension.canExecute(pattern);
        if (reason != null) {
            throw new PatternException(reason);
        }
        extension.createEngine(pattern).execute(ctx);
    }

    public static void executeWithInjection(String patternId, PatternContext ctx, Map<String, Object> name2parameterValue) throws ExtensionHelper.MissingExtensionException, PatternException {
        PatternHelper createCollector = PatternHelper.createCollector();
        Pattern pattern = createCollector.getPattern(patternId);
        PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
        String reason = extension.canExecute(pattern);
        if (reason != null) {
            throw new PatternException(reason);
        }
        HashMap<PatternParameter, Object> parameters = new HashMap<PatternParameter, Object>();
        for (Map.Entry<String, Object> entry : name2parameterValue.entrySet()) {
            PatternParameter parameter = pattern.getParameter(entry.getKey());
            if (parameter == null) {
                throw new PatternException(Messages.bind((String)Messages.call_execution_error1, (Object)entry.getKey(), (Object)pattern.getName()));
            }
            parameters.put(parameter, entry.getValue());
        }
        extension.createEngine(pattern).executeWithInjection(ctx, parameters);
    }

    public static void callBack(PatternContext ctx, Map<String, Object> parameters) throws ExtensionHelper.MissingExtensionException, PatternException {
        CallBackHandler handler = (CallBackHandler)ctx.getValue("pattern.call.back.handler");
        if (handler == null) {
            Activator.getDefault().logWarning(Messages.missing_callback_handler);
        }
        handler.handleCall(ctx, parameters);
    }

    private CallHelper() {
    }
}

