/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.helper;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.egf.core.pde.internal.FcoreGeneratorHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;

public class PluginHelper {
    private static final String PLUGIN_VERSION_3_0 = "3.0";
    private static final String PLUGIN_VERSION_3_2 = "3.2";

    private PluginHelper() {
    }

    public static void updateBuildFile(WorkspacePluginModelBase model) throws CoreException {
        IFile file = model.getFile();
        WorkspaceBuildModel buildModel = (WorkspaceBuildModel)model.getBuildModel();
        IProject project = file.getProject();
        if (buildModel == null) {
            buildModel = FcoreGeneratorHelper.getBuildModel(project);
            model.setBuildModel((IBuildModel)buildModel);
        }
        FcoreGeneratorHelper.addEntryInBinaryBuild((IBuildModel)buildModel, "plugin.xml");
        buildModel.save();
    }

    public static WorkspacePluginModelBase createWorkspacePluginModelBase(IPluginModelBase model) throws CoreException {
        IFile file = PluginHelper.getFile(model, "plugin.xml");
        if (file == null) {
            return null;
        }
        WorkspacePluginModelBase pluginModel = null;
        pluginModel = (WorkspacePluginModelBase)PluginHelper.getModel(file);
        if (pluginModel == null) {
            throw new CoreException(EGFPDEPlugin.getDefault().newStatus(4, NLS.bind((String)"PluginChangesCommandRunner.createWorkspacePluginModelBase(..) _ bundleId ''{0}''.", (Object)BundleHelper.getBundleId((IPluginModelBase)model)), null));
        }
        IPluginBase base = pluginModel.getPluginBase();
        base.setSchemaVersion(TargetPlatformHelper.getTargetVersion() < 3.2 ? PLUGIN_VERSION_3_0 : PLUGIN_VERSION_3_2);
        return pluginModel;
    }

    public static boolean bundleFileExists(IPluginModelBase model, String file) {
        IFile result = PluginHelper.getFile(model, file);
        if (file != null) {
            return result.exists();
        }
        return false;
    }

    public static IPluginModelBase getModel(IFile file) {
        if (file == null) {
            return null;
        }
        if ("plugin.xml".equals(file.getName())) {
            return new WorkspacePluginModel(file, false);
        }
        if ("fragment.xml".equals(file.getName())) {
            return new WorkspaceFragmentModel(file, false);
        }
        return null;
    }

    public static IFile getFile(IPluginModelBase model, String file) {
        if (model == null) {
            return null;
        }
        IProject project = ProjectHelper.getProject((IPluginModelBase)model);
        if (project == null) {
            project = ProjectHelper.getProject((String)BundleHelper.getBundleId((IPluginModelBase)model));
        }
        if (project == null) {
            return null;
        }
        return project.getFile(file);
    }
}

