/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeNameMatchLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_POST_QUALIFIED = 64;
    private int fFlags;

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IType type) {
        return (IPackageFragmentRoot)type.getAncestor(3);
    }

    public TypeNameMatchLabelProvider(int flags) {
        this.fFlags = flags;
    }

    public String getText(Object element) {
        if (!(element instanceof IType)) {
            return super.getText(element);
        }
        return TypeNameMatchLabelProvider.getText((IType)element, this.fFlags);
    }

    public Image getImage(Object element) {
        if (!(element instanceof IType)) {
            return super.getImage(element);
        }
        return TypeNameMatchLabelProvider.getImage((IType)element, this.fFlags);
    }

    private static boolean isSet(int flag, int flags) {
        return (flags & flag) != 0;
    }

    private static String getPackageName(String packName) {
        if (packName.length() == 0) {
            return JavaUIMessages.TypeInfoLabelProvider_default_package;
        }
        return packName;
    }

    public static String getText(IType type, int flags) {
        String packName;
        String containerName;
        StringBuffer buf = new StringBuffer();
        if (TypeNameMatchLabelProvider.isSet(16, flags)) {
            buf.append(type.getElementName());
        } else if (TypeNameMatchLabelProvider.isSet(32, flags)) {
            containerName = TypeNameMatchLabelProvider.getTypeContainerName(type);
            buf.append(TypeNameMatchLabelProvider.getPackageName(containerName));
        } else if (TypeNameMatchLabelProvider.isSet(4, flags)) {
            packName = type.getPackageFragment().getElementName();
            buf.append(TypeNameMatchLabelProvider.getPackageName(packName));
        } else {
            if (TypeNameMatchLabelProvider.isSet(1, flags)) {
                buf.append(type.getFullyQualifiedName());
            } else if (TypeNameMatchLabelProvider.isSet(64, flags)) {
                buf.append(type.getElementName());
                containerName = TypeNameMatchLabelProvider.getTypeContainerName(type);
                if (containerName != null && containerName.length() > 0) {
                    buf.append(JavaElementLabels.CONCAT_STRING);
                    buf.append(containerName);
                }
            } else {
                buf.append(type.getTypeQualifiedName());
            }
            if (TypeNameMatchLabelProvider.isSet(2, flags)) {
                buf.append(JavaElementLabels.CONCAT_STRING);
                packName = type.getPackageFragment().getElementName();
                buf.append(TypeNameMatchLabelProvider.getPackageName(packName));
            }
        }
        if (TypeNameMatchLabelProvider.isSet(8, flags)) {
            buf.append(JavaElementLabels.CONCAT_STRING);
            IPackageFragmentRoot root = TypeNameMatchLabelProvider.getPackageFragmentRoot(type);
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)root, (long)0x20000000000L, (StringBuffer)buf);
        }
        return BasicElementLabels.getJavaElementName((String)buf.toString());
    }

    public static ImageDescriptor getImageDescriptor(IType type, int flags) {
        if (TypeNameMatchLabelProvider.isSet(32, flags)) {
            if (type.getPackageFragment().getElementName().equals(TypeNameMatchLabelProvider.getTypeContainerName(type))) {
                return JavaPluginImages.DESC_OBJS_PACKAGE;
            }
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        if (TypeNameMatchLabelProvider.isSet(4, flags)) {
            return JavaPluginImages.DESC_OBJS_PACKAGE;
        }
        boolean isInner = TypeNameMatchLabelProvider.getTypeContainerName(type).indexOf(46) != -1;
        int modifiers = -1;
        try {
            modifiers = type.getFlags();
        }
        catch (JavaModelException jme) {
            EGFCoreUIPlugin.getDefault().logError(jme);
        }
        ImageDescriptor desc = JavaElementImageProvider.getTypeImageDescriptor((boolean)isInner, (boolean)false, (int)modifiers, (boolean)false);
        int adornmentFlags = 0;
        if (Flags.isFinal((int)modifiers)) {
            adornmentFlags |= 2;
        }
        if (Flags.isAbstract((int)modifiers) && !Flags.isInterface((int)modifiers)) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)modifiers)) {
            adornmentFlags |= 8;
        }
        if (Flags.isDeprecated((int)modifiers)) {
            adornmentFlags |= 0x400;
        }
        return new JavaElementImageDescriptor(desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
    }

    public static Image getImage(IType type, int flags) {
        return JavaPlugin.getImageDescriptorRegistry().get(TypeNameMatchLabelProvider.getImageDescriptor(type, flags));
    }
}

