/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.validation;

import com.google.inject.Inject;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.validation.GraphIssue;
import org.eclipse.elk.core.validation.LayoutOptionValidator;
import org.eclipse.elk.graph.EMapPropertyHolder;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkGraphPackage;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;
import org.eclipse.elk.graph.text.ElkGraphTextUtil;
import org.eclipse.elk.graph.text.validation.AbstractElkGraphValidator;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ElkGraphValidator
extends AbstractElkGraphValidator {
    @Inject
    private LayoutOptionValidator layoutOptionValidator;

    @Check
    public void checkPropertyKey(ElkPropertyToValueMapEntryImpl entry) {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(entry.getKey().getId());
        if (optionData == null) {
            String _id = entry.getKey().getId();
            String _plus = "'" + _id;
            String _plus_1 = _plus + "' is not a layout option.";
            this.warning(_plus_1, (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__KEY);
        }
    }

    @Check
    public void checkPropertyValue(ElkPropertyToValueMapEntryImpl entry) {
        LayoutOptionData option = this.toLayoutOption(entry.getKey());
        if (option != null) {
            Object value;
            EObject container = entry.eContainer();
            if (container instanceof ElkGraphElement) {
                boolean _matched = false;
                if (container instanceof ElkNode) {
                    _matched = true;
                    this.checkOptionTarget(option, LayoutOptionData.Target.NODES, LayoutOptionData.Target.PARENTS);
                }
                if (!_matched && container instanceof ElkEdge) {
                    _matched = true;
                    this.checkOptionTarget(option, LayoutOptionData.Target.EDGES);
                }
                if (!_matched && container instanceof ElkPort) {
                    _matched = true;
                    this.checkOptionTarget(option, LayoutOptionData.Target.PORTS);
                }
                if (!_matched && container instanceof ElkLabel) {
                    _matched = true;
                    this.checkOptionTarget(option, LayoutOptionData.Target.LABELS);
                }
                if (container instanceof ElkNode && option.getTargets().contains(LayoutOptionData.Target.NODES)) {
                    this.checkAlgorithmSupport(option, (ElkGraphElement)((ElkNode)container).getParent());
                } else {
                    this.checkAlgorithmSupport(option, (ElkGraphElement)container);
                }
            }
            if ((value = entry.getValue()) instanceof IPropertyValueProxy) {
                if ((value = ((IPropertyValueProxy)value).resolveValue((IProperty)option)) == null) {
                    LayoutOptionData.Type _type = option.getType();
                    if (_type != null) {
                        switch (_type) {
                            case STRING: {
                                this.expectPropertyType(String.class);
                                break;
                            }
                            case BOOLEAN: {
                                this.expectPropertyType(Boolean.class);
                                break;
                            }
                            case INT: {
                                this.expectPropertyType(Integer.class);
                                break;
                            }
                            case DOUBLE: {
                                this.expectPropertyType(Double.class);
                                break;
                            }
                            case ENUMSET: {
                                this.expectPropertyType(EnumSet.class);
                                break;
                            }
                            default: {
                                _optionClass = option.getOptionClass();
                                boolean bl = _tripleNotEquals = _optionClass != null;
                                if (_tripleNotEquals) {
                                    this.expectPropertyType(option.getOptionClass());
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        _optionClass = option.getOptionClass();
                        boolean bl = _tripleNotEquals = _optionClass != null;
                        if (_tripleNotEquals) {
                            this.expectPropertyType(option.getOptionClass());
                        }
                    }
                } else {
                    entry.setValue(value);
                }
            }
            if (value != null) {
                List issues = this.layoutOptionValidator.checkProperty((IProperty)option, value, (ElkGraphElement)EcoreUtil2.getContainerOfType((EObject)entry, ElkGraphElement.class));
                for (GraphIssue issue : issues) {
                    GraphIssue.Severity _severity = issue.getSeverity();
                    if (_severity == null) continue;
                    switch (_severity) {
                        case ERROR: {
                            this.error(issue.getMessage(), (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__VALUE);
                            break;
                        }
                        case WARNING: {
                            this.warning(issue.getMessage(), (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__VALUE);
                            break;
                        }
                    }
                }
                boolean _equals = Objects.equals(CoreOptions.ALGORITHM, option);
                if (_equals) {
                    boolean _tripleEquals;
                    LayoutAlgorithmData _algorithmDataBySuffix = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix((String)value);
                    boolean bl = _tripleEquals = _algorithmDataBySuffix == null;
                    if (_tripleEquals) {
                        this.error("No layout algorithm with identifier '" + String.valueOf(value) + "' can be found.", (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__VALUE);
                    }
                }
            }
        }
    }

    private LayoutOptionData toLayoutOption(IProperty<?> property) {
        if (property instanceof LayoutOptionData) {
            return (LayoutOptionData)property;
        }
        if (property != null) {
            return LayoutMetaDataService.getInstance().getOptionData(property.getId());
        }
        return null;
    }

    private void checkOptionTarget(LayoutOptionData option, LayoutOptionData.Target ... targetTypes) {
        boolean _not;
        Functions.Function1 _function = it -> option.getTargets().contains(it);
        boolean _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)targetTypes)), (Functions.Function1)_function);
        boolean bl = _not = !_exists;
        if (_not) {
            String _id = option.getId();
            String _plus = "The layout option '" + _id;
            String _plus_1 = _plus + "' is not applicable to ";
            String _lowerCase = ((LayoutOptionData.Target)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)targetTypes)))).toString().toLowerCase();
            String _plus_2 = _plus_1 + _lowerCase;
            String _plus_3 = _plus_2 + ".";
            this.warning(_plus_3, (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__KEY, "OPTION_NOT_APPLICABLE", new String[0]);
        }
    }

    private void checkAlgorithmSupport(LayoutOptionData option, ElkGraphElement element) {
        LayoutAlgorithmData algorithm;
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equals(option, CoreOptions.ALGORITHM);
        if (_notEquals && (algorithm = ElkGraphTextUtil.getAlgorithm(element)) != null && !algorithm.knowsOption((IProperty)option)) {
            boolean foundMatch = false;
            ElkNode parent = (ElkNode)EcoreUtil2.getContainerOfType((EObject)element, ElkNode.class);
            while (parent != null && !foundMatch) {
                algorithm = ElkGraphTextUtil.getAlgorithm((ElkGraphElement)parent);
                foundMatch = algorithm != null && algorithm.knowsOption((IProperty)option);
                parent = parent.getParent();
            }
            if (!foundMatch) {
                String _id = algorithm.getId();
                String _plus = "The algorithm '" + _id;
                String _plus_1 = _plus + "' does not support the option '";
                String _id_1 = option.getId();
                String _plus_2 = _plus_1 + _id_1;
                String _plus_3 = _plus_2 + "'.";
                this.warning(_plus_3, (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__KEY);
            }
        }
    }

    private void expectPropertyType(Class<?> type) {
        String _simpleName = type.getSimpleName();
        String _plus = "Expected value of type " + _simpleName;
        String _plus_1 = _plus + ".";
        this.error(_plus_1, (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__VALUE);
    }

    @Check
    public void checkUniqueProperties(EMapPropertyHolder propertyHolder) {
        HashMap usedProperties = CollectionLiterals.newHashMap();
        EMap _properties = propertyHolder.getProperties();
        for (Map.Entry entry : _properties) {
            IProperty property = (IProperty)entry.getKey();
            boolean _containsKey = usedProperties.containsKey(property);
            if (_containsKey) {
                this.propertyAlreadyAssigned(entry);
                Map.Entry other = (Map.Entry)usedProperties.get(property);
                if (other == null) continue;
                this.propertyAlreadyAssigned(other);
                usedProperties.put(property, null);
                continue;
            }
            usedProperties.put(property, entry);
        }
    }

    private void propertyAlreadyAssigned(Map.Entry<IProperty<?>, Object> entry) {
        if (entry instanceof ElkPropertyToValueMapEntryImpl) {
            this.error("Property is already assigned.", (EObject)entry, (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__KEY);
        }
    }

    @Check
    public void checkUniqueNames(ElkGraphElement element) {
        HashMap usedNames = CollectionLiterals.newHashMap();
        EList _eContents = element.eContents();
        for (EObject object : _eContents) {
            String name;
            String _switchResult = null;
            boolean _matched = false;
            if (object instanceof ElkGraphElement) {
                _matched = true;
                _switchResult = ((ElkGraphElement)object).getIdentifier();
            }
            if (!_matched && object instanceof ElkEdgeSection) {
                _matched = true;
                _switchResult = ((ElkEdgeSection)object).getIdentifier();
            }
            if ((name = _switchResult) == null) continue;
            boolean _containsKey = usedNames.containsKey(name);
            if (_containsKey) {
                this.nameAlreadyUsed(object);
                EObject other = (EObject)usedNames.get(name);
                if (other == null) continue;
                this.nameAlreadyUsed(other);
                usedNames.put(name, null);
                continue;
            }
            usedNames.put(name, object);
        }
    }

    private void nameAlreadyUsed(EObject object) {
        EAttribute _switchResult = null;
        boolean _matched = false;
        if (object instanceof ElkGraphElement) {
            _matched = true;
            _switchResult = ElkGraphPackage.Literals.ELK_GRAPH_ELEMENT__IDENTIFIER;
        }
        if (!_matched && object instanceof ElkEdgeSection) {
            _matched = true;
            _switchResult = ElkGraphPackage.Literals.ELK_EDGE_SECTION__IDENTIFIER;
        }
        EAttribute feature = _switchResult;
        this.error("Identifier is already used.", object, (EStructuralFeature)feature);
    }

    @Check
    public void checkEdgeContainer(ElkEdge edge) {
        ElkNode bestContainer;
        boolean _not;
        boolean bl = _not = !edge.getSources().isEmpty() || !edge.getTargets().isEmpty();
        if (_not && (bestContainer = ElkGraphUtil.findBestEdgeContainment((ElkEdge)edge)) != null && !Objects.equals(bestContainer, edge.getContainingNode())) {
            boolean _tripleEquals;
            ElkNode _parent = bestContainer.getParent();
            boolean bl2 = _tripleEquals = _parent == null;
            if (_tripleEquals) {
                this.warning("This edge should be declared in the root node of this graph.", null);
            } else {
                String _identifier = bestContainer.getIdentifier();
                String _plus = "This edge should be declared in node " + _identifier;
                String _plus_1 = _plus + ".";
                this.warning(_plus_1, null);
            }
        }
    }

    @Check
    public void checkEdgeSection(ElkEdgeSection edgeSection) {
        ElkConnectableShape outgoingShape;
        ElkEdge edge = edgeSection.getParent();
        ElkConnectableShape incomingShape = edgeSection.getIncomingShape();
        if (incomingShape != null && !incomingShape.eIsProxy()) {
            boolean _isEmpty;
            boolean _not_1;
            boolean _not;
            boolean _contains = edge.getSources().contains((Object)incomingShape);
            boolean bl = _not = !_contains;
            if (_not) {
                String _name = incomingShape.eClass().getName();
                String _plus = "The " + _name;
                String _plus_1 = _plus + " ";
                String _identifier = incomingShape.getIdentifier();
                String _plus_2 = _plus_1 + _identifier;
                String _plus_3 = _plus_2 + " is not a source of this edge.";
                this.error(_plus_3, (EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__INCOMING_SHAPE);
            }
            boolean bl2 = _not_1 = !(_isEmpty = edgeSection.getIncomingSections().isEmpty());
            if (_not_1) {
                String _name_1 = incomingShape.eClass().getName();
                String _plus_4 = "An edge section cannot be connected to an " + _name_1;
                String _plus_5 = _plus_4 + " and other sections at the same time.";
                this.error(_plus_5, (EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__INCOMING_SHAPE);
            }
        }
        if ((outgoingShape = edgeSection.getOutgoingShape()) != null && !outgoingShape.eIsProxy()) {
            boolean _isEmpty_1;
            boolean _not_3;
            boolean _not_2;
            boolean _contains_1 = edge.getTargets().contains((Object)outgoingShape);
            boolean bl = _not_2 = !_contains_1;
            if (_not_2) {
                String _name_2 = outgoingShape.eClass().getName();
                String _plus_6 = "The " + _name_2;
                String _plus_7 = _plus_6 + " ";
                String _identifier_1 = outgoingShape.getIdentifier();
                String _plus_8 = _plus_7 + _identifier_1;
                String _plus_9 = _plus_8 + " is not a target of this edge.";
                this.error(_plus_9, (EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__OUTGOING_SHAPE);
            }
            boolean bl3 = _not_3 = !(_isEmpty_1 = edgeSection.getOutgoingSections().isEmpty());
            if (_not_3) {
                String _name_3 = outgoingShape.eClass().getName();
                String _plus_10 = "An edge section cannot be connected to an " + _name_3;
                String _plus_11 = _plus_10 + " and other sections at the same time.";
                this.error(_plus_11, (EStructuralFeature)ElkGraphPackage.Literals.ELK_EDGE_SECTION__OUTGOING_SHAPE);
            }
        }
    }
}

