/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p1widthapproximation;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.RectPackingLayoutPhases;
import org.eclipse.elk.alg.rectpacking.options.InternalProperties;
import org.eclipse.elk.alg.rectpacking.options.OptimizationGoal;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.p1widthapproximation.AreaApproximation;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.alg.rectpacking.util.DrawingUtil;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;

public class GreedyWidthApproximator
implements ILayoutPhase<RectPackingLayoutPhases, ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Greedy Width Approximator", 1.0f);
        double aspectRatio = (Double)graph.getProperty(RectPackingOptions.ASPECT_RATIO);
        ElkPadding padding = (ElkPadding)graph.getProperty(RectPackingOptions.PADDING);
        OptimizationGoal goal = (OptimizationGoal)((Object)graph.getProperty(RectPackingOptions.WIDTH_APPROXIMATION_OPTIMIZATION_GOAL));
        boolean lastPlaceShift = (Boolean)graph.getProperty(RectPackingOptions.WIDTH_APPROXIMATION_LAST_PLACE_SHIFT);
        double nodeNodeSpacing = (Double)graph.getProperty(RectPackingOptions.SPACING_NODE_NODE);
        EList rectangles = graph.getChildren();
        DrawingUtil.resetCoordinates((List<ElkNode>)rectangles);
        AreaApproximation firstIt = new AreaApproximation(aspectRatio, goal, lastPlaceShift);
        DrawingData drawing = firstIt.approxBoundingBox((List<ElkNode>)rectangles, nodeNodeSpacing, padding);
        graph.setProperty(InternalProperties.TARGET_WIDTH, (Object)drawing.getDrawingWidth());
        progressMonitor.done();
    }

    public LayoutProcessorConfiguration<RectPackingLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

