/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p2packing;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.p2packing.InitialPlacement;
import org.eclipse.elk.alg.rectpacking.util.Block;
import org.eclipse.elk.alg.rectpacking.util.BlockStack;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkNode;

public final class Compaction {
    private Compaction() {
    }

    protected static Pair<Boolean, Boolean> compact(int rowIdx, List<RectRow> rows, double boundingWidth, double nodeNodeSpacing, boolean rowHeightReevaluation) {
        boolean somethingWasChanged = false;
        boolean compactRowAgain = false;
        int nextRowIndex = rowIdx + 1;
        RectRow row = rows.get(rowIdx);
        List<Block> blocks = row.getChildren();
        BlockStack currentStack = null;
        int blockId = 0;
        while (blockId < row.getNumberOfAssignedBlocks()) {
            block17: {
                Block nextBlock;
                Block block;
                block19: {
                    block24: {
                        block22: {
                            block23: {
                                boolean wasFromNextRow;
                                block21: {
                                    block20: {
                                        block18: {
                                            block = blocks.get(blockId);
                                            if (block.isFixed()) break block17;
                                            if (!block.getChildren().isEmpty()) break block18;
                                            System.err.println("There should not be an empty block. Empty blocks are directly removed.");
                                            row.removeBlock(block);
                                            --blockId;
                                            somethingWasChanged = true;
                                            break block17;
                                        }
                                        if (!block.isPositionFixed()) {
                                            if (currentStack != null) {
                                                currentStack.updateDimension();
                                            }
                                            currentStack = new BlockStack(currentStack == null ? 0.0 : currentStack.getX() + currentStack.getWidth() + nodeNodeSpacing, row.getY(), nodeNodeSpacing);
                                            block.setLocation(currentStack.getX() + currentStack.getWidth(), row.getY());
                                            row.getStacks().add(currentStack);
                                            currentStack.addBlock(block);
                                            block.setPositionFixed(true);
                                        }
                                        nextBlock = null;
                                        nextBlock = Compaction.getNextBlock(rows, row, blockId, nextRowIndex);
                                        wasFromNextRow = false;
                                        if (nextBlock != null) {
                                            boolean bl = wasFromNextRow = !nextBlock.getParentRow().equals(row);
                                        }
                                        if (nextBlock == null) break block19;
                                        if (!nextBlock.getChildren().isEmpty() && !((Boolean)nextBlock.getChildren().get(0).getProperty(RectPackingOptions.IN_NEW_ROW)).booleanValue()) {
                                            Compaction.useRowWidth(block, boundingWidth);
                                            somethingWasChanged |= Compaction.absorbBlocks(row, block, nextBlock, boundingWidth, nodeNodeSpacing);
                                        } else {
                                            row.removeBlock(nextBlock);
                                            break;
                                        }
                                        if (nextBlock.getChildren().isEmpty()) {
                                            if (rows.size() > nextRowIndex) {
                                                rows.get(nextRowIndex).removeBlock(nextBlock);
                                            }
                                            nextBlock = null;
                                            while (rows.size() > nextRowIndex && rows.get(nextRowIndex).getChildren().isEmpty()) {
                                                rows.remove(rows.get(nextRowIndex));
                                            }
                                        }
                                        if (nextBlock != null) break block20;
                                        --blockId;
                                        break block17;
                                    }
                                    if (((Boolean)nextBlock.getChildren().get(0).getProperty(RectPackingOptions.IN_NEW_ROW)).booleanValue() || !Compaction.placeBelow(rows, row, block, nextBlock, wasFromNextRow, boundingWidth, nextRowIndex, nodeNodeSpacing)) break block21;
                                    somethingWasChanged = true;
                                    break block17;
                                }
                                if (!wasFromNextRow) break block22;
                                double oldRowHeight = row.getHeight();
                                double nextBlockMinHeight = nextBlock.getMinHeight();
                                if (((Boolean)nextBlock.getChildren().get(0).getProperty(RectPackingOptions.IN_NEW_ROW)).booleanValue() || !Compaction.placeBeside(rows, row, block, nextBlock, wasFromNextRow, boundingWidth, nextRowIndex, nodeNodeSpacing, rowHeightReevaluation)) break block23;
                                somethingWasChanged = true;
                                if (oldRowHeight < nextBlockMinHeight) {
                                    compactRowAgain = true;
                                    nextBlock.setParentRow(row);
                                    break;
                                }
                                break block17;
                            }
                            if (!Compaction.useRowHeight(row, block)) break block24;
                            block.setFixed(true);
                            somethingWasChanged = true;
                            break block17;
                        }
                        if (!Compaction.useRowHeight(row, block)) break block24;
                        block.setFixed(true);
                        somethingWasChanged = true;
                        break block17;
                    }
                    if (somethingWasChanged) break block17;
                }
                if (Compaction.useRowHeight(row, block)) {
                    block.setFixed(true);
                    somethingWasChanged = true;
                    if (nextBlock != null) {
                        nextBlock.setPositionFixed(false);
                    }
                } else {
                    block.getStack().updateDimension();
                }
            }
            ++blockId;
        }
        return new Pair((Object)somethingWasChanged, (Object)compactRowAgain);
    }

    private static Block getNextBlock(List<RectRow> rows, RectRow row, int blockId, int nextRowIndex) {
        Block nextBlock = null;
        if (blockId < row.getNumberOfAssignedBlocks() - 1) {
            nextBlock = row.getChildren().get(blockId + 1);
        } else if (nextRowIndex < rows.size() && !rows.get(nextRowIndex).getChildren().isEmpty()) {
            nextBlock = rows.get(nextRowIndex).getChildren().get(0);
        }
        return nextBlock;
    }

    private static boolean useRowHeight(RectRow row, Block block) {
        boolean somethingWasChanged = false;
        double previousWidth = block.getStack().getWidth();
        if (block.getHeight() < row.getHeight()) {
            double targetWidth = block.getStack().getWidthForFixedHeight(row.getHeight());
            if (block.getStack().getWidth() > targetWidth) {
                block.getStack().placeRectsIn(targetWidth);
                somethingWasChanged = previousWidth != block.getStack().getWidth();
            }
        }
        return somethingWasChanged;
    }

    private static void useRowWidth(Block block, double boundingWidth) {
        block.placeRectsIn(boundingWidth - block.getX());
        block.getStack().updateDimension();
    }

    private static boolean absorbBlocks(RectRow row, Block block, Block nextBlock, double boundingWidth, double nodeNodeSpacing) {
        boolean somethingWasChanged = false;
        ElkNode rect = nextBlock.getChildren().get(0);
        while (InitialPlacement.placeRectInBlock(row, block, rect, boundingWidth, nodeNodeSpacing)) {
            somethingWasChanged = true;
            nextBlock.removeChild(rect);
            if (nextBlock.getChildren().isEmpty()) break;
            rect = nextBlock.getChildren().get(0);
        }
        if (nextBlock.getChildren().isEmpty()) {
            nextBlock.getParentRow().removeBlock(nextBlock);
        }
        if (somethingWasChanged) {
            block.getStack().updateDimension();
        }
        return somethingWasChanged;
    }

    private static boolean placeBelow(List<RectRow> rows, RectRow row, Block block, Block nextBlock, boolean wasFromNextRow, double boundingWidth, int nextRowIndex, double nodeNodeSpacing) {
        boolean somethingWasChanged = false;
        double remainingWidth = boundingWidth - block.getX();
        double currentBlockMinHeight = block.getY() - row.getY() + block.getHeightForTargetWidth(remainingWidth);
        if (nextBlock.getMinWidth() + nodeNodeSpacing > remainingWidth) {
            return false;
        }
        double nextBlockMinHeight = nextBlock.getHeightForTargetWidth(remainingWidth);
        if (currentBlockMinHeight + nodeNodeSpacing + nextBlockMinHeight <= row.getHeight()) {
            block.placeRectsIn(boundingWidth - block.getX());
            block.setFixed(true);
            nextBlock.placeRectsIn(boundingWidth - block.getX());
            nextBlock.setLocation(block.getX(), block.getY() + block.getHeight() + nodeNodeSpacing);
            nextBlock.setPositionFixed(true);
            block.getStack().addBlock(nextBlock);
            somethingWasChanged = true;
            if (wasFromNextRow) {
                row.addBlock(nextBlock);
                nextBlock.setParentRow(row);
                if (rows.size() > nextRowIndex) {
                    rows.get(nextRowIndex).removeBlock(nextBlock);
                    if (rows.get(nextRowIndex).getChildren().isEmpty()) {
                        rows.remove(nextRowIndex);
                    }
                }
            }
        }
        return somethingWasChanged;
    }

    private static boolean placeBeside(List<RectRow> rows, RectRow row, Block block, Block nextBlock, boolean wasFromNextRow, double boundingWidth, int nextRowIndex, double nodeNodeSpacing, boolean rowHeightReevaluation) {
        boolean lastRowOptimization;
        boolean somethingWasChanged = false;
        double currentBlockMinWidth = block.getStack().getWidthForFixedHeight(row.getY() + row.getHeight() - block.getStack().getY());
        boolean shouldRowHeigthBeReevalauted = nextBlock.getMinHeight() > row.getHeight() && rowHeightReevaluation;
        double targetWidthOfNextBlock = boundingWidth - (block.getStack().getX() + currentBlockMinWidth - nodeNodeSpacing);
        double nextBlockHeight = nextBlock.getHeightForTargetWidth(targetWidthOfNextBlock);
        if (shouldRowHeigthBeReevalauted && nextBlockHeight > nextBlock.getMinHeight()) {
            return false;
        }
        if (shouldRowHeigthBeReevalauted) {
            double potentialWidth = 0.0;
            for (BlockStack stack : row.getStacks()) {
                potentialWidth += stack.getWidthForFixedHeight(nextBlock.getMinHeight()) + nodeNodeSpacing;
            }
            targetWidthOfNextBlock = boundingWidth - potentialWidth;
        }
        if (targetWidthOfNextBlock < nextBlock.getMinWidth()) {
            return false;
        }
        boolean bl = lastRowOptimization = nextRowIndex == rows.size() - 1 && targetWidthOfNextBlock >= rows.get(nextRowIndex).getWidth();
        if (!shouldRowHeigthBeReevalauted && nextBlockHeight > row.getHeight() && !lastRowOptimization) {
            return false;
        }
        if (lastRowOptimization || shouldRowHeigthBeReevalauted || nextBlockHeight <= row.getHeight()) {
            if (lastRowOptimization && nextBlockHeight > row.getHeight()) {
                block.setHeight(nextBlockHeight);
                block.placeRectsIn(block.getWidthForTargetHeight(nextBlockHeight));
            } else {
                block.getStack().placeRectsIn(currentBlockMinWidth);
                block.setFixed(true);
            }
            nextBlock.placeRectsIn(boundingWidth - (block.getX() + block.getWidth()));
            nextBlock.setLocation(block.getStack().getX() + block.getStack().getWidth(), row.getY());
            row.addBlock(nextBlock);
            if (rows.size() > nextRowIndex) {
                rows.get(nextRowIndex).removeBlock(nextBlock);
                if (rows.get(nextRowIndex).getChildren().isEmpty()) {
                    rows.remove(nextRowIndex);
                }
            }
            somethingWasChanged = true;
        }
        return somethingWasChanged;
    }
}

