/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.ui.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.internal.packs.ui.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.data.DataManager;
import org.eclipse.embedcdt.packs.core.data.DataUtils;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.data.Repos;
import org.eclipse.embedcdt.packs.core.data.cmsis.Index;
import org.eclipse.embedcdt.packs.core.data.cmsis.PdscParserForContent;
import org.eclipse.embedcdt.packs.core.data.xcdl.ContentSerialiser;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.ui.Utils;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.xml.sax.SAXParseException;

public class UpdatePacksHandler
extends AbstractHandler {
    private IConsoleStream fOut;
    private boolean fRunning;
    private Repos fRepos;
    private DataManager fDataManager;
    private IProgressMonitor fMonitor;
    private IWorkbenchWindow window;

    public UpdatePacksHandler() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("UpdatePacksHandler()");
        }
        this.fRunning = false;
        this.fOut = Activator.getInstance().getConsoleOutput();
        this.fRepos = Repos.getInstance();
        this.fDataManager = DataManager.getInstance();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IProgressService context = this.window.getWorkbench().getProgressService();
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    UpdatePacksHandler.this.myRun(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log((Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.log((Throwable)e);
        }
        return null;
    }

    private IStatus myRun(IProgressMonitor monitor) {
        IStatus status;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("UpdatePacksHandler.myRun()");
        }
        if (this.fRunning) {
            return Status.CANCEL_STATUS;
        }
        this.fRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(org.eclipse.embedcdt.packs.core.Utils.getCurrentDateTime());
        this.fOut.println("Update packs job started.");
        int workUnits = 0;
        try {
            String type;
            List reposList = this.fRepos.getList();
            for (Map repo : reposList) {
                if (monitor.isCanceled()) break;
                type = (String)repo.get("type");
                String indexUrl = (String)repo.get("url");
                if ("CMSIS Pack".equals(type)) {
                    LinkedList<String[]> list = new LinkedList<String[]>();
                    this.readCmsisIndex(indexUrl, list);
                    repo.put("list", list);
                    workUnits += list.size();
                    continue;
                }
                if ("Unused".equals(type)) {
                    this.fOut.println(DataUtils.reportWarning((String)("Repo \"" + indexUrl + "\" ignored.")));
                    continue;
                }
                this.fOut.println(DataUtils.reportWarning((String)("Repo type \"" + type + "\" not supported.")));
            }
            monitor.beginTask("Refresh all packs from all repositories.", ++workUnits);
            for (Map repo : reposList) {
                if (monitor.isCanceled()) break;
                type = (String)repo.get("type");
                if (!"CMSIS Pack".equals(type) || !repo.containsKey("list")) continue;
                this.aggregateCmsis(repo);
            }
            monitor.worked(1);
        }
        catch (Exception e) {
            Activator.log((Throwable)e);
            this.fOut.println(DataUtils.reportError((String)e.toString()));
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            this.fDataManager.notifyNewInput();
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            this.fOut.println(DataUtils.reportInfo((String)("Update packs completed in " + (duration + 500L) / 1000L + "s.")));
            status = Status.OK_STATUS;
        }
        this.fRunning = false;
        return status;
    }

    private void readCmsisIndex(String indexUrl, List<String[]> pdscList) {
        this.fOut.println("Parsing \"" + indexUrl + "\"...");
        try {
            int count = Index.readIndex((String)indexUrl, pdscList);
            if (count == 0) {
                this.fOut.println("Malformed index, no packs contributed.");
            } else {
                this.fOut.println("Contributed " + count + " pack(s).");
            }
            return;
        }
        catch (FileNotFoundException e) {
            this.fOut.println(DataUtils.reportError((String)("File not found: " + e.getMessage())));
        }
        catch (Exception e) {
            this.fOut.println(DataUtils.reportError((String)e.toString()));
        }
    }

    private void aggregateCmsis(Map<String, Object> repo) {
        List list = (List)repo.get("list");
        String repoUrl = (String)repo.get("url");
        Node contentRoot = new Node("repository");
        String domainName = Repos.getDomaninNameFromUrl((String)repoUrl);
        domainName = StringUtils.capitalizeFirst((String)domainName);
        contentRoot.setName(domainName);
        contentRoot.setDescription(String.valueOf(domainName) + " CMSIS packs repository");
        contentRoot.putProperty("type", "cmsis.repo");
        contentRoot.putProperty("repo.url", repoUrl);
        contentRoot.putProperty("generator", "Eclipse Embedded C/C++");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar cal = Calendar.getInstance();
        contentRoot.putProperty("date", dateFormat.format(cal.getTime()));
        PdscParserForContent parser = new PdscParserForContent();
        boolean ignoreError = false;
        for (String[] pdsc : list) {
            if (this.fMonitor.isCanceled()) break;
            String pdscUrl = StringUtils.cosmetiseUrl((String)pdsc[0]);
            String pdscName = pdsc[1];
            String pdscVersion = pdsc[2];
            this.fMonitor.subTask(pdscName);
            try {
                URL sourceUrl = new URL(String.valueOf(pdscUrl) + pdscName);
                String cachedFileName = PacksStorage.makeCachedPdscName((String)pdscName, (String)pdscVersion);
                File cachedFile = PacksStorage.getCachedFileObject((String)cachedFileName);
                if (!cachedFile.exists()) {
                    int ret = Utils.copyFileWithShell(sourceUrl, cachedFile, this.fOut, null, this.window.getShell(), ignoreError);
                    if (ret == 0) {
                        DataUtils.reportInfo((String)("File " + pdscName + " version " + pdscVersion + " cached locally."));
                    } else {
                        this.fOut.println(DataUtils.reportWarning((String)("Missing \"" + cachedFile + "\", ignored by user request.")));
                        if (ret != 3) continue;
                        ignoreError = true;
                        continue;
                    }
                }
                if (cachedFile.exists()) {
                    parser.parseXml(cachedFile);
                    parser.parse(pdscName, pdscVersion, contentRoot);
                } else {
                    this.fOut.println(DataUtils.reportWarning((String)("Missing \"" + cachedFile + "\", ignored.")));
                }
            }
            catch (SAXParseException e) {
                String xmsg = "line=" + e.getLineNumber() + ", column=" + e.getColumnNumber() + ", \"" + e.getMessage() + "\"";
                this.fOut.println(String.valueOf(xmsg) + ",  ignored.");
                DataUtils.reportWarning((String)("File " + pdscName + " version " + pdscVersion + " parse error (" + xmsg + "), ignored"));
            }
            catch (Exception e) {
                this.fOut.println(DataUtils.reportWarning((String)("\"" + e.getMessage() + "\", ignored.")));
                DataUtils.reportWarning((String)("File " + pdscName + " version " + pdscVersion + "  error (" + e.getMessage() + "), ignored"));
            }
            this.fMonitor.worked(1);
        }
        if (!this.fMonitor.isCanceled()) {
            try {
                String fileName = this.fRepos.getRepoContentXmlFromUrl(repoUrl);
                ContentSerialiser serialiser = new ContentSerialiser();
                serialiser.serialise(contentRoot, PacksStorage.getFileObject((String)fileName));
                File file = PacksStorage.getFileObject((String)fileName);
                this.fOut.println("File \"" + file.getCanonicalPath() + "\" written.");
                this.fOut.println();
            }
            catch (IOException e) {
                this.fOut.println(DataUtils.reportError((String)e.toString()));
            }
        }
    }
}

