/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.connection.xmlrpc.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ws.commons.util.Base64;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.SerializationException;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EObjectSerializer
extends TypeSerializerImpl {
    public static final String EOBJECT_TAG = "EObject";
    private static final String EX_EOBJECT_TAG = "ex:EObject";
    private static boolean hrefCheckEnabled;
    private static boolean containmentCheckEnabled;
    private static boolean serializationOptionsInitialized;

    public void write(ContentHandler pHandler, Object pObject) throws SAXException {
        block16: {
            EObjectSerializer.initSerializationOptions();
            pHandler.startElement("", "value", "value", ZERO_ATTRIBUTES);
            pHandler.startElement("", EOBJECT_TAG, EX_EOBJECT_TAG, ZERO_ATTRIBUTES);
            char[] buffer = new char[1024];
            Base64.SAXEncoder encoder = new Base64.SAXEncoder(buffer, 0, null, pHandler);
            try {
                URIConverter.WriteableOutputStream uws = null;
                Base64.EncoderOutputStream ostream = new Base64.EncoderOutputStream((Base64.Encoder)encoder);
                BufferedOutputStream bos = new BufferedOutputStream((OutputStream)ostream);
                try {
                    try {
                        EObject eObject = (EObject)pObject;
                        XMIResource resource = (XMIResource)eObject.eResource();
                        if ((eObject instanceof ChangePackage || eObject instanceof IdEObjectCollection) && resource != null) {
                            OutputStreamWriter writer = null;
                            try {
                                writer = new OutputStreamWriter((OutputStream)bos, CommonUtil.getEncoding());
                                uws = new URIConverter.WriteableOutputStream((Writer)writer, CommonUtil.getEncoding());
                                Resource res = eObject.eResource();
                                this.checkResource(res);
                                res.save((OutputStream)uws, ModelUtil.getResourceSaveOptions());
                                break block16;
                            }
                            finally {
                                if (writer != null) {
                                    writer.close();
                                }
                            }
                        }
                        resource = (XMIResource)new ResourceSetImpl().createResource(ModelUtil.VIRTUAL_URI);
                        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
                        Object copy = eObject instanceof IdEObjectCollection ? ModelUtil.copyIdEObjectCollection((IdEObjectCollection)((IdEObjectCollection)eObject), (XMIResource)resource) : ModelUtil.clone((EObject)eObject);
                        if (copy instanceof IdEObjectCollection) {
                            IdEObjectCollection collection = (IdEObjectCollection)eObject;
                            for (EObject element : collection.getAllModelElements()) {
                                if (ModelUtil.isIgnoredDatatype((EObject)element)) continue;
                                ModelElementId elementId = collection.getModelElementId(element);
                                resource.setID(element, elementId.getId());
                            }
                        }
                        resource.getContents().add(copy);
                        StringWriter writer = new StringWriter();
                        uws = new URIConverter.WriteableOutputStream((Writer)writer, CommonUtil.getEncoding());
                        this.checkResource((Resource)resource);
                        resource.save((OutputStream)uws, ModelUtil.getResourceSaveOptions());
                        String string = writer.toString();
                        EObjectSerializer.hrefCheck(string);
                        bos.write(string.getBytes(CommonUtil.getEncoding()));
                    }
                    catch (SerializationException e) {
                        throw new SAXException(e);
                    }
                }
                finally {
                    bos.close();
                    if (uws != null) {
                        uws.close();
                    }
                }
            }
            catch (Base64.SAXIOException e) {
                throw e.getSAXException();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        pHandler.endElement("", EOBJECT_TAG, EX_EOBJECT_TAG);
        pHandler.endElement("", "value", "value");
    }

    private void checkResource(Resource resource) throws SerializationException {
        if (!containmentCheckEnabled) {
            return;
        }
        if (resource.getContents().size() != 1) {
            throw new SerializationException("Resource contains more or less than one EObject!");
        }
        EObject root = (EObject)resource.getContents().get(0);
        Set allChildEObjects = CommonUtil.getNonTransientContents((EObject)root);
        LinkedHashSet<EObject> allEObjects = new LinkedHashSet<EObject>(allChildEObjects);
        allEObjects.add(root);
        for (EObject eObject : allEObjects) {
            if (resource != eObject.eResource()) {
                throw new SerializationException("Resource is not self-contained!");
            }
            if (!eObject.eIsProxy()) continue;
            throw new SerializationException("Serialization failed due to unresolved proxy detection.");
        }
    }

    private static void hrefCheck(String result) throws SerializationException {
        if (!hrefCheckEnabled) {
            return;
        }
        char[] needle = "href".toCharArray();
        int pointer = 0;
        boolean insideQuotes = false;
        char[] cArray = result.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (character == '\"') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (!insideQuotes && character == needle[pointer]) {
                if (++pointer == needle.length) {
                    throw new SerializationException("Serialization failed due to href detection.");
                }
            } else {
                pointer = 0;
            }
            ++n2;
        }
    }

    private static void initSerializationOptions() {
        if (serializationOptionsInitialized) {
            return;
        }
        ESExtensionElement element = new ESExtensionPoint("org.eclipse.emf.emfstore.common.model.serializationOptions").getFirst();
        if (element != null) {
            hrefCheckEnabled = element.getBoolean("HrefCheck");
            containmentCheckEnabled = element.getBoolean("SelfContainmentCheck");
        }
        serializationOptionsInitialized = true;
    }
}

