/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdGenerator;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionCopier;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdEObjectCollectionImpl
extends EObjectImpl
implements IdEObjectCollection,
ESDisposable {
    public static final String MODELELEMENTID_GENERATOR_EXTENSIONPOINT = "org.eclipse.emf.emfstore.common.model.modelelementIdGenerator";
    public static final String MODELELEMENTID_GENERATOR_CLASS_ATTRIBUTE = "class";
    private Map<EObject, String> eObjectToIdMap = new LinkedHashMap<EObject, String>();
    private Map<String, EObject> idToEObjectMap = new LinkedHashMap<String, EObject>();
    private final Map<EObject, String> allocatedEObjectToIdMap = new LinkedHashMap<EObject, String>();
    private final Map<String, EObject> allocatedIdToEObjectMap = new LinkedHashMap<String, EObject>();
    private boolean cachesInitialized;
    private ESModelElementIdGenerator<ModelElementId> modelElementIdGenerator;

    public IdEObjectCollectionImpl() {
        ESExtensionElement element = new ESExtensionPoint(MODELELEMENTID_GENERATOR_EXTENSIONPOINT).getElementWithHighestPriority();
        if (element != null) {
            this.modelElementIdGenerator = (ESModelElementIdGenerator)element.getClass(MODELELEMENTID_GENERATOR_CLASS_ATTRIBUTE, ESModelElementIdGenerator.class);
        }
    }

    public IdEObjectCollectionImpl(XMIResource xmiResource) throws IOException {
        this();
        boolean resourceHasIds = false;
        try {
            if (!xmiResource.isLoaded()) {
                ModelUtil.loadResource((Resource)xmiResource, ModelUtil.getResourceLogger());
            }
        }
        catch (IOException e) {
            ModelUtil.logException(String.format("XMIResource %s could not be loaded.", xmiResource.getURI()), e);
            throw e;
        }
        TreeIterator it = xmiResource.getAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (ModelUtil.isIgnoredDatatype(eObject)) continue;
            String id = xmiResource.getID(eObject);
            ModelElementId eObjectId = this.getNewModelElementID();
            if (id != null) {
                eObjectId.setId(id);
                resourceHasIds = true;
            } else {
                xmiResource.setID(eObject, eObjectId.getId());
            }
            this.putIntoCaches(eObject, eObjectId.getId());
        }
        if (resourceHasIds) {
            this.cachesInitialized = true;
        }
        EList contents = xmiResource.getContents();
        this.setModelElements((EList<EObject>)contents);
        if (!resourceHasIds) {
            ModelUtil.saveResource((Resource)xmiResource, ModelUtil.getResourceLogger());
        }
    }

    @Override
    public abstract EList<EObject> getModelElements();

    protected abstract void setModelElements(EList<EObject> var1);

    @Override
    public void addModelElement(EObject eObject) {
        this.getModelElements().add((Object)eObject);
    }

    @Override
    public boolean contains(EObject modelElement) {
        return this.getEObjectsCache().contains(modelElement);
    }

    @Override
    public boolean contains(ModelElementId id) {
        if (!this.isCacheInitialized()) {
            this.initMapping();
        }
        return this.getIdToEObjectCache().containsKey(id);
    }

    public ModelElementId getDeletedModelElementId(EObject deletedModelElement) {
        String id = this.allocatedEObjectToIdMap.get(deletedModelElement);
        if (id != null) {
            ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
            modelElementId.setId(id);
            return modelElementId;
        }
        return ModelUtil.getSingletonModelElementId(deletedModelElement);
    }

    public EObject getDeletedModelElement(ModelElementId deletedModelElementId) {
        if (deletedModelElementId == null) {
            return null;
        }
        EObject eObject = this.allocatedIdToEObjectMap.get(deletedModelElementId);
        return eObject != null ? eObject : ModelUtil.getSingleton(deletedModelElementId);
    }

    @Override
    public ModelElementId getModelElementId(EObject eObject) {
        if (this == eObject) {
            ModelElementId modelElementId = this.getNewModelElementID();
            modelElementId.setId("001");
            return modelElementId;
        }
        if (!this.eObjectToIdMap.containsKey(eObject) && !this.isCacheInitialized()) {
            Resource resource;
            block6: {
                try {
                    resource = eObject.eResource();
                    if (resource instanceof XMIResource) break block6;
                    return null;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Couldn't load resource for model element " + eObject);
                }
            }
            XMIResource xmiResource = (XMIResource)resource;
            ModelUtil.loadResource((Resource)xmiResource, ModelUtil.getResourceLogger());
            ModelElementId modelElementId = this.getNewModelElementID();
            String id = xmiResource.getID(eObject);
            if (id != null) {
                modelElementId.setId(id);
            }
            this.eObjectToIdMap.put(eObject, modelElementId.getId());
            return modelElementId;
        }
        String id = this.eObjectToIdMap.get(eObject);
        ModelElementId modelElementId = this.getNewModelElementID();
        modelElementId.setId(id);
        return id != null ? modelElementId : ModelUtil.getSingletonModelElementId(eObject);
    }

    @Override
    public EObject getModelElement(ModelElementId modelElementId) {
        EObject eObject;
        if (modelElementId == null) {
            return null;
        }
        if (!this.isCacheInitialized()) {
            this.initMapping();
        }
        return (eObject = this.getIdToEObjectCache().get(modelElementId.getId())) != null ? eObject : ModelUtil.getSingleton(modelElementId);
    }

    @Override
    public void deleteModelElement(EObject modelElement) {
        if (!this.contains(modelElement)) {
            throw new IllegalArgumentException("Cannot delete a model element that is not contained in this project.");
        }
        ModelUtil.deleteOutgoingCrossReferences(this, modelElement);
        Collection crossReferences = EcoreUtil.UsageCrossReferencer.find((EObject)modelElement, (EObject)this);
        ModelUtil.deleteIncomingCrossReferencesFromParent(crossReferences, modelElement);
        EObject containerModelElement = ModelUtil.getContainerModelElement(modelElement);
        if (containerModelElement == null) {
            this.getModelElements().remove((Object)modelElement);
        } else {
            EReference containmentFeature = modelElement.eContainmentFeature();
            if (containmentFeature.isMany()) {
                EList containmentList = (EList)containerModelElement.eGet((EStructuralFeature)containmentFeature);
                containmentList.remove((Object)modelElement);
            } else {
                containerModelElement.eSet((EStructuralFeature)containmentFeature, null);
            }
            this.removeModelElementAndChildrenFromResource(modelElement);
        }
    }

    public void removeModelElementAndChildrenFromResource(EObject eObject) {
        Set<EObject> children = ModelUtil.getAllContainedModelElements(eObject, false);
        for (EObject child : children) {
            this.removeModelElementFromResource(child);
        }
        this.removeModelElementFromResource(eObject);
    }

    private void removeModelElementFromResource(EObject eObject) {
        if (!(eObject.eResource() instanceof XMIResource)) {
            return;
        }
        XMIResource xmiResource = (XMIResource)eObject.eResource();
        if (xmiResource.getURI() == null) {
            return;
        }
        xmiResource.setID(eObject, null);
        try {
            ModelUtil.saveResource((Resource)xmiResource, ModelUtil.getResourceLogger());
        }
        catch (IOException e) {
            throw new RuntimeException("XMI Resource for model element " + eObject + " could not be saved. " + "Reason: " + e.getMessage());
        }
    }

    private ModelElementId getIdForModelElement(EObject modelElement) {
        Resource resource = modelElement.eResource();
        if (resource != null && resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            try {
                ModelUtil.loadResource((Resource)xmiResource, ModelUtil.getResourceLogger());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Resource of model element " + modelElement + " couldn't be loaded");
            }
            String id = xmiResource.getID(modelElement);
            if (id != null) {
                ModelElementId objId = this.getNewModelElementID();
                objId.setId(id);
                return objId;
            }
        }
        return this.getNewModelElementID();
    }

    @Override
    public Set<EObject> getAllModelElements() {
        if (!this.isCacheInitialized()) {
            this.initMapping();
        }
        return Collections.unmodifiableSet(this.eObjectToIdMap.keySet());
    }

    public <T extends EObject> EList<T> getAllModelElementsByClass(EClass modelElementClass, EList<T> list) {
        return this.getAllModelElementsByClass(modelElementClass, list, true);
    }

    @Override
    public <T extends EObject> EList<T> getModelElementsByClass(EClass modelElementClass, EList<T> list) {
        for (EObject modelElement : this.getModelElements()) {
            if (!modelElementClass.isInstance((Object)modelElement)) continue;
            list.add((Object)modelElement);
        }
        return list;
    }

    public <T extends EObject> EList<T> getAllModelElementsByClass(EClass modelElementClass, EList<T> list, Boolean subclasses) {
        if (subclasses.booleanValue()) {
            for (EObject modelElement : this.getAllModelElements()) {
                if (!modelElementClass.isInstance((Object)modelElement)) continue;
                list.add((Object)modelElement);
            }
        } else {
            for (EObject modelElement : this.getAllModelElements()) {
                if (modelElement.eClass() != modelElementClass) continue;
                list.add((Object)modelElement);
            }
        }
        return list;
    }

    @Override
    public <T extends EObject> Set<T> getAllModelElementsByClass(Class<T> modelElementClass) {
        return this.getAllModelElementsByClass(modelElementClass, (Boolean)true);
    }

    @Override
    public <T extends EObject> Set<T> getAllModelElementsByClass(Class<T> modelElementClass, Boolean includeSubclasses) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        if (includeSubclasses.booleanValue()) {
            for (EObject modelElement : this.getAllModelElements()) {
                if (!modelElementClass.isInstance(modelElement)) continue;
                result.add(modelElement);
            }
        } else {
            for (EObject modelElement : this.getAllModelElements()) {
                if (modelElement.getClass() != modelElementClass) continue;
                result.add(modelElement);
            }
        }
        return result;
    }

    protected boolean isCacheInitialized() {
        return this.cachesInitialized;
    }

    protected Map<String, EObject> getIdToEObjectCache() {
        if (!this.isCacheInitialized()) {
            this.initMapping();
        }
        return this.idToEObjectMap;
    }

    protected Set<EObject> getEObjectsCache() {
        if (!this.isCacheInitialized()) {
            this.initMapping();
        }
        return this.eObjectToIdMap.keySet();
    }

    @Override
    public void initMapping() {
        if (this.isCacheInitialized()) {
            return;
        }
        for (EObject modelElement : this.getModelElements()) {
            this.putModelElementIntoCache(modelElement);
        }
        this.cachesInitialized = true;
    }

    protected void putModelElementIntoCache(EObject modelElement) {
        ModelElementId modelElementId = this.getIdForModelElement(modelElement);
        this.putIntoCaches(modelElement, modelElementId.getId());
        TreeIterator it = modelElement.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            ModelElementId id = this.getIdForModelElement(obj);
            this.putIntoCaches(obj, id.getId());
        }
    }

    protected void addModelElementAndChildrenToCache(EObject modelElement) {
        LinkedHashSet<String> removableIds = new LinkedHashSet<String>();
        Set<EObject> containedModelElements = ModelUtil.getAllContainedModelElements(modelElement, false);
        containedModelElements.add(modelElement);
        for (EObject child : containedModelElements) {
            String childId = this.allocatedEObjectToIdMap.get(child);
            if (childId == null) {
                childId = this.getNewModelElementID().getId();
            } else {
                removableIds.add(childId);
            }
            if (!this.isCacheInitialized()) continue;
            this.putIntoCaches(child, childId);
        }
        for (String modelElementId : removableIds) {
            EObject eObject = this.allocatedIdToEObjectMap.get(modelElementId);
            this.allocatedEObjectToIdMap.remove(eObject);
        }
        this.allocatedIdToEObjectMap.keySet().removeAll(removableIds);
    }

    @Override
    public void initMapping(Map<EObject, String> eObjectToIdMap, Map<String, EObject> idToEObjectMap) {
        this.cachesInitialized = true;
        this.eObjectToIdMap = eObjectToIdMap;
        this.idToEObjectMap = idToEObjectMap;
    }

    protected void putIntoCaches(EObject modelElement, String modelElementId) {
        if (!this.eObjectToIdMap.containsKey(modelElement)) {
            this.eObjectToIdMap.put(modelElement, modelElementId);
            this.idToEObjectMap.put(modelElementId, modelElement);
        }
    }

    public <T extends IdEObjectCollection> T copy() {
        IdEObjectCollectionCopier copier = new IdEObjectCollectionCopier();
        IdEObjectCollection result = (IdEObjectCollection)copier.copy(this);
        ((IdEObjectCollectionImpl)result).cachesInitialized = true;
        copier.copyReferences();
        return (T)result;
    }

    public void dispose() {
        this.eObjectToIdMap.clear();
        this.idToEObjectMap.clear();
        this.clearAllocatedCaches();
        this.cachesInitialized = false;
    }

    protected void removeModelElementAndChildrenFromCache(EObject modelElement) {
        if (this.allocatedEObjectToIdMap.containsKey(modelElement)) {
            return;
        }
        this.removeFromCaches(modelElement);
        for (EObject child : ModelUtil.getAllContainedModelElements(modelElement, false)) {
            this.removeFromCaches(child);
        }
    }

    private void removeFromCaches(EObject modelElement) {
        if (this.isCacheInitialized()) {
            ModelElementId id = this.getModelElementId(modelElement);
            this.putIntoAllocatedCaches(modelElement, id);
            this.getEObjectsCache().remove(modelElement);
            this.getIdToEObjectCache().remove(id.getId());
        }
    }

    @Override
    public void allocateModelElementIds(Map<EObject, ModelElementId> eObjectToIdMapping) {
        for (Map.Entry<EObject, ModelElementId> entry : eObjectToIdMapping.entrySet()) {
            EObject modelElement = entry.getKey();
            ModelElementId modelElementId = entry.getValue();
            Boolean isAlreadyContained = this.getModelElement(modelElementId) != null;
            if (isAlreadyContained.booleanValue()) {
                this.eObjectToIdMap.put(modelElement, modelElementId.getId());
                this.idToEObjectMap.put(modelElementId.getId(), modelElement);
            }
            this.putIntoAllocatedCaches(modelElement, modelElementId);
        }
    }

    @Override
    public void disallocateModelElementIds(Set<ModelElementId> modelElementIds) {
        for (ModelElementId modelElementId : modelElementIds) {
            this.allocatedIdToEObjectMap.remove(modelElementId.getId());
            this.allocatedEObjectToIdMap.values().remove(modelElementId.getId());
        }
    }

    @Override
    public void clearAllocatedCaches() {
        this.allocatedEObjectToIdMap.clear();
        this.allocatedIdToEObjectMap.clear();
    }

    private void putIntoAllocatedCaches(EObject modelElement, ModelElementId modelElementId) {
        this.allocatedEObjectToIdMap.put(modelElement, modelElementId.getId());
        this.allocatedIdToEObjectMap.put(modelElementId.getId(), modelElement);
    }

    public String getEObjectId(EObject eObject) {
        ModelElementId modelElementId = this.getModelElementId(eObject);
        if (modelElementId != null) {
            return modelElementId.getId();
        }
        return null;
    }

    private ModelElementId getNewModelElementID() {
        if (this.modelElementIdGenerator != null) {
            ESModelElementIdImpl modelElementId = (ESModelElementIdImpl)((Object)this.modelElementIdGenerator.generateModelElementId(this));
            return (ModelElementId)modelElementId.toInternalAPI();
        }
        return ModelFactory.eINSTANCE.createModelElementId();
    }

    @Override
    public EObject get(ModelElementId modelElementId) {
        EObject modelElement = this.getModelElement(modelElementId);
        if (modelElement != null) {
            return modelElement;
        }
        return this.getDeletedModelElement(modelElementId);
    }

    @Override
    public Map<String, EObject> getIdToEObjectMapping() {
        LinkedHashMap<String, EObject> mapping = new LinkedHashMap<String, EObject>(this.idToEObjectMap);
        mapping.putAll(new LinkedHashMap<String, EObject>(this.allocatedIdToEObjectMap));
        return mapping;
    }

    @Override
    public Map<EObject, String> getEObjectToIdMapping() {
        LinkedHashMap<EObject, String> mapping = new LinkedHashMap<EObject, String>(this.eObjectToIdMap);
        mapping.putAll(new LinkedHashMap<EObject, String>(this.allocatedEObjectToIdMap));
        return mapping;
    }

    public void removeModelElement(EObject modelElement) {
        this.getModelElements().remove((Object)modelElement);
    }
}

