/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.emfstore.common.ESResourceSetProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESPriorityComparator;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.core.helper.EPackageHelper;
import org.eclipse.emf.emfstore.internal.server.core.helper.EmfStoreMethod;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.server.ESServerURIUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class EPackageSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    private static final String E_PACKAGE_REGISTRATION = "EPackage_Registration";

    public EPackageSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        super(parentInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EmfStoreMethod(value=EmfStoreMethod.MethodId.REGISTEREPACKAGE)
    public void registerEPackage(EPackage ePackage) throws ESException {
        Object object = MonitorProvider.getInstance().getMonitor(E_PACKAGE_REGISTRATION);
        synchronized (object) {
            List<EPackage> packages;
            block8: {
                packages = EPackageHelper.getAllSubPackages(ePackage);
                LinkedHashSet<EPackage> rmPackages = new LinkedHashSet<EPackage>();
                packages.add(ePackage);
                for (EPackage subPkg : packages) {
                    if (EPackage.Registry.INSTANCE.getEPackage(subPkg.getNsURI()) == null) continue;
                    rmPackages.add(subPkg);
                }
                packages.removeAll(rmPackages);
                EPackageHelper.removeSubPackages(ePackage, rmPackages);
                if (packages.isEmpty()) {
                    throw new ESException("Registration failed: Package(s) with supplied NsUris(s) is/are already registred!");
                }
                URI dynamicModelUri = ESServerURIUtil.createDynamicModelsURI(ePackage);
                ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.server.resourceSetProvider", true, (Comparator)new ESPriorityComparator("priority", true));
                ESResourceSetProvider resourceSetProvider = (ESResourceSetProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESResourceSetProvider.class);
                ResourceSet resourceSet = resourceSetProvider.getResourceSet();
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                Resource resource = resourceSet.createResource(dynamicModelUri);
                resource.getContents().add((Object)ePackage);
                try {
                    ModelUtil.saveResource((Resource)resource, (IResourceLogger)ModelUtil.getResourceLogger());
                }
                catch (IOException e) {
                    if (e.getCause() instanceof DanglingHREFException) break block8;
                    throw new ESException("Registration failed: Could not persist .ecore!", e);
                }
            }
            for (EPackage registerPackage : packages) {
                EPackage.Registry.INSTANCE.put((Object)registerPackage.getNsURI(), (Object)registerPackage);
            }
            ModelUtil.logInfo((String)("EPackage \"" + ePackage.getNsURI() + "\" registered and saved."));
        }
    }
}

