/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ProjectSpaceBasedExportController;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.util.ResourceHelper;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;

public class ExportProjectSpaceController
extends ProjectSpaceBasedExportController {
    public ExportProjectSpaceController(ProjectSpace projectSpace) {
        super(projectSpace);
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore project space (*" + ExportImportDataUnits.ProjectSpace.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.ProjectSpace.getExtension(), "*.*"};
    }

    public String getLabel() {
        return "project space";
    }

    public String getFilename() {
        PrimaryVersionSpec baseVersion = this.getProjectSpace().getBaseVersion();
        return "ProjectSpace_" + this.getProjectSpace().getProjectName() + "@" + (baseVersion == null ? 0 : baseVersion.getIdentifier()) + ExportImportDataUnits.ProjectSpace.getExtension();
    }

    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.exportProjectSpacePath";
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        if (!FileUtil.getExtension((File)file).equals(ExportImportDataUnits.ProjectSpace.getExtension())) {
            file = new File(file.getAbsoluteFile() + ExportImportDataUnits.ProjectSpace.getExtension());
        }
        ProjectSpace copiedProjectSpace = (ProjectSpace)ModelUtil.clone((EObject)this.getProjectSpace());
        copiedProjectSpace.setUsersession(null);
        Project clonedProject = (Project)ModelUtil.clone((EObject)this.getProjectSpace().getProject());
        copiedProjectSpace.setProject(clonedProject);
        ResourceHelper.putElementIntoNewResourceWithProject(file.getAbsolutePath(), copiedProjectSpace, copiedProjectSpace.getProject());
    }

    public boolean isExport() {
        return true;
    }
}

