/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.login;

import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.sessionprovider.ESAbstractSessionProvider;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.LoginCanceledException;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.LoginDialogController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.ServerInfoSelectionDialog;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.swt.widgets.Display;

public class BasicUISessionProvider
extends ESAbstractSessionProvider {
    private ESServer selectedServerInfo;

    public ESUsersession provideUsersession(ESServer server) throws ESException {
        if (server == null) {
            Integer userInput = RunInUI.runWithResult(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    ServerInfoSelectionDialog dialog = new ServerInfoSelectionDialog(Display.getCurrent().getActiveShell(), (List<ServerInfo>)ESWorkspaceProviderImpl.getInstance().getInternalWorkspace().getServerInfos());
                    int input = dialog.open();
                    BasicUISessionProvider.this.selectedServerInfo = dialog.getResult();
                    return input;
                }
            });
            if (userInput == 0) {
                server = this.selectedServerInfo;
            } else if (userInput == 1) {
                throw new LoginCanceledException(Messages.BasicUISessionProvider_UserCancelledOperation);
            }
        }
        if (server == null) {
            throw new AccessControlException(Messages.BasicUISessionProvider_ServerCouldNotBeDetermined);
        }
        return this.loginServerInfo(server);
    }

    protected ESUsersession loginServerInfo(ESServer server) throws ESException {
        if (server.getLastUsersession() != null && server.getLastUsersession().isLoggedIn()) {
            return server.getLastUsersession();
        }
        return new LoginDialogController().login(server);
    }

    public ESUsersession login(ESUsersession usersession) throws ESException {
        if (usersession != null) {
            return new LoginDialogController().login(usersession);
        }
        return null;
    }
}

