/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import com.google.common.base.Optional;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.ESCollections;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.EMFStoreController;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.helper.ResourceHelper;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ChangePackageFragmentProviderAdapter;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ChangePackageFragmentUploadAdapter;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.BranchInfoMissingException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AncestorVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.DateVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HeadVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PagedUpdateVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.auth.ESMethod;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.exceptions.ESUpdateRequiredException;
import org.eclipse.emf.emfstore.server.model.ESSessionId;
import org.eclipse.emf.emfstore.server.model.ESUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    public VersionSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        super(parentInterface);
    }

    @ESMethod(value=ESMethod.MethodId.RESOLVEVERSIONSPEC)
    public PrimaryVersionSpec resolveVersionSpec(ProjectId projectId, VersionSpec versionSpec) throws InvalidVersionSpecException, ESException {
        this.sanityCheckObjects(projectId, versionSpec);
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
            if (versionSpec instanceof PrimaryVersionSpec) {
                return this.resolvePrimaryVersionSpec(projectHistory, (PrimaryVersionSpec)versionSpec);
            }
            if (versionSpec instanceof HeadVersionSpec) {
                return this.resolveHeadVersionSpec(projectHistory, (HeadVersionSpec)versionSpec);
            }
            if (versionSpec instanceof DateVersionSpec) {
                return this.resolveDateVersionSpec(projectHistory, (DateVersionSpec)versionSpec);
            }
            if (versionSpec instanceof TagVersionSpec) {
                return this.resolveTagVersionSpec(projectHistory, (TagVersionSpec)versionSpec);
            }
            if (versionSpec instanceof BranchVersionSpec) {
                return this.resolveBranchVersionSpec(projectHistory, (BranchVersionSpec)versionSpec);
            }
            if (versionSpec instanceof AncestorVersionSpec) {
                return this.resolveAncestorVersionSpec(projectHistory, (AncestorVersionSpec)versionSpec);
            }
            if (versionSpec instanceof PagedUpdateVersionSpec) {
                return this.resolvePagedUpdateVersionSpec(projectHistory, (PagedUpdateVersionSpec)versionSpec);
            }
            throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_UnknownVersionSpec);
        }
    }

    /*
     * Unable to fully structure code
     */
    private PrimaryVersionSpec resolveAncestorVersionSpec(ProjectHistory projectHistory, AncestorVersionSpec versionSpec) throws InvalidVersionSpecException {
        currentSource = this.getVersion(projectHistory, versionSpec.getSource());
        currentTarget = this.getVersion(projectHistory, versionSpec.getTarget());
        if (currentSource != null && currentTarget != null) ** GOTO lbl13
        throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_Invalid_Source_Or_Target);
lbl-1000:
        // 1 sources

        {
            if (currentSource == currentTarget) {
                return currentSource.getPrimarySpec();
            }
            if (currentSource.getMergedFromVersion().contains((Object)currentTarget)) {
                return currentTarget.getPrimarySpec();
            }
            if (currentSource.getPrimarySpec().getIdentifier() >= currentTarget.getPrimarySpec().getIdentifier()) {
                currentSource = VersionSubInterfaceImpl.findNextVersion(currentSource);
                continue;
            }
            currentTarget = VersionSubInterfaceImpl.findNextVersion(currentTarget);
lbl13:
            // 3 sources

            ** while (currentSource != null && currentTarget != null)
        }
lbl14:
        // 1 sources

        throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_NoAncestorFound);
    }

    private PrimaryVersionSpec resolvePrimaryVersionSpec(ProjectHistory projectHistory, PrimaryVersionSpec versionSpec) throws InvalidVersionSpecException {
        int index = versionSpec.getIdentifier();
        String branch = versionSpec.getBranch();
        int versions = projectHistory.getVersions().size();
        if (index < 0 || index >= versions || branch == null) {
            throw new InvalidVersionSpecException(MessageFormat.format(Messages.VersionSubInterfaceImpl_InvalidVersionRequested, index));
        }
        if (branch.equals("___GLOBAL___")) {
            return ((Version)projectHistory.getVersions().get(index)).getPrimarySpec();
        }
        int i = index;
        while (i >= 0) {
            Version version = (Version)projectHistory.getVersions().get(i);
            if (branch.equals(version.getPrimarySpec().getBranch())) {
                return version.getPrimarySpec();
            }
            --i;
        }
        throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_PrimaryVersionNotFound);
    }

    private PrimaryVersionSpec resolveHeadVersionSpec(ProjectHistory projectHistory, HeadVersionSpec versionSpec) throws InvalidVersionSpecException {
        if ("___GLOBAL___".equals(versionSpec.getBranch())) {
            return ((Version)projectHistory.getVersions().get(projectHistory.getVersions().size() - 1)).getPrimarySpec();
        }
        BranchInfo info = this.getBranchInfo(projectHistory, (VersionSpec)versionSpec);
        if (info != null) {
            return info.getHead();
        }
        throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_HeadVersionNotFound);
    }

    private PrimaryVersionSpec resolveDateVersionSpec(ProjectHistory projectHistory, DateVersionSpec versionSpec) {
        for (Version version : projectHistory.getVersions()) {
            LogMessage logMessage = version.getLogMessage();
            if (logMessage == null || logMessage.getDate() == null || !versionSpec.getDate().before(logMessage.getDate())) continue;
            Version previousVersion = version.getPreviousVersion();
            if (previousVersion == null) {
                return VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
            }
            return previousVersion.getPrimarySpec();
        }
        return projectHistory.getLastVersion().getPrimarySpec();
    }

    private PrimaryVersionSpec resolveTagVersionSpec(ProjectHistory projectHistory, TagVersionSpec versionSpec) throws InvalidVersionSpecException {
        for (Version version : projectHistory.getVersions()) {
            for (TagVersionSpec tag : version.getTagSpecs()) {
                if (!versionSpec.equals(tag)) continue;
                return (PrimaryVersionSpec)ModelUtil.clone((EObject)version.getPrimarySpec());
            }
        }
        throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_TagVersionNotFound);
    }

    private PrimaryVersionSpec resolveBranchVersionSpec(ProjectHistory projectHistory, BranchVersionSpec versionSpec) throws BranchInfoMissingException {
        BranchInfo branchInfo = this.getBranchInfo(projectHistory, (VersionSpec)versionSpec);
        if (branchInfo == null) {
            throw new BranchInfoMissingException(Messages.VersionSubInterfaceImpl_NoBranchInfo);
        }
        return branchInfo.getHead();
    }

    @ESMethod(value=ESMethod.MethodId.UPLOADCHANGEPACKAGEFRAGMENT)
    public String uploadChangePackageFragment(SessionId sessionId, ProjectId projectId, ChangePackageEnvelope envelope) throws ESException {
        ChangePackageFragmentUploadAdapter adapter;
        String proxyId = this.generateProxyId(projectId.getId());
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(sessionId.getId());
        if (resolvedSession == null) {
            throw new ESException(MessageFormat.format(Messages.VersionSubInterfaceImpl_0, sessionId.getId()));
        }
        SessionId session = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        Optional maybeAdapter = ESCollections.find((List)session.eAdapters(), ChangePackageFragmentUploadAdapter.class);
        if (!maybeAdapter.isPresent()) {
            adapter = new ChangePackageFragmentUploadAdapter();
            session.eAdapters().add((Object)adapter);
        } else {
            adapter = (ChangePackageFragmentUploadAdapter)((Object)maybeAdapter.get());
        }
        adapter.addFragment(proxyId, (List<String>)envelope.getFragment());
        if (envelope.isLast()) {
            adapter.markAsComplete(proxyId);
        }
        return proxyId;
    }

    @ESMethod(value=ESMethod.MethodId.DOWNLOADCHANGEPACKAGEFRAGMENT)
    public ChangePackageEnvelope downloadChangePackageFragment(SessionId sessionId, ProjectId projectId, String proxyId, int fragmentIndex) throws ESException {
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(sessionId.getId());
        SessionId session = (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
        Optional maybeAdapter = ESCollections.find((List)session.eAdapters(), ChangePackageFragmentProviderAdapter.class);
        if (!maybeAdapter.isPresent()) {
            throw new ESException(String.valueOf(Messages.VersionSubInterfaceImpl_ChangePackageFragmentProviderAdapterMissing) + sessionId);
        }
        ChangePackageFragmentProviderAdapter adapter = (ChangePackageFragmentProviderAdapter)((Object)maybeAdapter.get());
        ChangePackageEnvelope envelope = VersioningFactory.eINSTANCE.createChangePackageEnvelope();
        List<String> fragment = adapter.getFragment(proxyId, fragmentIndex);
        envelope.getFragment().addAll(fragment);
        envelope.setFragmentCount(adapter.getFragmentSize(proxyId));
        envelope.setFragmentIndex(fragmentIndex);
        if (envelope.isLast()) {
            adapter.markAsConsumed(proxyId);
        }
        return envelope;
    }

    private String generateProxyId(String projectId) {
        return UUID.nameUUIDFromBytes(projectId.getBytes()).toString();
    }

    @ESMethod(value=ESMethod.MethodId.CREATEVERSION)
    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, AbstractChangePackage changePackage, BranchVersionSpec targetBranch, PrimaryVersionSpec sourceVersion, LogMessage logMessage) throws ESException {
        this.getAccessControl().getSessions().isValid((ESSessionId)sessionId.toAPI());
        ESUser rawUser = this.getAccessControl().getSessions().getRawUser((ESSessionId)sessionId.toAPI());
        ACUser tmpUser = (ACUser)((ESUserImpl)ESUserImpl.class.cast(rawUser)).toInternalAPI();
        ESUser copyAndResolveUser = this.getAccessControl().getOrgUnitResolverServive().copyAndResolveUser((ESUser)tmpUser.toAPI());
        ACUser user = (ACUser)((ESUserImpl)ESUserImpl.class.cast(copyAndResolveUser)).toInternalAPI();
        this.sanityCheckObjects(sessionId, projectId, baseVersionSpec, changePackage, logMessage);
        ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
        ModelUtil.logProjectDetails((String)"Creating version on server...", (String)user.getName(), (String)projectHistory.getProjectName(), (String)projectHistory.getProjectId().getId(), (String)(targetBranch != null ? targetBranch.getBranch() : null), (int)baseVersionSpec.getIdentifier());
        if (FileBasedChangePackage.class.isInstance(changePackage) && !ServerConfiguration.useFileBasedChangePackageOnServer()) {
            throw new ESException(Messages.VersionSubInterfaceImpl_FileBasedChangePackageNotAllowed);
        }
        if (ChangePackage.class.isInstance(changePackage) && ServerConfiguration.useFileBasedChangePackageOnServer()) {
            throw new ESException(Messages.VersionSubInterfaceImpl_FileBasedChangePackageExpected);
        }
        PrimaryVersionSpec result = this.internalCreateVersion(projectId, baseVersionSpec, changePackage, targetBranch, sourceVersion, logMessage, user);
        ModelUtil.logProjectDetails((String)"Creating version on server... done", (String)user.getName(), (String)projectHistory.getProjectName(), (String)projectHistory.getProjectId().getId(), (String)(targetBranch != null ? targetBranch.getBranch() : null), (int)baseVersionSpec.getIdentifier());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrimaryVersionSpec internalCreateVersion(ProjectId projectId, PrimaryVersionSpec baseVersionSpec, AbstractChangePackage changePackage, BranchVersionSpec targetBranch, PrimaryVersionSpec sourceVersion, LogMessage logMessage, ACUser user) throws ESException {
        Object object = this.getMonitor();
        synchronized (object) {
            long currentTimeMillis = System.currentTimeMillis();
            ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
            BranchInfo baseBranch = this.getBranchInfo(projectHistory, (VersionSpec)baseVersionSpec);
            Version baseVersion = this.getVersion(projectHistory, baseVersionSpec);
            if (baseVersion == null || baseBranch == null) {
                throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_InvalidBranchOrVersion);
            }
            Version newVersion = null;
            BranchInfo newBranch = null;
            Project newProjectState = (Project)((ProjectImpl)this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(baseVersion)).copy();
            changePackage.apply(newProjectState);
            if (this.isRegularCommit(targetBranch, baseVersion)) {
                newVersion = this.performRegularCommit(baseVersionSpec, logMessage, user, projectHistory, baseBranch, baseVersion, newProjectState);
            } else if (this.isNewBranchCommit(targetBranch, projectHistory)) {
                this.checkNewBranchCommitPreRequisites(targetBranch.getBranch());
                newVersion = this.createVersion(projectHistory, newProjectState, logMessage, user, baseVersion);
                newBranch = this.createNewBranch(projectHistory, baseVersion.getPrimarySpec(), newVersion.getPrimarySpec(), targetBranch);
                newVersion.setAncestorVersion(baseVersion);
            } else {
                throw new IllegalStateException(Messages.VersionSubInterfaceImpl_TargetBranchCombination_Invalid);
            }
            if (sourceVersion != null) {
                newVersion.getMergedFromVersion().add((Object)this.getVersion(projectHistory, sourceVersion));
            }
            try {
                try {
                    this.trySave(projectId, changePackage, projectHistory, newVersion, newProjectState);
                }
                catch (FatalESException e) {
                    this.rollback(projectHistory, baseBranch, baseVersion, newVersion, newBranch, e);
                }
                if (newVersion.getAncestorVersion() == null && baseVersion.getProjectState() != null) {
                    this.deleteOldProjectStateAccordingToOptions(projectId, baseVersion);
                }
                this.save((EObject)baseVersion);
                this.save((EObject)projectHistory);
            }
            catch (FatalESException e) {
                EMFStoreController.getInstance().shutdown(e);
                throw new ESException(Messages.VersionSubInterfaceImpl_ShuttingServerDown);
            }
            ModelUtil.logInfo((String)(String.valueOf(Messages.VersionSubInterfaceImpl_TotalTimeForCommit) + (System.currentTimeMillis() - currentTimeMillis)));
            return newVersion.getPrimarySpec();
        }
    }

    private void checkNewBranchCommitPreRequisites(String targetBranchName) throws InvalidVersionSpecException {
        if (targetBranchName.equals("")) {
            throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_EmptyBranch_Not_Allowed);
        }
        if (targetBranchName.equals("___GLOBAL___")) {
            throw new InvalidVersionSpecException(String.valueOf(Messages.VersionSubInterfaceImpl_BranchName_Reserved_1) + "___GLOBAL___" + Messages.VersionSubInterfaceImpl_BranchName_Reserved_2);
        }
    }

    private Version performRegularCommit(PrimaryVersionSpec baseVersionSpec, LogMessage logMessage, ACUser user, ProjectHistory projectHistory, BranchInfo baseBranch, Version baseVersion, Project newProjectState) throws ESUpdateRequiredException, ESException {
        if (!baseVersionSpec.equals(this.isHeadOfBranch(projectHistory, baseVersion.getPrimarySpec()))) {
            throw new ESUpdateRequiredException();
        }
        Version newVersion = this.createVersion(projectHistory, newProjectState, logMessage, user, baseVersion);
        newVersion.setPreviousVersion(baseVersion);
        baseBranch.setHead((PrimaryVersionSpec)ModelUtil.clone((EObject)newVersion.getPrimarySpec()));
        return newVersion;
    }

    private boolean isNewBranchCommit(BranchVersionSpec targetBranch, ProjectHistory projectHistory) {
        return this.getBranchInfo(projectHistory, (VersionSpec)targetBranch) == null;
    }

    private boolean isRegularCommit(BranchVersionSpec targetBranch, Version baseVersion) {
        return targetBranch == null || baseVersion.getPrimarySpec().getBranch().equals(targetBranch.getBranch());
    }

    private void rollback(ProjectHistory projectHistory, BranchInfo baseBranch, Version baseVersion, Version newVersion, BranchInfo newBranch, FatalESException e) throws StorageException {
        projectHistory.getVersions().remove((Object)newVersion);
        if (newBranch == null) {
            baseVersion.setNextVersion(null);
            baseBranch.setHead((PrimaryVersionSpec)ModelUtil.clone((EObject)baseVersion.getPrimarySpec()));
        } else {
            baseVersion.getBranchedVersions().remove((Object)newVersion);
            projectHistory.getBranches().remove((Object)newBranch);
        }
        throw new StorageException("Couldn't save data in database.", e);
    }

    private void trySave(ProjectId projectId, AbstractChangePackage changePackage, ProjectHistory projectHistory, Version newVersion, Project newProjectState) throws FatalESException {
        this.getResourceHelper().createResourceForProject(newProjectState, newVersion.getPrimarySpec(), projectHistory.getProjectId());
        this.getResourceHelper().createResourceForChangePackage(changePackage, newVersion.getPrimarySpec(), projectId);
        if (FileBasedChangePackage.class.isInstance(changePackage)) {
            try {
                URI uri = changePackage.eResource().getURI();
                URI normalizedUri = changePackage.eResource().getResourceSet().getURIConverter().normalize(uri);
                String filePath = String.valueOf(normalizedUri.toFileString()) + ".1";
                ((FileBasedChangePackage)FileBasedChangePackage.class.cast(changePackage)).move(filePath);
                ModelUtil.saveResource((Resource)changePackage.eResource(), (IResourceLogger)ModelUtil.getResourceLogger());
            }
            catch (IOException ex) {
                throw new FatalESException("Couldn't save data in database.", ex);
            }
        }
        this.getResourceHelper().createResourceForVersion(newVersion, projectHistory.getProjectId());
        newVersion.setProjectStateResource(newProjectState.eResource());
        newVersion.setChangeResource(changePackage.eResource());
    }

    private BranchInfo createNewBranch(ProjectHistory projectHistory, PrimaryVersionSpec baseSpec, PrimaryVersionSpec primarySpec, BranchVersionSpec branch) {
        primarySpec.setBranch(branch.getBranch());
        BranchInfo branchInfo = VersioningFactory.eINSTANCE.createBranchInfo();
        branchInfo.setName(branch.getBranch());
        branchInfo.setSource((PrimaryVersionSpec)ModelUtil.clone((EObject)baseSpec));
        branchInfo.setHead((PrimaryVersionSpec)ModelUtil.clone((EObject)primarySpec));
        projectHistory.getBranches().add((Object)branchInfo);
        return branchInfo;
    }

    private Version createVersion(ProjectHistory projectHistory, Project projectState, LogMessage logMessage, ACUser user, Version previousVersion) throws ESException {
        Version newVersion = VersioningFactory.eINSTANCE.createVersion();
        long computedChecksum = -1L;
        try {
            if (ServerConfiguration.isComputeChecksumOnCommitActive()) {
                computedChecksum = ModelUtil.computeChecksum((IdEObjectCollection)projectState);
                ModelUtil.logProjectDetails((String)MessageFormat.format("Checksum computation during version create: {0}", computedChecksum), (String)user.getName(), (String)projectHistory.getProjectName(), (String)projectHistory.getProjectId().getId(), null, (int)-1);
            }
        }
        catch (SerializationException exception) {
            throw new ESException(MessageFormat.format(Messages.VersionSubInterfaceImpl_ChecksumComputationFailed, projectHistory.getProjectName()), exception);
        }
        logMessage.setDate(new Date());
        logMessage.setAuthor(user.getName());
        newVersion.setLogMessage(logMessage);
        newVersion.setPrimarySpec(Versions.createPRIMARY((VersionSpec)previousVersion.getPrimarySpec(), (int)projectHistory.getVersions().size()));
        newVersion.getPrimarySpec().setProjectStateChecksum(computedChecksum);
        newVersion.setNextVersion(null);
        projectHistory.getVersions().add((Object)newVersion);
        return newVersion;
    }

    private Version getVersion(ProjectHistory projectHistory, PrimaryVersionSpec baseVersionSpec) {
        if (baseVersionSpec.getIdentifier() < 0 || baseVersionSpec.getIdentifier() > projectHistory.getVersions().size() - 1) {
            return null;
        }
        Version version = (Version)projectHistory.getVersions().get(baseVersionSpec.getIdentifier());
        if (version == null || !version.getPrimarySpec().equals(baseVersionSpec)) {
            return null;
        }
        return version;
    }

    private PrimaryVersionSpec isHeadOfBranch(ProjectHistory projectHistory, PrimaryVersionSpec versionSpec) {
        BranchInfo branchInfo = this.getBranchInfo(projectHistory, (VersionSpec)versionSpec);
        if (branchInfo != null && branchInfo.getHead().equals(versionSpec)) {
            return branchInfo.getHead();
        }
        return null;
    }

    private BranchInfo getBranchInfo(ProjectHistory projectHistory, VersionSpec versionSpec) {
        for (BranchInfo branchInfo : projectHistory.getBranches()) {
            if (!branchInfo.getName().equals(versionSpec.getBranch())) continue;
            return branchInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ESMethod(value=ESMethod.MethodId.GETBRANCHES)
    public List<BranchInfo> getBranches(ProjectId projectId) throws ESException {
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
            ArrayList<BranchInfo> result = new ArrayList<BranchInfo>();
            for (BranchInfo branch : projectHistory.getBranches()) {
                result.add((BranchInfo)ModelUtil.clone((EObject)branch));
            }
            return result;
        }
    }

    private void deleteOldProjectStateAccordingToOptions(ProjectId projectId, Version previousHeadVersion) {
        if (VersionSubInterfaceImpl.shouldDeleteOldProjectStateAccordingToOptions(projectId, previousHeadVersion, this.getResourceHelper())) {
            this.getResourceHelper().deleteProjectState(previousHeadVersion, projectId);
        }
    }

    static boolean shouldDeleteOldProjectStateAccordingToOptions(ProjectId projectId, Version previousHeadVersion, ResourceHelper resourceHelper) {
        boolean keepBecauseOfTaggedVersion;
        boolean bl = keepBecauseOfTaggedVersion = ServerConfiguration.createProjectStateOnTag() && !previousHeadVersion.getTagSpecs().isEmpty();
        if (keepBecauseOfTaggedVersion) {
            return false;
        }
        String property = ServerConfiguration.getProperties().getProperty("emfstore.persistence.version.projectstate", "everyXVersion");
        if (property.equals("everyXVersion")) {
            int x = resourceHelper.getXFromPolicy("emfstore.persistence.version.projectstate.everyxversions", "1", false);
            int lastVersion = previousHeadVersion.getPrimarySpec().getIdentifier();
            return lastVersion != 0 && lastVersion % x != 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ESMethod(value=ESMethod.MethodId.GETCHANGES)
    public List<AbstractChangePackage> getChanges(ProjectId projectId, VersionSpec source, VersionSpec target) throws InvalidVersionSpecException, ESException {
        this.sanityCheckObjects(projectId, source, target);
        PrimaryVersionSpec resolvedSource = this.resolveVersionSpec(projectId, source);
        PrimaryVersionSpec resolvedTarget = this.resolveVersionSpec(projectId, target);
        if (resolvedSource.getIdentifier() == resolvedTarget.getIdentifier()) {
            return new ArrayList<AbstractChangePackage>();
        }
        Object object = this.getMonitor();
        synchronized (object) {
            boolean updateForward = resolvedTarget.getIdentifier() > resolvedSource.getIdentifier();
            List<Version> versions = this.getVersions(projectId, resolvedSource, resolvedTarget);
            if (versions.size() > 1) {
                versions.remove(0);
            }
            ArrayList<Object> result = new ArrayList<AbstractChangePackage>();
            for (Version version : versions) {
                AbstractChangePackage changes = version.getChanges();
                if (changes == null) continue;
                changes.setLogMessage((LogMessage)ModelUtil.clone((EObject)version.getLogMessage()));
                result.add(changes);
            }
            if (!updateForward) {
                ArrayList<ChangePackage> resultReverse = new ArrayList<ChangePackage>();
                for (AbstractChangePackage changePackage : result) {
                    ChangePackage changePackageReverse = VersioningFactory.eINSTANCE.createChangePackage();
                    ESCloseableIterable reversedOperations = changePackage.reversedOperations();
                    ArrayList<AbstractOperation> copiedReversedOperations = new ArrayList<AbstractOperation>();
                    try {
                        for (AbstractOperation op : reversedOperations.iterable()) {
                            copiedReversedOperations.add(op.reverse());
                        }
                    }
                    finally {
                        reversedOperations.close();
                    }
                    for (AbstractOperation reversedOperation : copiedReversedOperations) {
                        changePackageReverse.add(reversedOperation);
                    }
                    changePackageReverse.setLogMessage((LogMessage)ModelUtil.clone((EObject)changePackage.getLogMessage()));
                    resultReverse.add(changePackageReverse);
                }
                Collections.reverse(resultReverse);
                result = resultReverse;
            }
            return result;
        }
    }

    protected Version getVersion(ProjectId projectId, PrimaryVersionSpec versionSpec) throws ESException {
        ProjectHistory project = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
        return this.getVersion(project, versionSpec);
    }

    protected List<Version> getVersions(ProjectId projectId, PrimaryVersionSpec source, PrimaryVersionSpec target) throws ESException {
        if (source.compareTo((Object)target) < 1) {
            ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
            Version sourceVersion = this.getVersion(projectHistory, source);
            Version targetVersion = this.getVersion(projectHistory, target);
            if (sourceVersion == null || targetVersion == null) {
                throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_NoSourceNorTarget);
            }
            ArrayList<Version> result = new ArrayList<Version>();
            Version currentVersion = targetVersion;
            while (currentVersion != null) {
                result.add(currentVersion);
                if (currentVersion.equals(sourceVersion)) break;
                if (currentVersion.getPrimarySpec().compareTo((Object)sourceVersion.getPrimarySpec()) < 0) {
                    throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_InvalidPath);
                }
                if (currentVersion.getMergedFromVersion().contains((Object)sourceVersion)) {
                    result.add(sourceVersion);
                    break;
                }
                currentVersion = VersionSubInterfaceImpl.findNextVersion(currentVersion);
            }
            Collections.reverse(result);
            return result;
        }
        return this.getVersions(projectId, target, source);
    }

    public static Version findNextVersion(Version currentVersion) throws InvalidVersionSpecException {
        if (currentVersion.getPreviousVersion() != null) {
            currentVersion = currentVersion.getPreviousVersion();
        } else if (currentVersion.getAncestorVersion() != null) {
            currentVersion = currentVersion.getAncestorVersion();
        } else {
            throw new InvalidVersionSpecException(Messages.VersionSubInterfaceImpl_NextVersionInvalid);
        }
        return currentVersion;
    }

    private PrimaryVersionSpec resolvePagedUpdateVersionSpec(ProjectHistory projectHistory, PagedUpdateVersionSpec baseVersion) {
        int changes = 0;
        PrimaryVersionSpec resolvedSpec = baseVersion.getBaseVersionSpec();
        int maxChanges = baseVersion.getMaxChanges();
        int i = resolvedSpec.getIdentifier();
        AbstractChangePackage cp = ((Version)projectHistory.getVersions().get(i)).getChanges();
        if (i == projectHistory.getVersions().size() - 1) {
            return ((Version)projectHistory.getVersions().get(i)).getPrimarySpec();
        }
        while ((cp = ((Version)projectHistory.getVersions().get(++i)).getChanges()) == null && i < projectHistory.getVersions().size()) {
        }
        if (cp.leafSize() > maxChanges) {
            maxChanges = cp.leafSize();
        }
        while (changes < maxChanges && i < projectHistory.getVersions().size()) {
            resolvedSpec = ((Version)projectHistory.getVersions().get(i)).getPrimarySpec();
            Version version = (Version)projectHistory.getVersions().get(i);
            AbstractChangePackage changePackage = version.getChanges();
            if (changePackage != null) {
                int size = changePackage.leafSize();
                if (changes + size >= maxChanges) {
                    resolvedSpec = ((Version)projectHistory.getVersions().get(i)).getPrimarySpec();
                    break;
                }
                changes += size;
            }
            ++i;
        }
        return resolvedSpec;
    }
}

