/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadataRegistry;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.Schema;
import com.google.gdata.model.TransformKey;
import com.google.gdata.util.common.base.Preconditions;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ElementMetadataRegistryBuilder {
    private final MetadataRegistry root;
    private final Map<TransformKey, ElementCreatorImpl> creators = Maps.newTreeMap();

    ElementMetadataRegistryBuilder(MetadataRegistry root) {
        this.root = root;
    }

    void merge(ElementMetadataRegistryBuilder other) {
        for (Map.Entry<TransformKey, ElementCreatorImpl> entry : other.creators.entrySet()) {
            TransformKey key = entry.getKey();
            ElementCreatorImpl creator = this.creators.get(key);
            if (creator == null) {
                creator = new ElementCreatorImpl(this.root, key);
                this.creators.put(key, creator);
            }
            creator.merge(entry.getValue());
        }
    }

    ElementMetadataRegistry create(Schema schema) {
        return new ElementMetadataRegistry(schema, this);
    }

    boolean isRegistered(ElementKey<?, ?> parent, ElementKey<?, ?> key, MetadataContext context) {
        Preconditions.checkNotNull(key, "key");
        TransformKey transformKey = TransformKey.forTransform(parent, key, context);
        return this.creators.containsKey(transformKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ElementCreatorImpl build(ElementKey<?, ?> parent, ElementKey<?, ?> key, MetadataContext context) {
        Preconditions.checkNotNull(key, "key");
        TransformKey transformKey = TransformKey.forTransform(parent, key, context);
        MetadataRegistry metadataRegistry = this.root;
        synchronized (metadataRegistry) {
            ElementCreatorImpl creator = this.creators.get(transformKey);
            if (creator == null) {
                creator = new ElementCreatorImpl(this.root, transformKey);
                this.creators.put(transformKey, creator);
                this.root.dirty();
            }
            return creator;
        }
    }

    Map<TransformKey, ElementCreatorImpl> getCreators() {
        return ImmutableMap.copyOf(this.creators);
    }
}

