/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.util.collection.SimulinkBlockCollection;

public class SimulinkUtil {
    private static final String GET_BLOCK_HANDLE = "getSimulinkBlockHandle('?');";
    public static final String FIND = "find_system('?', 'FindAll', 'On', 'LookUnderMasks', 'On', 'IncludeCommented', 'On'";
    public static final String FIND_FOLLOW = "find_system('?', 'FindAll', 'On', 'LookUnderMasks', 'On', 'IncludeCommented', 'On', 'FollowLinks', 'on'";
    private static final String FIND_BLOCKS_AT_DEPTH = "find_system('?', 'FindAll', 'On', 'LookUnderMasks', 'On', 'IncludeCommented', 'On', 'SearchDepth', ?, 'Type', 'Block');";

    public static String getSimpleTypeName(String type) {
        if (type.indexOf("/") > -1) {
            String[] parts = type.split("/");
            return parts[parts.length - 1];
        }
        if (type.indexOf(".") > -1) {
            String[] parts = type.split("\\.");
            return parts[parts.length - 1];
        }
        return type;
    }

    public static String getTypePathInModel(SimulinkModel model, String type) {
        return String.valueOf(model.getSimulinkModelName()) + "/" + SimulinkUtil.getSimpleTypeName(type);
    }

    public static String handleMethod(ISimulinkModelElement obj, String methodName, Object[] parameters) {
        Object handle = obj.getHandle();
        return SimulinkUtil.handleMethod(handle, methodName, parameters);
    }

    public static String handleMethod(SimulinkModel obj, String methodName, Object[] parameters) {
        Double handle = obj.getHandle();
        return SimulinkUtil.handleMethod(handle, methodName, parameters);
    }

    private static String handleMethod(Object objHandle, String methodName, Object[] parameters) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("handle");
        list.addAll(Arrays.asList(parameters));
        return "handle = " + objHandle + "; " + SimulinkUtil.handleMethod(methodName, list.toArray());
    }

    public static String handleMethodWithResult(ISimulinkModelElement obj, String methodName, Object[] parameters) {
        Object handle = obj.getHandle();
        return SimulinkUtil.handleMethodWithResult(handle, methodName, parameters);
    }

    public static String handleMethodWithResult(SimulinkModel obj, String methodName, Object[] parameters) {
        Double handle = obj.getHandle();
        return SimulinkUtil.handleMethodWithResult(handle, methodName, parameters);
    }

    private static String handleMethodWithResult(Object objHandle, String methodName, Object[] parameters) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("handle");
        list.addAll(Arrays.asList(parameters));
        return "handle = " + objHandle + "; " + SimulinkUtil.handleMethodWithResult(methodName, list.toArray());
    }

    private static String handleMethodWithResult(String methodName, Object[] parameters) {
        return "result = " + SimulinkUtil.handleMethod(methodName, parameters);
    }

    private static String handleMethod(String methodName, Object[] parameters) {
        String cmd = methodName;
        if (parameters != null && parameters.length > 0) {
            cmd = String.valueOf(cmd) + "(" + parameters[0];
            int i = 1;
            while (i < parameters.length) {
                cmd = String.valueOf(cmd) + ", '" + String.valueOf(parameters[i]) + "'";
                ++i;
            }
            cmd = String.valueOf(cmd) + ");";
        }
        return cmd;
    }

    public static Double getHandle(String path, MatlabEngine engine) {
        try {
            return (Double)engine.evalWithResult(GET_BLOCK_HANDLE, new Object[]{path});
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    public static List<ISimulinkModelElement> getChildren(SimulinkModel model, SimulinkBlock block) throws MatlabException {
        return SimulinkUtil.findBlocks(model, block, 1);
    }

    public static List<ISimulinkModelElement> getChildren(SimulinkModel model) throws MatlabException {
        return SimulinkUtil.findBlocks(model, 1);
    }

    public static List<ISimulinkModelElement> findBlocks(SimulinkModel model, Integer depth) throws MatlabException {
        MatlabEngine engine = model.getEngine();
        Object handles = engine.evalWithResult(FIND_BLOCKS_AT_DEPTH, new Object[]{model.getSimulinkModelName(), depth});
        return new SimulinkBlockCollection(handles, model);
    }

    public static List<ISimulinkModelElement> findBlocks(SimulinkModel model, SimulinkBlock block, Integer depth) throws MatlabException {
        MatlabEngine engine = model.getEngine();
        Object handles = engine.evalWithResult(FIND_BLOCKS_AT_DEPTH, new Object[]{block.getPath(), depth});
        return new SimulinkBlockCollection(handles, model);
    }
}

