/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.dap.EpsilonDebugAdapter;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;

public class EpsilonDebugServer
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(EpsilonDebugServer.class.getCanonicalName());
    private final String host;
    private final int port;
    private final IEolModule module;
    private final CompletableFuture<Boolean> started = new CompletableFuture();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean moduleStarted = new AtomicBoolean(false);
    private final List<Future<Void>> listeningLaunchers = new ArrayList<Future<Void>>();
    private final CompletableFuture<Object> result = new CompletableFuture();
    private Runnable onStart;
    private ServerSocket serverSocket;
    private ExecutorService executorService;
    private final EpsilonDebugAdapter debugAdapter = new EpsilonDebugAdapter();

    public EpsilonDebugServer(IEolModule module, int port) {
        this(module, null, port);
    }

    public EpsilonDebugServer(IEolModule module, String host, int port) {
        if (module == null) {
            throw new IllegalArgumentException("Module must not be null");
        }
        this.host = host;
        this.port = port;
        this.module = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block16: {
            try {
                if (this.running.compareAndSet(false, true)) {
                    this.serverSocket = new ServerSocket(this.port, 0, InetAddress.getByName(this.host));
                    this.started.complete(true);
                    LOGGER.info(() -> String.format("Started Epsilon debug server on %s:%d", this.serverSocket.getInetAddress().getHostName(), this.serverSocket.getLocalPort()));
                    break block16;
                }
                throw new IllegalStateException("Server has already been started");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, String.format("Failed to start server on %s:%d", this.host, this.port), e);
                this.started.complete(false);
            }
        }
        try {
            try {
                if (this.executorService == null) {
                    this.executorService = Executors.newCachedThreadPool();
                }
                if (this.onStart != null) {
                    this.executorService.execute(this.onStart);
                }
                while (this.running.get()) {
                    Socket conn = this.serverSocket.accept();
                    this.debugAdapter.setModule(this.module);
                    this.debugAdapter.setOnAttach(this::onAttach);
                    Launcher launcher = DSPLauncher.createServerLauncher((IDebugProtocolServer)this.debugAdapter, (InputStream)conn.getInputStream(), (OutputStream)conn.getOutputStream(), (ExecutorService)this.executorService, null);
                    this.debugAdapter.connect((IDebugProtocolClient)launcher.getRemoteProxy());
                    List<Future<Void>> list = this.listeningLaunchers;
                    synchronized (list) {
                        this.listeningLaunchers.add(launcher.startListening());
                    }
                }
            }
            catch (SocketException sock) {
                LOGGER.log(Level.FINEST, sock.getMessage(), sock);
                this.shutdown();
            }
            catch (IOException e) {
                throw new RuntimeException("Error during execution of debug server", e);
            }
        }
        finally {
            this.shutdown();
        }
    }

    protected void onAttach() {
        if (this.moduleStarted.compareAndSet(false, true)) {
            this.executorService.execute(this::runModule);
        }
    }

    protected void runModule() {
        try {
            try {
                this.result.complete(this.module.execute());
            }
            catch (Throwable e) {
                this.result.completeExceptionally(e);
                this.shutdown();
            }
        }
        finally {
            this.shutdown();
        }
    }

    public Future<Boolean> isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            int localPort;
            String host;
            block14: {
                host = null;
                localPort = this.port;
                List<Future<Void>> list = this.listeningLaunchers;
                synchronized (list) {
                    for (Future<Void> l : this.listeningLaunchers) {
                        l.cancel(true);
                    }
                    this.listeningLaunchers.clear();
                }
                if (this.executorService != null) {
                    this.executorService.shutdown();
                    try {
                        this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    this.executorService = null;
                }
                if (this.serverSocket != null) {
                    try {
                        try {
                            host = this.serverSocket.getInetAddress().getHostName();
                            localPort = this.serverSocket.getLocalPort();
                            this.serverSocket.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, "Error while shutting down debug server", e);
                            this.serverSocket = null;
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        this.serverSocket = null;
                        throw throwable;
                    }
                    this.serverSocket = null;
                }
            }
            LOGGER.info(String.format("Shut down Epsilon debug server on %s:%d", host, localPort));
        }
    }

    public EpsilonDebugAdapter getDebugAdapter() {
        return this.debugAdapter;
    }

    public String getHost() {
        if (this.running.get()) {
            return this.serverSocket.getInetAddress().getHostName();
        }
        return this.host;
    }

    public int getPort() {
        if (this.running.get()) {
            return this.serverSocket.getLocalPort();
        }
        return this.port;
    }

    public Runnable getOnStart() {
        return this.onStart;
    }

    public void setOnStart(Runnable onStart) {
        this.onStart = onStart;
    }

    public Future<Object> getResult() {
        return this.result;
    }
}

