/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.Position;
import org.eclipse.epsilon.common.parse.Region;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.dap.DeltaLocationConverter;
import org.eclipse.epsilon.eol.dap.LocationConverter;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.SingleFrameReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.debug.BreakpointRequest;
import org.eclipse.epsilon.eol.debug.BreakpointResult;
import org.eclipse.epsilon.eol.debug.BreakpointState;
import org.eclipse.epsilon.eol.debug.IEolDebugger;
import org.eclipse.epsilon.eol.debug.IEpsilonDebugTarget;
import org.eclipse.epsilon.eol.debug.SuspendReason;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.SingleFrame;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.BreakpointEventArguments;
import org.eclipse.lsp4j.debug.BreakpointNotVerifiedReason;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;

public class EpsilonDebugAdapter
implements IDebugProtocolServer {
    public static final String STOP_AT_EVERY_STATEMENT = "stop-at-every-statement";
    private boolean stopAtEveryStatement;
    private static final Logger LOGGER = Logger.getLogger(EpsilonDebugAdapter.class.getCanonicalName());
    private Runnable onAttach;
    private IDebugProtocolClient client;
    private IEolModule mainModule;
    public static final int FIRST_THREAD_ID = 1;
    private final AtomicInteger nextThread = new AtomicInteger(1);
    private final Map<Integer, ThreadState> threads = new HashMap<Integer, ThreadState>();
    private volatile boolean isTerminated = false;
    private LocationConverter lineConverter;
    private LocationConverter columnConverter;
    private Map<String, Multimap<Integer, BreakpointInfo>> lineBreakpointsByPath = new ConcurrentHashMap<String, Multimap<Integer, BreakpointInfo>>();
    private final Map<URI, Path> uriToPathMappings = new HashMap<URI, Path>();
    private final AtomicBoolean suspendedLatch = new AtomicBoolean(false);
    private SuspendedState suspendedState;
    private InitializeRequestArguments initializeArguments;
    private final ModuleCompletionListener completionListener = new ModuleCompletionListener();

    protected PrintStream createStream(IEolContext context, String category) {
        return new PrintStream(new DAPTeeByteArrayOutputStream(context, category), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadState attachTo(IEolModule module) {
        ThreadState thread;
        Map<Integer, ThreadState> map = this.threads;
        synchronized (map) {
            for (ThreadState t : this.threads.values()) {
                if (t.module != module) continue;
                return t;
            }
            int threadId = this.nextThread.getAndIncrement();
            thread = new ThreadState(threadId, module);
            this.threads.put(threadId, thread);
            module.getContext().getExecutorFactory().setExecutionController((ExecutionController)thread.debugger);
        }
        PrintStream outStream = this.createStream(module.getContext(), "stdout");
        module.getContext().setOutputStream(outStream);
        PrintStream errStream = this.createStream(module.getContext(), "stderr");
        module.getContext().setErrorStream(errStream);
        return thread;
    }

    public void connect(IDebugProtocolClient client) {
        if (this.mainModule == null) {
            throw new IllegalStateException("connect(): the module has not been set up yet");
        }
        this.attachTo(this.mainModule);
        this.mainModule.getContext().getExecutorFactory().addExecutionListener((IExecutionListener)this.completionListener);
        this.client = client;
        client.initialized();
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            this.lineConverter = args.getLinesStartAt1() == null || args.getLinesStartAt1() != false ? new DeltaLocationConverter(0) : new DeltaLocationConverter(-1);
            this.columnConverter = args.getColumnsStartAt1() == null || args.getColumnsStartAt1() != false ? new DeltaLocationConverter(1) : new DeltaLocationConverter(0);
            this.initializeArguments = args;
            Capabilities caps = new Capabilities();
            caps.setSupportsTerminateRequest(Boolean.valueOf(true));
            caps.setSupportsConditionalBreakpoints(Boolean.valueOf(true));
            return caps;
        });
    }

    public CompletableFuture<Void> attach(Map<String, Object> args) {
        return CompletableFuture.runAsync(() -> {
            EpsilonDebugAdapter epsilonDebugAdapter = this;
            synchronized (epsilonDebugAdapter) {
                if (this.suspendedState == null) {
                    Object argStop = args.get(STOP_AT_EVERY_STATEMENT);
                    this.stopAtEveryStatement = "true".equals(argStop) || Boolean.TRUE.equals(argStop);
                    this.suspendedState = new SuspendedState();
                    if (this.onAttach != null) {
                        this.onAttach.run();
                    }
                }
            }
        });
    }

    public CompletableFuture<ThreadsResponse> threads() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            Map<Integer, ThreadState> map = this.threads;
            synchronized (map) {
                for (Map.Entry<Integer, ThreadState> entry : this.threads.entrySet()) {
                    Thread lspThread = new Thread();
                    lspThread.setId(entry.getKey().intValue());
                    lspThread.setName(String.format("%s#%d", entry.getValue().module.getClass().getSimpleName(), entry.getKey()));
                    threads.add(lspThread);
                }
            }
            ThreadsResponse r = new ThreadsResponse();
            r.setThreads(threads.toArray(new Thread[threads.size()]));
            return r;
        });
    }

    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            ThreadState thread;
            StackTraceResponse resp = new StackTraceResponse();
            Map<Integer, ThreadState> map = this.threads;
            synchronized (map) {
                thread = this.threads.get(args.getThreadId());
                if (thread == null) {
                    return resp;
                }
            }
            ArrayList<StackFrame> responseFrames = new ArrayList<StackFrame>();
            int i = 0;
            IEolContext moduleContext = thread.module.getContext();
            for (SingleFrame moduleFrame : moduleContext.getFrameStack().getFrames()) {
                StackFrame responseFrame = new StackFrame();
                responseFrames.add(responseFrame);
                IVariableReference mfReference = this.suspendedState.getReference(moduleContext, moduleFrame);
                responseFrame.setId(mfReference.getId());
                responseFrame.setName(this.getStackFrameName(i, (Frame)moduleFrame));
                Tuple.Two<ModuleElement, Source> location = this.resolveStackFrameLocation((IModule)thread.module, (Frame)moduleFrame);
                Position frameStart = ((ModuleElement)location.getFirst()).getRegion().getStart();
                Position frameEnd = ((ModuleElement)location.getFirst()).getRegion().getEnd();
                responseFrame.setLine(this.lineConverter.fromLocalToRemote(frameStart.getLine()));
                responseFrame.setEndLine(Integer.valueOf(this.lineConverter.fromLocalToRemote(frameEnd.getLine())));
                responseFrame.setColumn(this.columnConverter.fromLocalToRemote(frameStart.getColumn()));
                responseFrame.setEndColumn(Integer.valueOf(this.columnConverter.fromLocalToRemote(frameEnd.getColumn())));
                responseFrame.setSource((Source)location.getSecond());
            }
            resp.setStackFrames(responseFrames.toArray(new StackFrame[responseFrames.size()]));
            return resp;
        });
    }

    protected Tuple.Two<ModuleElement, Source> resolveStackFrameLocation(IModule module, Frame sf) {
        Source source;
        if (sf.getCurrentStatement() != null && (source = this.createSource(sf.getCurrentStatement())) != null && source.getPath() != null) {
            return Tuple.two((Object)sf.getCurrentStatement(), (Object)source);
        }
        if (sf.getEntryPoint() != null && (source = this.createSource(sf.getEntryPoint())) != null && source.getPath() != null) {
            return Tuple.two((Object)sf.getEntryPoint(), (Object)source);
        }
        return Tuple.two((Object)module, (Object)this.createSource((ModuleElement)module));
    }

    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            IVariableReference ref = this.suspendedState.getReference(args.getFrameId());
            SingleFrameReference sfRef = null;
            if (!(ref instanceof SingleFrameReference)) {
                return new ScopesResponse();
            }
            sfRef = (SingleFrameReference)ref;
            SingleFrame localFrame = (SingleFrame)sfRef.getTarget();
            Scope sc = new Scope();
            sc.setExpensive(false);
            sc.setVariablesReference(ref.getId());
            sc.setNamedVariables(Integer.valueOf(localFrame.getAll().size()));
            sc.setName(ref.getName());
            ScopesResponse resp = new ScopesResponse();
            resp.setScopes(new Scope[]{sc});
            return resp;
        });
    }

    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            VariablesResponse resp = new VariablesResponse();
            IVariableReference ref = this.suspendedState.getReference(args.getVariablesReference());
            if (ref != null) {
                ArrayList<Variable> respVariables = new ArrayList<Variable>();
                for (IVariableReference vRef : ref.getVariables(this.suspendedState)) {
                    Variable respVariable = new Variable();
                    respVariable.setName(vRef.getName());
                    respVariable.setValue(vRef.getValue());
                    if (this.initializeArguments.getSupportsVariableType().booleanValue()) {
                        respVariable.setType(vRef.getTypeName());
                    }
                    respVariable.setVariablesReference(vRef.getId());
                    respVariables.add(respVariable);
                }
                resp.setVariables(respVariables.toArray(new Variable[respVariables.size()]));
            }
            return resp;
        });
    }

    public CompletableFuture<Void> terminate(TerminateArguments args) {
        return CompletableFuture.runAsync(() -> {
            this.isTerminated = true;
            this.resumeAllThreads();
        });
    }

    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        return CompletableFuture.runAsync(() -> {
            this.isTerminated = true;
            this.client = null;
            this.resumeAllThreads();
        });
    }

    public CompletableFuture<SetExceptionBreakpointsResponse> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        return CompletableFuture.completedFuture(new SetExceptionBreakpointsResponse());
    }

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            SetBreakpointsResponse response = new SetBreakpointsResponse();
            ArrayList<Breakpoint> responseBreakpoints = new ArrayList<Breakpoint>(args.getBreakpoints().length);
            Map<Integer, ThreadState> map = this.threads;
            synchronized (map) {
                String sourcePath = args.getSource().getPath();
                TreeMultimap localLines = TreeMultimap.create();
                SourceBreakpoint[] sourceBreakpointArray = args.getBreakpoints();
                int n = sourceBreakpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SourceBreakpoint sbp = sourceBreakpointArray[n2];
                    BreakpointInfo bpInfo = new BreakpointInfo();
                    bpInfo.condition = sbp.getCondition();
                    if (sbp.getColumn() != null) {
                        bpInfo.column = this.columnConverter.fromRemoteToLocal(sbp.getColumn());
                    }
                    localLines.put((Object)this.lineConverter.fromRemoteToLocal(sbp.getLine()), (Object)bpInfo);
                    ++n2;
                }
                this.removeAllBreakpoints(sourcePath);
                if (!localLines.isEmpty()) {
                    this.lineBreakpointsByPath.put(sourcePath, (Multimap<Integer, BreakpointInfo>)localLines);
                    for (Map.Entry localLine : localLines.entries()) {
                        Breakpoint bp = new Breakpoint();
                        responseBreakpoints.add(bp);
                        bp.setVerified(false);
                        bp.setReason(BreakpointNotVerifiedReason.FAILED);
                        for (ThreadState thread : this.threads.values()) {
                            BreakpointResult result = thread.setBreakpoint(sourcePath, (Integer)localLine.getKey(), (BreakpointInfo)localLine.getValue());
                            this.updateResponseBreakpointFromResult(sourcePath, bp, result);
                        }
                    }
                }
            }
            response.setBreakpoints(responseBreakpoints.toArray(new Breakpoint[responseBreakpoints.size()]));
            return response;
        });
    }

    protected void updateResponseBreakpointFromResult(String sourcePath, Breakpoint bp, BreakpointResult result) {
        switch (result.getState()) {
            case VERIFIED: {
                bp.setVerified(true);
                bp.setReason(null);
                break;
            }
            case PENDING: {
                if (bp.isVerified()) break;
                bp.setVerified(false);
                bp.setReason(BreakpointNotVerifiedReason.PENDING);
                break;
            }
        }
        if (result.getState() != BreakpointState.FAILED) {
            bp.setLine(Integer.valueOf(this.lineConverter.fromLocalToRemote(result.getLine())));
            bp.setSource(this.createSource(result, sourcePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllBreakpoints(String sourcePath) {
        this.lineBreakpointsByPath.remove(sourcePath);
        BreakpointRequest request = new BreakpointRequest(this.uriToPathMappings, sourcePath, 1, 0, null);
        Map<Integer, ThreadState> map = this.threads;
        synchronized (map) {
            for (ThreadState e : this.threads.values()) {
                BreakpointResult result = e.debugger.verifyBreakpoint(request);
                if (result.getModuleURI() == null) continue;
                e.lineBreakpointsByURI.remove(result.getModuleURI());
            }
        }
    }

    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            this.resumeAllThreads();
            ContinueResponse resp = new ContinueResponse();
            resp.setAllThreadsContinued(Boolean.valueOf(true));
            return resp;
        });
    }

    public CompletableFuture<Void> stepIn(StepInArguments args) {
        return CompletableFuture.runAsync(() -> {
            Map<Integer, ThreadState> map = this.threads;
            synchronized (map) {
                ThreadState thread = this.threads.get(args.getThreadId());
                if (thread == null) {
                    throw new IllegalArgumentException("Could not find thread with ID " + args.getThreadId());
                }
                thread.debugger.step();
                this.resumeAllThreads();
            }
        });
    }

    public CompletableFuture<Void> next(NextArguments args) {
        return CompletableFuture.runAsync(() -> {
            Map<Integer, ThreadState> map = this.threads;
            synchronized (map) {
                ThreadState thread = this.threads.get(args.getThreadId());
                if (thread == null) {
                    throw new IllegalArgumentException("Could not find thread with ID " + args.getThreadId());
                }
                thread.debugger.stepOver();
                this.resumeAllThreads();
            }
        });
    }

    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        return CompletableFuture.runAsync(() -> {
            Map<Integer, ThreadState> map = this.threads;
            synchronized (map) {
                ThreadState thread = this.threads.get(args.getThreadId());
                if (thread == null) {
                    throw new IllegalArgumentException("Could not find thread with ID " + args.getThreadId());
                }
                thread.debugger.stepReturn();
                this.resumeAllThreads();
            }
        });
    }

    protected Source createSource(BreakpointResult result, String sourcePath) {
        Source src = new Source();
        if (result.getModule() != null) {
            return this.createSource((ModuleElement)result.getModule());
        }
        this.populateSourceFromMappings(src, result.getModuleURI(), Paths.get(sourcePath, new String[0]));
        return src;
    }

    protected Source createSource(ModuleElement resolvedModule) {
        Source bpSource = new Source();
        URI moduleURI = resolvedModule.getUri();
        if (moduleURI != null && moduleURI.getPath() != null) {
            Path path = "file".equals(moduleURI.getScheme()) ? Paths.get(moduleURI) : Paths.get(moduleURI.getPath(), new String[0]);
            this.populateSourceFromMappings(bpSource, moduleURI, path);
        }
        if (bpSource.getPath() == null && resolvedModule.getFile() != null) {
            File moduleFile = resolvedModule.getFile();
            bpSource.setName(moduleFile.getName());
            try {
                bpSource.setPath(moduleFile.getCanonicalPath());
            }
            catch (IOException e) {
                String rawPath = moduleFile.getPath();
                LOGGER.log(Level.WARNING, String.format("Cannot produce canonical path for '%s': falling back to regular path", rawPath), e);
                bpSource.setPath(rawPath);
            }
        }
        return bpSource;
    }

    protected void populateSourceFromMappings(Source bpSource, URI moduleURI, Path path) {
        String basename = path.getFileName().toString();
        bpSource.setName(basename);
        this.mapUriToSourcePath(moduleURI.toString(), bpSource);
    }

    protected void mapUriToSourcePath(String uri, Source bpSource) {
        for (Map.Entry<URI, Path> mapping : this.uriToPathMappings.entrySet()) {
            Path mappedPath;
            File mappedFile;
            String uriPrefix = mapping.getKey().toString();
            Path pathPrefix = mapping.getValue();
            if (!uri.startsWith(uriPrefix) || !(mappedFile = (mappedPath = pathPrefix.resolve(uri.substring(uriPrefix.length()))).toFile()).exists()) continue;
            try {
                bpSource.setPath(mappedFile.getCanonicalPath());
            }
            catch (IOException e) {
                bpSource.setPath(mappedFile.getPath());
                LOGGER.log(Level.WARNING, String.format("Cannot produce canonical path for '%s': falling back to regular path", mappedFile.getPath()), e);
            }
            break;
        }
    }

    protected void sendExited(int exitCode) {
        if (this.client != null) {
            ExitedEventArguments exitedArgs = new ExitedEventArguments();
            exitedArgs.setExitCode(exitCode);
            this.client.exited(exitedArgs);
        }
    }

    protected void sendTerminated() {
        if (this.client != null) {
            this.client.terminated(new TerminatedEventArguments());
        }
    }

    protected void sendOutput(IEolContext context, String category, String output) {
        if (this.client != null) {
            Position regionStart;
            OutputEventArguments outputArguments = new OutputEventArguments();
            outputArguments.setCategory(category);
            outputArguments.setOutput(output);
            Tuple.Two<ModuleElement, Source> location = this.resolveStackFrameLocation(context.getModule(), context.getFrameStack().getTopFrame());
            ModuleElement currentStatement = (ModuleElement)location.getFirst();
            Region region = currentStatement.getRegion();
            if (region != null && (regionStart = region.getStart()) != null) {
                outputArguments.setLine(Integer.valueOf(this.lineConverter.fromLocalToRemote(regionStart.getLine())));
                outputArguments.setColumn(Integer.valueOf(this.columnConverter.fromLocalToRemote(regionStart.getColumn())));
            }
            outputArguments.setSource((Source)location.getSecond());
            this.client.output(outputArguments);
            LOGGER.fine(() -> "Sent output: " + outputArguments);
        }
    }

    protected void sendStopped(int threadId, String reason) {
        if (this.client != null) {
            StoppedEventArguments stoppedArgs = new StoppedEventArguments();
            stoppedArgs.setReason(reason);
            stoppedArgs.setThreadId(Integer.valueOf(threadId));
            stoppedArgs.setAllThreadsStopped(Boolean.valueOf(true));
            this.client.stopped(stoppedArgs);
        }
    }

    protected void sendThreadEvent(int threadId, String reason) {
        if (this.client != null) {
            ThreadEventArguments args = new ThreadEventArguments();
            args.setReason(reason);
            args.setThreadId(threadId);
            this.client.thread(args);
        }
    }

    public IEolModule getModule() {
        return this.mainModule;
    }

    public void setModule(IEolModule module) {
        this.mainModule = module;
    }

    public void setOnAttach(Runnable onAttach) {
        this.onAttach = onAttach;
    }

    public Map<URI, Path> getUriToPathMappings() {
        return this.uriToPathMappings;
    }

    private String getStackFrameName(int position, Frame frame) {
        ModuleElement entryPoint = frame.getEntryPoint();
        if (entryPoint != null) {
            StringBuilder builder = new StringBuilder();
            if (entryPoint instanceof Operation) {
                builder.append(((ModuleElement)entryPoint.getChildren().get(0)).toString());
            } else {
                builder.append(entryPoint.toString());
            }
            if (entryPoint.getUri() != null) {
                builder.append(" at ");
                builder.append(entryPoint.getUri().toString());
            }
            return builder.toString();
        }
        return "globals";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(int threadId, ModuleElement ast, SuspendReason reason) throws InterruptedException {
        AtomicBoolean atomicBoolean = this.suspendedLatch;
        synchronized (atomicBoolean) {
            switch (reason) {
                case STEP: {
                    this.sendStopped(threadId, "step");
                    break;
                }
                case BREAKPOINT: {
                    this.sendStopped(threadId, "breakpoint");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown suspend reason");
                }
            }
            this.suspendedLatch.set(true);
            do {
                int timeoutMillis = 500;
                this.suspendedLatch.wait(500L);
            } while (this.suspendedLatch.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeAllThreads() {
        AtomicBoolean atomicBoolean = this.suspendedLatch;
        synchronized (atomicBoolean) {
            this.suspendedLatch.set(false);
            this.suspendedLatch.notifyAll();
        }
    }

    protected class BreakpointInfo
    implements Comparable<BreakpointInfo> {
        public String condition;
        public int column;

        protected BreakpointInfo() {
        }

        @Override
        public int compareTo(BreakpointInfo o) {
            return Integer.compare(this.column, o.column);
        }
    }

    protected class DAPTeeByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final IEolContext context;
        private final String category;

        public DAPTeeByteArrayOutputStream(IEolContext context, String category) {
            this.context = context;
            this.category = category;
        }

        @Override
        public void flush() throws IOException {
            String output = new String(this.toByteArray(), StandardCharsets.UTF_8);
            if (output.length() > 0) {
                this.reset();
                EpsilonDebugAdapter.this.sendOutput(this.context, this.category, output);
            }
        }
    }

    protected class ModuleCompletionListener
    implements IExecutionListener {
        private ModuleElement topElement;

        protected ModuleCompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void aboutToExecute(ModuleElement ast, IEolContext context) {
            if (ast.getParent() == null) {
                if (this.topElement == null) {
                    this.topElement = ast;
                    Map map = EpsilonDebugAdapter.this.threads;
                    synchronized (map) {
                        ThreadState firstThread;
                        if (EpsilonDebugAdapter.this.threads.size() == 1 && (firstThread = (ThreadState)EpsilonDebugAdapter.this.threads.values().iterator().next()).getModule() != ast) {
                            EpsilonDebugAdapter.this.threads.clear();
                        }
                    }
                }
                if (ast instanceof IEolModule) {
                    ThreadState threadState = EpsilonDebugAdapter.this.attachTo((IEolModule)ast);
                    EpsilonDebugAdapter.this.sendThreadEvent(threadState.getThreadId(), "started");
                }
            }
        }

        public void finishedExecuting(ModuleElement ast, Object result, IEolContext context) {
            if (ast.getParent() == null && ast instanceof IEolModule) {
                IEolModule eolModule = (IEolModule)ast;
                eolModule.getContext().getOutputStream().flush();
                eolModule.getContext().getErrorStream().flush();
                this.removeThreadFor((IEolModule)ast);
            }
            if (ast == this.topElement) {
                EpsilonDebugAdapter.this.sendTerminated();
                EpsilonDebugAdapter.this.sendExited(0);
                this.topElement = null;
            }
        }

        public void finishedExecutingWithException(ModuleElement ast, EolRuntimeException exception, IEolContext context) {
            if (ast.getParent() == null && ast instanceof IEolModule) {
                IEolModule eolModule = (IEolModule)ast;
                eolModule.getContext().getOutputStream().flush();
                eolModule.getContext().getErrorStream().flush();
                this.removeThreadFor(eolModule);
            }
            if (ast == this.topElement) {
                if (ast instanceof IEolModule) {
                    ((IEolModule)ast).getContext().getErrorStream().println(exception.toString());
                }
                EpsilonDebugAdapter.this.sendTerminated();
                EpsilonDebugAdapter.this.sendExited(1);
                this.topElement = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeThreadFor(IEolModule module) {
            Map map = EpsilonDebugAdapter.this.threads;
            synchronized (map) {
                Iterator itThread = EpsilonDebugAdapter.this.threads.values().iterator();
                while (itThread.hasNext()) {
                    ThreadState thread = (ThreadState)itThread.next();
                    if (thread.module != module) continue;
                    EpsilonDebugAdapter.this.sendThreadEvent(thread.getThreadId(), "exited");
                    itThread.remove();
                }
            }
        }
    }

    protected class ThreadState
    implements IEpsilonDebugTarget {
        protected final int threadId;
        protected final IEolModule module;
        protected final IEolDebugger debugger;
        private Map<URI, Multimap<Integer, BreakpointInfo>> lineBreakpointsByURI = new ConcurrentHashMap<URI, Multimap<Integer, BreakpointInfo>>();

        public ThreadState(int threadId, IEolModule module) {
            this.threadId = threadId;
            this.module = module;
            this.debugger = module.createDebugger();
            this.debugger.setTarget((IEpsilonDebugTarget)this);
            for (Map.Entry e : EpsilonDebugAdapter.this.lineBreakpointsByPath.entrySet()) {
                for (Map.Entry localLine : ((Multimap)e.getValue()).entries()) {
                    this.setBreakpoint((String)e.getKey(), (Integer)localLine.getKey(), (BreakpointInfo)localLine.getValue());
                }
            }
        }

        public int getThreadId() {
            return this.threadId;
        }

        public boolean isTerminated() {
            return EpsilonDebugAdapter.this.isTerminated;
        }

        public boolean hasBreakpointItself(ModuleElement ast) {
            if (ast.getUri() == null) {
                return false;
            }
            Multimap<Integer, BreakpointInfo> lineBreakpoints = this.lineBreakpointsByURI.get(ast.getUri());
            int startLine = ast.getRegion().getStart().getLine();
            if (lineBreakpoints != null && lineBreakpoints.containsKey((Object)startLine)) {
                Collection bpInfos = lineBreakpoints.get((Object)startLine);
                for (BreakpointInfo bpInfo : bpInfos) {
                    if (!EpsilonDebugAdapter.this.stopAtEveryStatement && (ast.getRegion().getStart().getColumn() > bpInfo.column || ast.getRegion().getEnd().getColumn() < bpInfo.column) || bpInfo.condition != null && !this.evaluateBreakpointCondition(ast, startLine, bpInfo)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean evaluateBreakpointCondition(ModuleElement breakpointAst, int startLine, BreakpointInfo bpInfo) {
            EolModule miniEol = new EolModule();
            String eolCondition = bpInfo.condition;
            String eol = "return (" + eolCondition + ").asBoolean();";
            try {
                miniEol.parse(eol);
            }
            catch (Exception e2) {
                LOGGER.log(Level.WARNING, String.format("Exception while parsing condition '%s': disabling breakpoint", eolCondition), e2);
                this.unverifyBreakpoint(breakpointAst, startLine, bpInfo);
                return false;
            }
            if (!miniEol.getParseProblems().isEmpty()) {
                LOGGER.log(Level.WARNING, String.format("Condition '%s' produced parse errors: disabling breakpoint\n%s", eolCondition, String.join((CharSequence)"\n", miniEol.getParseProblems().stream().map(e -> e.toString()).collect(Collectors.toList()))));
                this.unverifyBreakpoint(breakpointAst, startLine, bpInfo);
                return false;
            }
            try {
                this.module.getContext().getFrameStack().enterLocal(FrameType.UNPROTECTED, (ModuleElement)miniEol.getMain(), new org.eclipse.epsilon.eol.execute.context.Variable[0]);
                ExecutorFactory moduleExecutor = this.module.getContext().getExecutorFactory();
                Return returned = (Return)moduleExecutor.execute((ModuleElement)miniEol.getMain(), this.module.getContext());
                if (returned != null && returned.getValue() instanceof Boolean) {
                    boolean bl = (Boolean)returned.getValue();
                    return bl;
                }
                try {
                    LOGGER.log(Level.WARNING, String.format("Condition '%s' did not produce a boolean: disabling breakpoint", eolCondition));
                    this.unverifyBreakpoint(breakpointAst, startLine, bpInfo);
                }
                catch (Exception e3) {
                    LOGGER.log(Level.WARNING, String.format("Exception while evaluating condition '%s': disabling breakpoint", eolCondition), e3);
                    this.unverifyBreakpoint(breakpointAst, startLine, bpInfo);
                }
            }
            finally {
                this.module.getContext().getFrameStack().leaveLocal((ModuleElement)miniEol.getMain());
            }
            return false;
        }

        protected void unverifyBreakpoint(ModuleElement breakpointAst, int startLine, BreakpointInfo bpInfo) {
            Multimap<Integer, BreakpointInfo> lineBreakpoints = this.lineBreakpointsByURI.get(breakpointAst.getUri());
            lineBreakpoints.remove((Object)startLine, (Object)bpInfo);
            BreakpointEventArguments args = new BreakpointEventArguments();
            Breakpoint bp = new Breakpoint();
            bp.setSource(EpsilonDebugAdapter.this.createSource(breakpointAst));
            bp.setLine(Integer.valueOf(startLine));
            bp.setColumn(Integer.valueOf(bpInfo.column));
            bp.setVerified(false);
            args.setBreakpoint(bp);
            args.setReason("changed");
            EpsilonDebugAdapter.this.client.breakpoint(args);
        }

        public void suspend(ModuleElement ast, SuspendReason reason) throws InterruptedException {
            EpsilonDebugAdapter.this.suspend(this.threadId, ast, reason);
        }

        public IEolModule getModule() {
            return this.module;
        }

        protected BreakpointResult setBreakpoint(String sourcePath, Integer localLine, BreakpointInfo info) {
            BreakpointRequest request = new BreakpointRequest(EpsilonDebugAdapter.this.uriToPathMappings, sourcePath, localLine.intValue(), info.column, info.condition);
            BreakpointResult result = this.debugger.verifyBreakpoint(request);
            if (result.getState() != BreakpointState.FAILED) {
                info.column = result.getColumn();
                TreeMultimap uriBreakpoints = this.lineBreakpointsByURI.get(result.getModuleURI());
                if (uriBreakpoints == null) {
                    uriBreakpoints = TreeMultimap.create();
                    this.lineBreakpointsByURI.put(result.getModuleURI(), (Multimap<Integer, BreakpointInfo>)uriBreakpoints);
                }
                uriBreakpoints.put((Object)result.getLine(), (Object)info);
            }
            return result;
        }
    }
}

