/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDException;
import com.github.javabdd.BDDFactory;

public abstract class BDDVarSet {
    public abstract BDDFactory getFactory();

    public abstract BDD toBDD();

    public abstract BDDVarSet id();

    public abstract void free();

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract int[] toArray();

    public abstract int[] toLevelArray();

    public String toString() {
        int[] a = this.toArray();
        StringBuffer sb = new StringBuffer(a.length * 4 + 2);
        sb.append('[');
        for (int i = 0; i < a.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(a[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public BDDDomain[] getDomains() {
        int i;
        int m;
        boolean found;
        int[] ivar;
        BDDDomain dom;
        int n;
        int[] fv = this.toArray();
        int fn = fv.length;
        BDDFactory factory = this.getFactory();
        int num = 0;
        for (n = 0; n < factory.numberOfDomains(); ++n) {
            dom = factory.getDomain(n);
            ivar = dom.vars();
            found = false;
            for (m = 0; m < dom.varNum() && !found; ++m) {
                for (i = 0; i < fn && !found; ++i) {
                    if (ivar[m] != fv[i]) continue;
                    ++num;
                    found = true;
                }
            }
        }
        BDDDomain[] varset = new BDDDomain[num];
        num = 0;
        for (n = 0; n < factory.numberOfDomains(); ++n) {
            dom = factory.getDomain(n);
            ivar = dom.vars();
            found = false;
            for (m = 0; m < dom.varNum() && !found; ++m) {
                for (i = 0; i < fn && !found; ++i) {
                    if (ivar[m] != fv[i]) continue;
                    varset[num++] = dom;
                    found = true;
                }
            }
        }
        return varset;
    }

    public abstract BDDVarSet union(BDDVarSet var1);

    public abstract BDDVarSet union(int var1);

    public abstract BDDVarSet unionWith(BDDVarSet var1);

    public abstract BDDVarSet unionWith(int var1);

    public abstract BDDVarSet intersect(BDDVarSet var1);

    public abstract BDDVarSet intersectWith(BDDVarSet var1);

    public abstract int hashCode();

    public abstract boolean equalsBDDVarSet(BDDVarSet var1);

    public final boolean equals(Object o) {
        if (o instanceof BDDVarSet) {
            return this.equalsBDDVarSet((BDDVarSet)o);
        }
        return false;
    }

    public static class DefaultImpl
    extends BDDVarSet {
        protected BDD b;

        public DefaultImpl(BDD b) {
            this.b = b;
        }

        @Override
        public void free() {
            if (this.b != null) {
                this.b.free();
                this.b = null;
            }
        }

        @Override
        public BDDFactory getFactory() {
            return this.b.getFactory();
        }

        @Override
        public BDDVarSet id() {
            return new DefaultImpl(this.b.id());
        }

        @Override
        public BDDVarSet intersect(BDDVarSet s) {
            DefaultImpl i = (DefaultImpl)s;
            return new DefaultImpl(this.b.or(i.b));
        }

        @Override
        public BDDVarSet intersectWith(BDDVarSet s) {
            DefaultImpl i = (DefaultImpl)s;
            this.b.orWith(i.b);
            i.b = null;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.b.isOne();
        }

        @Override
        public int size() {
            int result = 0;
            BDD r = this.b.id();
            while (!r.isOne()) {
                if (r.isZero()) {
                    throw new BDDException("varset contains zero");
                }
                ++result;
                BDD q = r.high();
                r.free();
                r = q;
            }
            r.free();
            return result;
        }

        @Override
        public int[] toArray() {
            int[] result = new int[this.size()];
            int i = -1;
            BDD r = this.b.id();
            while (!r.isOne()) {
                if (r.isZero()) {
                    throw new BDDException("varset contains zero");
                }
                result[++i] = r.var();
                BDD q = r.high();
                r.free();
                r = q;
            }
            r.free();
            return result;
        }

        @Override
        public BDD toBDD() {
            return this.b.id();
        }

        @Override
        public int[] toLevelArray() {
            int[] result = new int[this.size()];
            int i = -1;
            BDD r = this.b.id();
            while (!r.isOne()) {
                if (r.isZero()) {
                    throw new BDDException("varset contains zero");
                }
                result[++i] = r.level();
                BDD q = r.high();
                r.free();
                r = q;
            }
            r.free();
            return result;
        }

        @Override
        public BDDVarSet union(BDDVarSet s) {
            DefaultImpl i = (DefaultImpl)s;
            return new DefaultImpl(this.b.and(i.b));
        }

        @Override
        public BDDVarSet union(int var) {
            BDD ith = this.b.getFactory().ithVar(var);
            DefaultImpl j = new DefaultImpl(this.b.and(ith));
            ith.free();
            return j;
        }

        @Override
        public BDDVarSet unionWith(BDDVarSet s) {
            DefaultImpl i = (DefaultImpl)s;
            this.b.andWith(i.b);
            i.b = null;
            return this;
        }

        @Override
        public BDDVarSet unionWith(int var) {
            this.b.andWith(this.b.getFactory().ithVar(var));
            return this;
        }

        @Override
        public int hashCode() {
            return this.b.hashCode();
        }

        @Override
        public boolean equalsBDDVarSet(BDDVarSet s) {
            if (s instanceof DefaultImpl) {
                return this.equalsDefaultImpl((DefaultImpl)s);
            }
            return false;
        }

        public boolean equalsDefaultImpl(DefaultImpl s) {
            return this.b.equals(s.b);
        }
    }
}

