/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.plotviz;

import java.awt.Graphics2D;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.escet.common.eclipse.ui.G2dSwtCanvas;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.knowm.xchart.XYChart;

public class PlotVisualizerCanvas
extends G2dSwtCanvas {
    private final XYChart chart;
    private final Object pixelsLock = new Object();
    private final Object paintLock = new Object();
    private byte[] pixels;
    private final AtomicReference<Point> lastSize = new AtomicReference<Object>(null);

    public PlotVisualizerCanvas(Composite parent, XYChart chart) {
        super(parent);
        this.chart = chart;
        this.setupCanvas();
    }

    public Point getLastSize() {
        return this.lastSize.get();
    }

    private void setupCanvas() {
        this.lastSize.set(this.getSize());
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                PlotVisualizerCanvas.this.lastSize.set(PlotVisualizerCanvas.this.getSize());
                PlotVisualizerCanvas.this.updatePixels();
                PlotVisualizerCanvas.this.redraw();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImageToPaint(int width, int height) {
        Object object = this.pixelsLock;
        synchronized (object) {
            if (this.pixels != null) {
                return this.pixels;
            }
        }
        return super.getImageToPaint(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePixels() {
        byte[] newPixels;
        Point paintSize = this.getLastSize();
        paintSize.x = Math.max(1, paintSize.x);
        paintSize.y = Math.max(1, paintSize.y);
        Object object = this.paintLock;
        synchronized (object) {
            newPixels = this.paintInMemory(paintSize.x, paintSize.y);
        }
        object = this.pixelsLock;
        synchronized (object) {
            this.pixels = newPixels;
        }
    }

    public void paint(Graphics2D g, int width, int height) {
        this.chart.paint(g, width, height);
    }
}

