//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2024, 2025 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.common.svg;

import static org.eclipse.escet.common.java.Strings.fmt;

import org.apache.batik.css.parser.Parser;
import org.w3c.css.sac.CSSParseException;

/** CSS parser that wraps parse exceptions with another exception indicating the character at which parsing failed. */
public class SvgCssParser extends Parser {
    @Override
    protected CSSParseException createCSSParseException(String key, Object[] params) {
        CSSParseException ex = super.createCSSParseException(key, params);
        String wrapMsg = fmt("Parsing failed at \"%s\".", scanner.getStringValue());
        return new CSSParseException(wrapMsg, documentURI, scanner.getLine(), scanner.getColumn(), ex);
    }
}
