/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import org.eclipse.escet.cif.simulator.options.SimulationSpeedOption;
import org.eclipse.escet.common.app.framework.options.DoubleOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class FrameRateOption
extends DoubleOption {
    public FrameRateOption() {
        super("Frame rate", "The frame rate, as the number of times per second that output is sent to the output components, such as visualizers. Specify any positive real value RATE as the frame rate. Specify \"auto\" (default) for a frame rate of 20 if a simulation speed is given, and to disable if no simulation speed is given.", null, "frame-rate", "RATE", null, Double.valueOf(0.0), null, true, "The frame rate, as the number of times per second that output is sent to the output components, such as visualizers. The frame rate must be a positive real value.", "Frame rate:", true, Double.valueOf(20.0), "auto", "Automatic (frame rate 20 if simulation speed is given, disabled otherwise)", "Enabled, with a specific frame rate");
    }

    public static Double getFrameRate() {
        Double rslt = (Double)Options.get(FrameRateOption.class);
        if (rslt == null && Options.get(SimulationSpeedOption.class) != null) {
            return 20.0;
        }
        return rslt;
    }

    public static Double getModelTimeDelta() {
        Double frameRate = FrameRateOption.getFrameRate();
        if (frameRate == null) {
            return null;
        }
        double simSpeed = SimulationSpeedOption.getSimSpeed();
        return 1.0 / (frameRate / simSpeed);
    }

    public static boolean isRealTimeEnabled() {
        return FrameRateOption.getFrameRate() != null;
    }

    public void verifyValue(Double value) {
        if (value == null) {
            return;
        }
        FrameRateOption.checkValue((value > 0.0 ? 1 : 0) != 0, (String)(String.valueOf(value) + " <= 0"));
    }
}

