/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.SynchronousProduct;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class NonConflictingCheck {
    private NonConflictingCheck() {
    }

    public static void nonconflictingPreCheck(List<Automaton> automs) {
        for (Automaton aut : automs) {
            if (AutomatonHelper.trimCheck(aut)) continue;
            String msg = Strings.fmt((String)"Unsupported automaton \"%s\": the automaton is not trim.", (Object[])new Object[]{aut.name});
            throw new InvalidInputException(msg);
        }
    }

    public static List<Location> nonconflictingCheck(List<Automaton> automs) {
        Automaton combined = SynchronousProduct.product(automs);
        Set coreachables = Sets.setc((int)10000);
        int count = AutomatonHelper.getNonCoreachableCount(combined, coreachables);
        List counterExamples = Lists.listc((int)count);
        if (count > 0) {
            for (Location loc : combined) {
                if (coreachables.contains(loc)) continue;
                counterExamples.add(loc);
                if (--count == 0) break;
            }
        }
        return counterExamples;
    }
}

