//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.relations.options;

/** Option for specifying the DMM output path of the requirement groups. */
public class RequirementGroupsDmmOutputFileOption extends BaseDmmOutputFileOption {
    /** The kind of DMM of this option. */
    private static final String DMM_KIND = "requirement-groups";

    /** Constructor of the {@link RequirementGroupsDmmOutputFileOption}. */
    public RequirementGroupsDmmOutputFileOption() {
        super(DMM_KIND, null);
    }

    /**
     * Get the absolute or relative local file system path to write the DMM file.
     *
     * @param userInputPath Input path of the CIF file as given by the user.
     * @return If not {@code null}, the path to write the DMM file.
     */
    public static String getFilePath(String userInputPath) {
        return getFilePath(RequirementGroupsDmmOutputFileOption.class, userInputPath, DMM_KIND);
    }
}
