/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcReturnStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PouBuilder {
    private PlcPou pou;
    private final PlcTarget target;
    public final ExprGenerator exprGen;
    public final List<PlcStatement> modelStatements = Lists.list();

    public PouBuilder(PlcTarget target, NameGenerator nameGen, TypeGenerator typeGen, CifDataProvider cifDataProvider) {
        this.target = target;
        this.exprGen = new ExprGenerator(target, nameGen, typeGen, cifDataProvider);
    }

    public void createPou(String name, PlcPouType pouType, PlcType retType) {
        Assert.check((this.pou == null ? 1 : 0) != 0);
        this.pou = new PlcPou(name, pouType, retType);
        this.modelStatements.clear();
    }

    public void addInputParameter(PlcDataVariable param) {
        this.pou.inputVars.add(param);
    }

    public PlcBasicVariable getScratchVariable(String prefix, PlcType plcType) {
        return this.exprGen.getScratchVariable(prefix, plcType);
    }

    public void releaseScratchVariable(PlcBasicVariable variable) {
        this.exprGen.releaseScratchVariable(variable);
    }

    public PlcDataVariable makeVariable(String prefix, PlcType plcType) {
        return this.exprGen.makeLocalVariable(prefix, plcType);
    }

    public void addTempVariable(PlcDataVariable tempVar) {
        this.pou.tempVars.add(tempVar);
    }

    public void addTempVariables(List<PlcDataVariable> tempVars) {
        this.pou.tempVars.addAll(tempVars);
    }

    public void addReturnStatement(PlcExpression value) {
        this.modelStatements.add(new PlcCommentLine(null));
        this.modelStatements.add(new PlcReturnStatement(value));
    }

    public void addReturnStatement(String commentText, PlcExpression value) {
        this.modelStatements.add(new PlcCommentLine(null));
        this.modelStatements.add(new PlcCommentLine(commentText));
        this.modelStatements.add(new PlcReturnStatement(value));
    }

    public void addStatement(PlcStatement stat) {
        this.modelStatements.add(stat);
    }

    public void addStatements(List<PlcStatement> stats) {
        this.modelStatements.addAll(stats);
    }

    public PlcPou getPou() {
        Assert.notNull((Object)this.pou);
        return this.pou;
    }

    public PlcPou finishPou() {
        Assert.notNull((Object)this.pou);
        PlcPou finalPou = this.pou;
        this.pou = null;
        if (!this.modelStatements.isEmpty()) {
            this.target.getModelTextGenerator().toText(this.modelStatements, finalPou.body, finalPou.name, true);
        }
        finalPou.tempVars.addAll(this.exprGen.getCreatedScratchVariables());
        return finalPou;
    }
}

