/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.console;

import org.eclipse.escet.common.app.framework.console.Console;
import org.eclipse.escet.common.app.framework.console.ConsoleTerminateAction;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class ConsolePageParticipant
implements IConsolePageParticipant {
    private IToolBarManager tbman;
    private IAction action;
    private IContributionItem item;

    public void init(IPageBookViewPage page, IConsole console2) {
        Assert.check((boolean)(console2 instanceof Console));
        Console console = (Console)console2;
        console.setConsolePageParticipant(this);
        this.tbman = page.getSite().getActionBars().getToolBarManager();
        this.action = new ConsoleTerminateAction(console);
        this.item = new ActionContributionItem(this.action);
        this.tbman.add(this.item);
    }

    public void dispose() {
        if (this.tbman != null && this.item != null) {
            this.tbman.remove(this.item);
        }
        if (this.item != null) {
            this.item.dispose();
        }
        this.tbman = null;
        this.action = null;
        this.item = null;
    }

    public void activated() {
        this.item.setVisible(true);
        this.tbman.update(true);
    }

    public void deactivated() {
        this.item.setVisible(false);
        this.tbman.update(true);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void disable() {
        final IAction action = this.action;
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                if (action != null) {
                    action.setEnabled(false);
                }
            }
        });
    }
}

