/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator;

import java.util.EnumSet;
import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.options.TestModeOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputType;
import org.eclipse.escet.cif.simulator.output.NormalOutputOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputType;
import org.eclipse.escet.cif.simulator.output.SimulatorOutputProvider;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.common.app.framework.AppEnvData;

public final class CifSimulatorContext {
    public final AppEnvData appEnvData;
    public final SimulatorOutputProvider provider;
    public final EnumSet<NormalOutputType> normal;
    public final EnumSet<DebugOutputType> debug;
    public final boolean realTime;
    public final boolean testMode;

    public CifSimulatorContext(AppEnvData appEnvData) {
        this.appEnvData = appEnvData;
        this.provider = (SimulatorOutputProvider)appEnvData.getProvider();
        this.normal = NormalOutputOption.getOutputTypes();
        this.debug = DebugOutputOption.getDebugTypes();
        this.realTime = FrameRateOption.isRealTimeEnabled();
        this.testMode = TestModeOption.isEnabled();
    }

    public void checkTermination() {
        if (this.appEnvData.isTerminationRequested()) {
            throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
        }
    }
}

