/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.expressions.ui.highlight;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.etrice.expressions.ui.highlight.AbstractHighlightStyles;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class TargetLanguageRuleFactory {
    private static String[] fgKeywords = new String[]{"while", "do", "for", "if", "else", "break", "continue", "switch", "case", "default", "static", "return", "struct", "union", "sizeof", "explicit", "export", "extern", "goto", "this", "throw", "try", "catch", "new", "delete", "public", "private", "protected", "sizeof", "typedef", "virtual", "class", "using", "template", "volatile", "mutable", "friend", "inline", "typeid", "typename", "namespace", "const", "int", "float", "double", "short", "char", "long", "unsigned", "signed", "void", "true", "false", "#include", "#define", "#ifdef", "#endif", "#if", "#else", "#ifndef", "#undef", "#pragma"};

    protected static IWordDetector getKeywordDetector() {
        return new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c) || c == '#';
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        };
    }

    public static List<IRule> getGeneralKeywordRules(AbstractHighlightStyles highlightStyle) {
        Token defaultToken = new Token(highlightStyle.getDefault());
        WordRule wordRule = new WordRule(TargetLanguageRuleFactory.getKeywordDetector(), (IToken)defaultToken);
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token keywordToken = new Token(highlightStyle.getTargetKeyword());
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keywordToken);
            ++i;
        }
        rules.add((IRule)wordRule);
        return rules;
    }

    public static List<IRule> getGeneralLiteralRules(AbstractHighlightStyles highlightStyle) {
        ArrayList rules = Lists.newArrayList();
        Token stringToken = new Token(highlightStyle.getString());
        Token commentToken = new Token(highlightStyle.getComment());
        Token numberToken = new Token(highlightStyle.getNumber());
        rules.add(new EndOfLineRule("//", (IToken)commentToken));
        rules.add(new MultiLineRule("/*", "*/", (IToken)commentToken));
        rules.add(new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)stringToken, '\\'));
        rules.add(new NumberRule((IToken)numberToken));
        return rules;
    }
}

