/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import org.eclipse.gemini.naming.CloseableProviderAdmin;
import org.eclipse.gemini.naming.ContextManagerServiceFactoryImpl;
import org.eclipse.gemini.naming.DefaultRuntimeInitialContextFactoryBuilder;
import org.eclipse.gemini.naming.OSGiURLContextFactoryServiceFactory;
import org.eclipse.gemini.naming.ProviderAdminImpl;
import org.eclipse.gemini.naming.SecurityAwareProviderAdminImpl;
import org.eclipse.gemini.naming.TraditionalInitialContextFactoryBuilder;
import org.eclipse.gemini.naming.TraditionalObjectFactoryBuilder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jndi.JNDIContextManager;
import org.osgi.service.jndi.JNDIProviderAdmin;

public class Activator
implements BundleActivator {
    private static final String OSGI_URL_SCHEME = "osgi";
    private static Logger logger = Logger.getLogger(Activator.class.getName());
    private BundleContext m_bundleContext = null;
    private final List m_listOfServiceRegistrations = new LinkedList();
    private CloseableProviderAdmin m_providerAdminService;
    private ContextManagerServiceFactoryImpl m_contextManagerServiceFactory;

    public void start(BundleContext context) throws Exception {
        logger.info("Initializing Gemini Naming Factory Manager Bundle");
        this.m_bundleContext = context;
        logger.info("Installing Static Singletons");
        Activator.registerInitialContextFactoryBuilderSingleton();
        Activator.registerObjectFactoryBuilderSingleton();
        logger.info("Registering URL Context Factory for 'osgi' URL scheme");
        this.registerOSGiURLContextFactory();
        logger.info("Registering Default Runtime Builder for JRE-provided factories");
        this.registerDefaultRuntimeBuilder();
        logger.info("Registering ContextManager service");
        this.registerContextManager();
        logger.info("Registering ProviderAdmin service");
        this.registerProviderAdmin();
    }

    public void stop(BundleContext context) throws Exception {
        logger.info("Shutting down Gemini Naming Factory Manager Bundle");
        this.m_contextManagerServiceFactory.closeAll();
        this.m_providerAdminService.close();
        for (ServiceRegistration serviceRegistration : this.m_listOfServiceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private static void registerInitialContextFactoryBuilderSingleton() throws NamingException {
        try {
            NamingManager.setInitialContextFactoryBuilder(new TraditionalInitialContextFactoryBuilder());
        }
        catch (IllegalStateException illegalStateException) {
            logger.log(Level.SEVERE, "Gemini Naming Implementation cannot set the InitialContextFactoryBuilder - another builder was already installed", illegalStateException);
            NamingException namingException = new NamingException("Error occurred while attempting to set the IntialContextFactoryBuilder.");
            namingException.setRootCause(illegalStateException);
            throw namingException;
        }
        catch (SecurityException securityException) {
            logger.log(Level.SEVERE, "Gemini Naming Implementation did not have the proper security permissions to install the InitialContextFactoryBuilder", securityException);
            NamingException namingException = new NamingException("Error occurred while attempting to set the IntialContextFactoryBuilder.");
            namingException.setRootCause(securityException);
            throw namingException;
        }
    }

    private static void registerObjectFactoryBuilderSingleton() throws NamingException {
        try {
            NamingManager.setObjectFactoryBuilder(new TraditionalObjectFactoryBuilder());
        }
        catch (IllegalStateException illegalStateException) {
            logger.log(Level.SEVERE, "Gemini Naming Implementation cannot set the ObjectFactoryBuilder - another builder was already installed", illegalStateException);
            NamingException namingException = new NamingException("Error occurred while attempting to set the ObjectFactoryBuilder.");
            namingException.setRootCause(illegalStateException);
            throw namingException;
        }
        catch (SecurityException securityException) {
            logger.log(Level.SEVERE, "Gemini Naming Implementation did not have the proper security permissions to install the ObjectFactoryBuilder", securityException);
            NamingException namingException = new NamingException("Error occurred while attempting to set the ObjectFactoryBuilder.");
            namingException.setRootCause(securityException);
            throw namingException;
        }
    }

    private void registerOSGiURLContextFactory() {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("osgi.jndi.url.scheme", OSGI_URL_SCHEME);
        ServiceRegistration serviceRegistration = this.m_bundleContext.registerService(ObjectFactory.class.getName(), (Object)new OSGiURLContextFactoryServiceFactory(), serviceProperties);
        this.m_listOfServiceRegistrations.add(serviceRegistration);
    }

    private void registerDefaultRuntimeBuilder() {
        ServiceRegistration serviceRegistration = this.m_bundleContext.registerService(InitialContextFactoryBuilder.class.getName(), (Object)new DefaultRuntimeInitialContextFactoryBuilder(), null);
        this.m_listOfServiceRegistrations.add(serviceRegistration);
    }

    private void registerContextManager() {
        this.m_contextManagerServiceFactory = new ContextManagerServiceFactoryImpl(this.m_bundleContext);
        ServiceRegistration serviceRegistration = this.m_bundleContext.registerService(JNDIContextManager.class.getName(), (Object)this.m_contextManagerServiceFactory, null);
        this.m_listOfServiceRegistrations.add(serviceRegistration);
    }

    private void registerProviderAdmin() {
        this.m_providerAdminService = new SecurityAwareProviderAdminImpl(new ProviderAdminImpl(this.m_bundleContext));
        ServiceRegistration serviceRegistration = this.m_bundleContext.registerService(JNDIProviderAdmin.class.getName(), (Object)this.m_providerAdminService, null);
        this.m_listOfServiceRegistrations.add(serviceRegistration);
    }
}

