/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.internal.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEventType;

public class FileChangeEvent {
    private FileChangeEventType eventType;
    private IFile oldFile;
    private IFile file;
    private IPath oldFilePath;
    private IPath filePath;

    public FileChangeEvent(FileChangeEventType anEventType, IFile aFile) {
        assert (anEventType == FileChangeEventType.CHANGED || anEventType == FileChangeEventType.DELETED);
        this.setEventType(anEventType);
        this.setFile(aFile);
        this.setOldFile(null);
    }

    public FileChangeEvent(FileChangeEventType anEventType, IFile anOldFile, IFile newFile) {
        assert (anEventType == FileChangeEventType.RENAMED || anEventType == FileChangeEventType.MOVED);
        this.setEventType(anEventType);
        this.setFile(newFile);
        this.setOldFile(anOldFile);
    }

    public FileChangeEventType getEventType() {
        return this.eventType;
    }

    public IFile getFile() {
        return this.file;
    }

    public IFile getOldFile() {
        return this.oldFile;
    }

    private void setEventType(FileChangeEventType type) {
        this.eventType = type;
    }

    private void setFile(IFile aFile) {
        this.file = aFile;
    }

    private void setOldFile(IFile aFile) {
        this.oldFile = aFile;
    }

    public IPath getOldFilePath() {
        if (this.oldFilePath == null) {
            this.oldFilePath = this.oldFile.getFullPath();
        }
        return this.oldFilePath;
    }

    public IPath getFilePath() {
        if (this.filePath == null) {
            this.filePath = this.file.getFullPath();
        }
        return this.filePath;
    }
}

