/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.ui.IWorkbenchPage;

public class AlignAction
extends DiagramAction {
    private String id;
    private int alignment;
    private boolean isToolbarItem = true;

    public AlignAction(IWorkbenchPage workbenchPage, String id, int align) {
        super(workbenchPage);
        this.id = id;
        this.alignment = align;
        this.initUI();
    }

    public AlignAction(IWorkbenchPage workbenchPage, String id, int align, boolean isToolbarItem) {
        super(workbenchPage);
        this.id = id;
        this.alignment = align;
        this.isToolbarItem = isToolbarItem;
        this.initUI();
    }

    protected void initUI() {
        this.setId(this.id);
        String text = null;
        String toolTipText = null;
        AlignmentAction gefAlignmentAction = new AlignmentAction(this.getWorkbenchPart(), this.alignment);
        this.setHoverImageDescriptor(gefAlignmentAction.getHoverImageDescriptor());
        this.setImageDescriptor(gefAlignmentAction.getImageDescriptor());
        this.setDisabledImageDescriptor(gefAlignmentAction.getDisabledImageDescriptor());
        gefAlignmentAction.dispose();
        switch (this.alignment) {
            case 1: {
                if (this.isToolbarItem) {
                    text = DiagramUIActionsMessages.AlignLeftToolbarAction_Label;
                    toolTipText = DiagramUIActionsMessages.AlignLeftToolbarAction_Tooltip;
                    break;
                }
                text = DiagramUIActionsMessages.AlignLeft;
                toolTipText = DiagramUIActionsMessages.AlignLeft;
                break;
            }
            case 4: {
                if (this.isToolbarItem) {
                    text = DiagramUIActionsMessages.AlignRightToolbarAction_Label;
                    toolTipText = DiagramUIActionsMessages.AlignRightToolbarAction_Tooltip;
                    break;
                }
                text = DiagramUIActionsMessages.AlignRight;
                toolTipText = DiagramUIActionsMessages.AlignRight;
                break;
            }
            case 8: {
                if (this.isToolbarItem) {
                    text = DiagramUIActionsMessages.AlignTopToolbarAction_Label;
                    toolTipText = DiagramUIActionsMessages.AlignTopToolbarAction_Tooltip;
                    break;
                }
                text = DiagramUIActionsMessages.AlignTop;
                toolTipText = DiagramUIActionsMessages.AlignTop;
                break;
            }
            case 32: {
                if (this.isToolbarItem) {
                    text = DiagramUIActionsMessages.AlignBottomToolbarAction_Label;
                    toolTipText = DiagramUIActionsMessages.AlignBottomToolbarAction_Tooltip;
                    break;
                }
                text = DiagramUIActionsMessages.AlignBottom;
                toolTipText = DiagramUIActionsMessages.AlignBottom;
                break;
            }
            case 2: {
                if (this.isToolbarItem) {
                    text = DiagramUIActionsMessages.AlignCenterToolbarAction_Label;
                    toolTipText = DiagramUIActionsMessages.AlignCenterToolbarAction_Tooltip;
                    break;
                }
                text = DiagramUIActionsMessages.AlignCenter;
                toolTipText = DiagramUIActionsMessages.AlignCenter;
                break;
            }
            case 16: {
                if (this.isToolbarItem) {
                    text = DiagramUIActionsMessages.AlignMiddleToolbarAction_Label;
                    toolTipText = DiagramUIActionsMessages.AlignMiddleToolbarAction_Tooltip;
                    break;
                }
                text = DiagramUIActionsMessages.AlignMiddle;
                toolTipText = DiagramUIActionsMessages.AlignMiddle;
            }
        }
        this.setText(text);
        this.setToolTipText(toolTipText);
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }

    protected List createOperationSet() {
        List editparts = super.createOperationSet();
        if ((editparts = ToolUtilities.getSelectionWithoutDependants((List)editparts)).size() < 2) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    protected Request createTargetRequest() {
        AlignmentRequest request = new AlignmentRequest((Object)"align");
        request.setAlignment(this.alignment);
        return request;
    }

    protected void updateTargetRequest() {
        AlignmentRequest request = (AlignmentRequest)this.getTargetRequest();
        request.setAlignmentRectangle(this.calculateAlignmentRectangle());
        super.updateTargetRequest();
    }

    protected Rectangle calculateAlignmentRectangle() {
        List editparts = this.getOperationSet();
        if (editparts == null || editparts.isEmpty()) {
            return null;
        }
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(editparts.size() - 1);
        PrecisionRectangle rect = new PrecisionRectangle(part.getFigure().getBounds());
        part.getFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }
}

