/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.internal.ModelingUnitElementDispatcher;

public final class ResourceDeclarationSerializer {
    private ResourceDeclarationSerializer() {
    }

    public static String render(ResourceDeclaration resourceDeclaration, ModelingUnitElementDispatcher dispatcher) {
        int initialOffset = dispatcher.getCurrentOffset();
        String renderedForm = "Resource ";
        int declarationLength = renderedForm.length();
        if (resourceDeclaration.getName() != null && resourceDeclaration.getName().length() > 0) {
            renderedForm = String.valueOf(renderedForm) + resourceDeclaration.getName();
            declarationLength = renderedForm.length();
            renderedForm = String.valueOf(renderedForm) + " ";
        }
        renderedForm = String.valueOf(renderedForm) + "{\n";
        if (resourceDeclaration.getUri() != null) {
            renderedForm = String.valueOf(renderedForm) + "URI = " + resourceDeclaration.getUri() + ';' + "\n";
        }
        if (resourceDeclaration.getContentType() != null) {
            renderedForm = String.valueOf(renderedForm) + "contentType = " + resourceDeclaration.getContentType() + ';' + "\n";
        }
        for (ModelingUnitInstructionReference content : resourceDeclaration.getContent()) {
            renderedForm = String.valueOf(renderedForm) + "content += ";
            dispatcher.setCurrentOffset(initialOffset + renderedForm.length());
            renderedForm = String.valueOf(renderedForm) + (String)dispatcher.doSwitch((EObject)content) + ';' + "\n";
        }
        renderedForm = String.valueOf(renderedForm) + "}";
        if (resourceDeclaration.isLineBreak()) {
            renderedForm = String.valueOf(renderedForm) + "\n";
        }
        dispatcher.getPositionManager().setPositionForInstruction((EObject)resourceDeclaration, initialOffset, renderedForm.length(), declarationLength);
        dispatcher.setCurrentOffset(initialOffset + renderedForm.length());
        return renderedForm;
    }
}

