/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import org.junit.Before;
import org.testng.Reporter;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class StepLevelPropertiesTests {
    private JobOperatorBridge jobOp = null;
    private int PROPERTIES_COUNT = 3;
    private String FOO_VALUE = "bar";

    @Test
    @org.junit.Test
    public void testStepLevelPropertiesCount() throws Exception {
        String METHOD = "testStepLevelPropertiesCount";
        String SHOULD_BE_UNAVAILABLE_PROP_PREFIX = "com.ibm.jbatch.tck.tests.jslxml.StepLevelPropertiesTests";
        Properties jobParams = new Properties();
        jobParams.put(SHOULD_BE_UNAVAILABLE_PROP_PREFIX + ".parm1", "should.not.appear.in.step.context.properties");
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("step_level_properties_count");
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Job completed", "VERY GOOD INVOCATION", jobExec.getExitStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStepLevelPropertiesPropertyValue() throws Exception {
        String METHOD = "testStepLevelPropertiesPropertyValue";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("step_level_properties_value");
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
            AssertionUtils.assertWithMessage("Property value", this.FOO_VALUE, jobExec.getExitStatus());
            Reporter.log((String)("Job batchlet return code is the step property foo value " + this.FOO_VALUE));
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testStepLevelPropertiesShouldNotBeAvailableThroughJobContext() throws Exception {
        String METHOD = "testStepLevelPropertiesShouldNotBeAvailableThroughJobContext";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("step_level_properties_scope");
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
            AssertionUtils.assertWithMessage("Step Level Property is not available through job context", BatchStatus.COMPLETED.name(), jobExec.getExitStatus());
            Reporter.log((String)("Job batchlet return code is the step.property read through job context (expected value=COMPLETED) " + jobExec.getExitStatus()));
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    public void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            StepLevelPropertiesTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    @BeforeTest
    @Before
    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    @AfterTest
    public void afterTest() {
        this.jobOp = null;
    }
}

