/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import org.junit.Before;
import org.testng.Reporter;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SplitTransitioningTests {
    private JobOperatorBridge jobOp = null;

    @Test
    @org.junit.Test
    public void testSplitTransitionToStep() throws Exception {
        String METHOD = "testSplitTransitionToStep";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("split_transition_to_step", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Split transitioned to step", "step1", jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testSplitTransitionToStepOutOfScope() throws Exception {
        String METHOD = "testSplitTransitionToStepOutOfScope";
        try {
            Reporter.log((String)"starting job");
            boolean seenException = false;
            TCKJobExecutionWrapper jobExec = null;
            try {
                jobExec = this.jobOp.startJobAndWaitForResult("split_transition_to_step_out_of_scope", null);
            }
            catch (JobStartException e) {
                Reporter.log((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                Reporter.log((String)("Didn't catch JobstartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    @Test
    @org.junit.Test
    public void testSplitTransitionToDecision() throws Exception {
        String METHOD = "testSplitTransitionToDecision";
        try {
            String exitStatus = "ThatsAllFolks";
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("split_transition_to_decision", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job Exit Status is from decider", exitStatus, jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    public void cleanup() {
    }

    public void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    @BeforeTest
    @Before
    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    @AfterTest
    public void afterTest() {
        this.jobOp = null;
    }
}

