/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Address;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.ContainerElementsOrder;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.Item;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.OrderLine;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.ProductCategory;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.User;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidateConstructorParametersTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ValidateConstructorParametersTest.webArchiveBuilder().withTestClass(ValidateConstructorParametersTest.class)).withPackage(MyCrossParameterConstraint.class.getPackage())).withClass(Address.class)).withClass(Item.class)).withClass(OrderLine.class)).withClass(User.class)).withClass(ContainerElementsOrder.class)).withClass(ProductCategory.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="g"), @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolation() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class);
        String arg0 = "B";
        Object[] parameterValues = new Object[]{arg0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, Size.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("firstName", 0));
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertNull((Object)violation.getRootBean());
        Assert.assertEquals((Object)violation.getRootBeanClass(), User.class);
        Assert.assertNull((Object)violation.getLeafBean());
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)arg0);
        Assert.assertEquals((Object[])violation.getExecutableParameters(), (Object[])parameterValues);
        Assert.assertNull((Object)violation.getExecutableReturnValue());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="j")})
    public void testOneViolationFromCrossParameterConstraint() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).crossParameter());
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)parameterValues);
        Assert.assertNull((Object)violation.getLeafBean());
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testTwoViolations() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, CharSequence.class);
        Object[] parameterValues = new Object[]{null, "S"};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 2);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, NotNull.class, Size.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("firstName", 0), ConstraintViolationAssert.pathWith().constructor(User.class).parameter("lastName", 1));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testTwoViolationsOnSameParameter() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, Integer.TYPE);
        Object[] parameterValues = new Object[]{"S", 0};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 2);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, Pattern.class, Size.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("firstName", 0), ConstraintViolationAssert.pathWith().constructor(User.class).parameter("firstName", 0));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testTwoConstraintsOfSameType() throws Exception {
        Constructor constructor = User.class.getConstructor(CharSequence.class);
        Object[] parameterValues = new Object[]{"S"};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 2);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, Size.class, Size.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("lastName", 0), ConstraintViolationAssert.pathWith().constructor(User.class).parameter("lastName", 0));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testCrossParameterConstraintGivenSeveralTimes() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, String.class, String.class);
        Object[] parameterValues = new Object[]{null, null, null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 2);
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class, MyCrossParameterConstraint.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).crossParameter(), ConstraintViolationAssert.pathWith().constructor(User.class).crossParameter());
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testNoViolations() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, CharSequence.class);
        Object[] parameterValues = new Object[]{"Bob", "Smith"};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testValidationWithGroup() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, Long.TYPE);
        Object[] parameterValues = new Object[]{"S", 0L};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{User.Extended.class});
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, Size.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("lastName", 0));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testCrossParameterConstraintValidationWithGroup() throws Exception {
        Constructor constructor = User.class.getConstructor(CharSequence.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{User.Extended.class});
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, MyCrossParameterConstraint.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).crossParameter());
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="h")
    public void testValidationWithSeveralGroups() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class, String.class, Date.class);
        Object[] parameterValues = new Object[]{null, "S", null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 0);
        violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{User.Basic.class, User.Extended.class});
        ConstraintViolationAssert.assertCorrectConstraintTypes(violations, NotNull.class, Size.class, NotNull.class);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().constructor(User.class).parameter("firstName", 0), ConstraintViolationAssert.pathWith().constructor(User.class).parameter("lastName", 1), ConstraintViolationAssert.pathWith().constructor(User.class).parameter("dateOfBirth", 2));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="g")
    public void testUnexpectedType() throws Exception {
        Constructor constructor = Address.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{"S"};
        this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="i")
    public void testNullPassedForConstructorCausesException() throws Exception {
        Constructor constructor = null;
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="i")
    public void testNullPassedForParameterValuesCausesException() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class);
        Object[] parameterValues = null;
        this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="i")
    public void testNullPassedForGroupsCausesException() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, (Class[])null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="i")
    public void testNullPassedAsSingleGroupCausesException() throws Exception {
        Constructor constructor = User.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[]{null});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testOneViolationForCascadedValidation() throws Exception {
        Item leaf = new Item("foo");
        Constructor constructor = OrderLine.class.getConstructor(Item.class);
        Object[] parameterValues = new Object[]{leaf};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 1);
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)leaf);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)"foo");
        Assert.assertEquals((Object[])violation.getExecutableParameters(), (Object[])parameterValues);
        Assert.assertNull((Object)violation.getExecutableReturnValue());
    }

    @Test
    @SpecAssertion(section="validationapi-constraintviolation", id="f")
    public void testContainerElementLeafBean() throws NoSuchMethodException, SecurityException {
        Constructor constructor = ContainerElementsOrder.class.getConstructor(String.class, Map.class);
        Item invalidItem = new Item("s");
        HashMap<ProductCategory, List<OrderLine>> invalidLines = new HashMap<ProductCategory, List<OrderLine>>();
        invalidLines.put(null, Arrays.asList(new OrderLine(new Item("item name"))));
        invalidLines.put(ProductCategory.MUSIC, Arrays.asList(new OrderLine(invalidItem)));
        Object[] parameterValues = new Object[]{"name", invalidLines};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withLeafBean(null), ConstraintViolationAssert.violationOf(Size.class).withLeafBean(invalidItem));
    }
}

