/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;
import javax.validation.ClockProvider;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.tests.time.PastDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.PastRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ClockProviderPastTest
extends AbstractTCKTest {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ClockProviderPastTest.webArchiveBuilder().withTestClassPackage(ClockProviderPastTest.class)).build();
    }

    @Test
    @SpecAssertion(section="builtinconstraints-past", id="a")
    public void clockProviderIsUsed() {
        PastDummyEntity dummy = new PastDummyEntity(ZonedDateTime.of(1985, 6, 12, 3, 0, 0, 0, TZ_BERLIN));
        Validator validator = TestUtil.getValidatorUnderTest();
        ConstraintViolationAssert.assertNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 0);
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(1984, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 13);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("date"), ConstraintViolationAssert.pathWith().property("calendar"), ConstraintViolationAssert.pathWith().property("instant"), ConstraintViolationAssert.pathWith().property("hijrahDate"), ConstraintViolationAssert.pathWith().property("japaneseDate"), ConstraintViolationAssert.pathWith().property("localDate"), ConstraintViolationAssert.pathWith().property("localDateTime"), ConstraintViolationAssert.pathWith().property("minguoDate"), ConstraintViolationAssert.pathWith().property("offsetDateTime"), ConstraintViolationAssert.pathWith().property("thaiBuddhistDate"), ConstraintViolationAssert.pathWith().property("year"), ConstraintViolationAssert.pathWith().property("yearMonth"), ConstraintViolationAssert.pathWith().property("zonedDateTime"));
    }

    @Test
    @SpecAssertion(section="builtinconstraints-past", id="a")
    public void clockProviderIsUsedForRelativePartials() {
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone(TZ_BERLIN));
        cal.set(2016, 6, 6);
        cal.set(11, 14);
        cal.set(12, 45);
        PastRelativePartialDummyEntity dummy = new PastRelativePartialDummyEntity(ZonedDateTime.of(2016, 6, 6, 14, 45, 0, 0, TZ_BERLIN));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2016, 8, 15, 16, 15, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        ConstraintViolationAssert.assertNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 0);
        clockProvider = new FixedClockProvider(ZonedDateTime.of(2014, 4, 4, 9, 45, 0, 0, TZ_BERLIN));
        validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(violations, 3);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("localTime"), ConstraintViolationAssert.pathWith().property("monthDay"), ConstraintViolationAssert.pathWith().property("offsetTime"));
    }
}

