/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.containerelementlevel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.assertj.core.api.Assertions;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.CollectionHelper;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ContainerElementTypeConstraintsForParameterXmlMappingTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ContainerElementTypeConstraintsForParameterXmlMappingTest.webArchiveBuilder().withTestClass(ContainerElementTypeConstraintsForParameterXmlMappingTest.class)).withResource("parameter-canDeclareContainerElementTypeConstraints-mapping.xml")).withResource("parameter-canDeclareNestedContainerElementTypeConstraints-mapping.xml")).withResource("parameter-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml")).withResource("parameter-canDeclareContainerElementCascades-mapping.xml")).withResource("parameter-declaringContainerElementTypeConstraintOnNonGenericParameterCausesException-mapping.xml")).withResource("parameter-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnParameterCausesException-mapping.xml")).withResource("parameter-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnParameterCausesException-mapping.xml")).withResource("parameter-omittingTypeArgumentForMultiTypeArgumentTypeOnParameterCausesException-mapping.xml")).withResource("parameter-configuringSameContainerElementTwiceCausesException-mapping.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareContainerElementTypeConstraintsForParameterWithXmlMapping() {
        Validator validator = this.getValidator("parameter-canDeclareContainerElementTypeConstraints-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            HashMap<String, Integer> fishCountByType = new HashMap<String, Integer>();
            fishCountByType.put("A", -1);
            fishCountByType.put("BB", -2);
            fishTank.test1(Optional.of("Too long"), fishCountByType);
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 0 and 5"), ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareNestedContainerElementTypeConstraintsForParameterWithXmlMapping() {
        Validator validator = this.getValidator("parameter-canDeclareNestedContainerElementTypeConstraints-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            HashMap<String, List<Fish>> fishOfTheMonth = new HashMap<String, List<Fish>>();
            List<Fish> january = Arrays.asList(null, new Fish());
            fishOfTheMonth.put("january", january);
            fishTank.test2(fishOfTheMonth);
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareDeeplyNestedContainerElementTypeConstraintsForParameterWithXmlMapping() {
        Validator validator = this.getValidator("parameter-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            Set<String> bobsTags = CollectionHelper.asSet(new String[]{null});
            HashMap<String, Set<String>> januaryTags = new HashMap<String, Set<String>>();
            januaryTags.put("bob", bobsTags);
            ArrayList<Map<String, Set<String>>> tagsOfFishOfTheMonth = new ArrayList<Map<String, Set<String>>>();
            tagsOfFishOfTheMonth.add(januaryTags);
            fishTank.test3(tagsOfFishOfTheMonth);
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="d"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="h")})
    public void canDeclareContainerElementCascadesForParameterWithXmlMapping() {
        Validator validator = this.getValidator("parameter-canDeclareContainerElementCascades-mapping.xml");
        IFishTank fishTank = (IFishTank)TestUtil.getValidatingProxy(new FishTank(), validator, new Class[0]);
        try {
            fishTank.test4(Optional.of(new Fish()));
            Assertions.fail((String)"Expected exception wasn't raised");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="j")
    public void declaringContainerElementTypeConstraintOnNonGenericParameterCausesException() {
        this.getValidator("parameter-declaringContainerElementTypeConstraintOnNonGenericParameterCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnParameterCausesException() {
        this.getValidator("parameter-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnParameterCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnParameterCausesException() {
        this.getValidator("parameter-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnParameterCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="l")
    public void omittingTypeArgumentForMultiTypeArgumentTypeOnParameterCausesException() {
        this.getValidator("parameter-omittingTypeArgumentForMultiTypeArgumentTypeOnParameterCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="m")
    public void configuringSameContainerElementTwiceCausesException() {
        this.getValidator("parameter-configuringSameContainerElementTwiceCausesException-mapping.xml");
    }

    private Validator getValidator(String mappingFile) {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile));
        return config.buildValidatorFactory().getValidator();
    }

    public static class Fish {
        public String name;
    }

    public static class FishTank
    implements IFishTank {
        @Override
        public void test1(Optional<String> model, Map<String, Integer> fishCountByType) {
        }

        @Override
        public void test2(Map<String, List<Fish>> fishOfTheMonth) {
        }

        @Override
        public void test3(List<Map<String, Set<String>>> tagsOfFishOfTheMonth) {
        }

        @Override
        public void test4(Optional<Fish> boss) {
        }

        @Override
        public void setSize(int size) {
        }
    }

    public static interface IFishTank {
        public void test1(Optional<String> var1, Map<String, Integer> var2);

        public void test2(Map<String, List<Fish>> var1);

        public void test3(List<Map<String, Set<String>>> var1);

        public void test4(Optional<Fish> var1);

        public void setSize(int var1);
    }
}

