/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.protocol.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.protocol.metadata.NamedContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPContext
extends NamedContext {
    private final String host;
    private final int port;
    private final Set<Servlet> servlets;

    public HTTPContext(String host, int port) {
        this("no-named", host, port);
    }

    public HTTPContext(String name, String host, int port) {
        super(name);
        if (host == null) {
            throw new IllegalArgumentException("host must not be null");
        }
        this.host = host;
        this.port = port;
        this.servlets = new HashSet<Servlet>();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public HTTPContext add(Servlet servlet) {
        servlet.setParent(this);
        this.servlets.add(servlet);
        return this;
    }

    public List<Servlet> getServlets() {
        return new ArrayList<Servlet>(this.servlets);
    }

    public Servlet getServletByName(String name) {
        for (Servlet servlet : this.getServlets()) {
            if (!servlet.getName().equals(name)) continue;
            return servlet;
        }
        return null;
    }

    public String toString() {
        return "HTTPContext [host=" + this.host + ", port=" + this.port + ", servlets=" + this.toString(this.servlets) + "]";
    }

    private String toString(Set<Servlet> servlets) {
        StringBuilder sb = new StringBuilder();
        if (servlets != null) {
            for (Servlet obj : servlets) {
                sb.append('\n').append(obj);
            }
        }
        return sb.toString();
    }
}

