/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement;

import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.valueextraction.ValueExtractor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.Address;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.AddressType;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.Cinema;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.EmailAddress;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.Reference;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.ReferenceValueExtractor;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.SomeReference;
import org.hibernate.beanvalidation.tck.tests.validation.graphnavigation.containerelement.model.Visitor;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class NestedCascadingOnContainerElementsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)NestedCascadingOnContainerElementsTest.webArchiveBuilder().withTestClassPackage(NestedCascadingOnContainerElementsTest.class)).withPackage(Cinema.class.getPackage())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="m")})
    public void testNestedValid() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)EmailAddressMap.validEmailAddressMap(), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        constraintViolations = validator.validate((Object)EmailAddressMap.invalidEmailAddressMap(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "invalid", null, Map.class, 1).property("email", true, null, 1, List.class, 0)), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, "invalid", null, Map.class, 1).property("email", true, null, 2, List.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="m")})
    public void testNestedValidWithTwoInnerExtractions() {
        Validator validator = this.getValidator();
        Set constraintViolations = validator.validate((Object)AddressBook.valid(), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        constraintViolations = validator.validate((Object)AddressBook.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("addressesPerTypePerPerson").containerElement("<map value>", true, "Firstname Lastname", null, Map.class, 1).property("type", true, AddressType.invalid(), null, Map.class, 0)), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("addressesPerTypePerPerson").containerElement("<map value>", true, "Firstname Lastname", null, Map.class, 1).property("zipCode", true, AddressType.invalid(), null, Map.class, 1)), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("addressesPerTypePerPerson").containerElement("<map value>", true, "Firstname Lastname", null, Map.class, 1).property("zipCode", true, AddressType.valid(), null, Map.class, 1)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="m"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="c")})
    public void testMultipleNestedValidWithCustomExtractor() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new ReferenceValueExtractor()).buildValidatorFactory().getValidator();
        Set constraintViolations = validator.validate((Object)CinemaEmailAddresses.validCinemaEmailAddresses(), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        CinemaEmailAddresses invalidCinemaEmailAddresses = CinemaEmailAddresses.invalidCinemaEmailAddresses();
        constraintViolations = validator.validate((Object)invalidCinemaEmailAddresses, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, invalidCinemaEmailAddresses.map.keySet().toArray()[1], null, Map.class, 1).property("email", true, null, 1, List.class, 0)), ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, invalidCinemaEmailAddresses.map.keySet().toArray()[1], null, Map.class, 1).property("email", true, null, 2, List.class, 0)), ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map value>", true, invalidCinemaEmailAddresses.map.keySet().toArray()[2], null, Map.class, 1).containerElement("<list element>", true, null, 0, List.class, 0)));
        CinemaEmailAddresses invalidKeyCinemaEmailAddresses = CinemaEmailAddresses.invalidKey();
        constraintViolations = validator.validate((Object)invalidKeyCinemaEmailAddresses, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("map").containerElement("<map key>", true, invalidKeyCinemaEmailAddresses.map.keySet().toArray()[1], null, Map.class, 0).property("visitor", Optional.class, 0).property("name", Reference.class, 0)));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="l"), @SpecAssertion(section="constraintdeclarationvalidationprocess-requirements-graphvalidation", id="m"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="c")})
    public void testNestedNullValue() {
        Validator validator = Validation.byDefaultProvider().configure().addValueExtractor((ValueExtractor)new ReferenceValueExtractor()).buildValidatorFactory().getValidator();
        Set constraintViolations = validator.validate((Object)NestedCascadingListWithValidAllAlongTheWay.valid(), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        constraintViolations = validator.validate((Object)NestedCascadingListWithValidAllAlongTheWay.withNullList(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("list").containerElement("<list element>", true, null, 0, List.class, 0)));
    }

    private static class AddressBook {
        private Map<String, Map<@Valid AddressType, @Valid Address>> addressesPerTypePerPerson = new HashMap<String, Map<AddressType, Address>>();

        private AddressBook() {
        }

        private static AddressBook valid() {
            HashMap<AddressType, Address> addressesPerType = new HashMap<AddressType, Address>();
            addressesPerType.put(AddressType.valid(), Address.valid());
            AddressBook addressBook = new AddressBook();
            addressBook.addressesPerTypePerPerson.put("Firstname Lastname", addressesPerType);
            return addressBook;
        }

        private static AddressBook invalid() {
            HashMap<AddressType, Address> addressesPerType = new HashMap<AddressType, Address>();
            addressesPerType.put(AddressType.valid(), Address.valid());
            addressesPerType.put(AddressType.valid(), Address.invalid());
            addressesPerType.put(AddressType.invalid(), Address.invalid());
            AddressBook addressBook = new AddressBook();
            addressBook.addressesPerTypePerPerson.put("Firstname Lastname", addressesPerType);
            return addressBook;
        }
    }

    private static class NestedCascadingListWithValidAllAlongTheWay {
        private List<@NotNull List<@NotNull @Valid Cinema>> list;

        private NestedCascadingListWithValidAllAlongTheWay() {
        }

        private static NestedCascadingListWithValidAllAlongTheWay valid() {
            NestedCascadingListWithValidAllAlongTheWay valid = new NestedCascadingListWithValidAllAlongTheWay();
            valid.list = Arrays.asList(Arrays.asList(new Cinema("cinema1", new SomeReference<Visitor>(new Visitor("Name 1")))));
            return valid;
        }

        private static NestedCascadingListWithValidAllAlongTheWay withNullList() {
            NestedCascadingListWithValidAllAlongTheWay valid = new NestedCascadingListWithValidAllAlongTheWay();
            valid.list = Arrays.asList(new List[]{null});
            return valid;
        }
    }

    private static class CinemaArray {
        private List<@NotNull @Valid Cinema>[] array;

        private CinemaArray() {
        }

        private static CinemaArray validCinemaArray() {
            CinemaArray cinemaArray = new CinemaArray();
            cinemaArray.array = new List[]{Arrays.asList(new Cinema("cinema1", new SomeReference<Visitor>(new Visitor("Name 1"))))};
            return cinemaArray;
        }

        private static CinemaArray invalidCinemaArray() {
            CinemaArray cinemaArray = new CinemaArray();
            cinemaArray.array = new List[]{Arrays.asList(null, new Cinema("cinema2", new SomeReference<Visitor>(new Visitor())))};
            return cinemaArray;
        }
    }

    private static class CinemaEmailAddresses {
        private final Map<@NotNull Optional<@Valid Cinema>, List<@NotNull @Valid EmailAddress>> map = new LinkedHashMap<Optional<Cinema>, List<EmailAddress>>();

        private CinemaEmailAddresses() {
        }

        private static CinemaEmailAddresses validCinemaEmailAddresses() {
            CinemaEmailAddresses cinemaEmailAddresses = new CinemaEmailAddresses();
            cinemaEmailAddresses.map.put(Optional.of(new Cinema("cinema1", new SomeReference<Visitor>(new Visitor("Name 1")))), Arrays.asList(new EmailAddress("valid-email-1@example.com"), new EmailAddress("valid-email-2@example.com")));
            return cinemaEmailAddresses;
        }

        private static CinemaEmailAddresses invalidCinemaEmailAddresses() {
            CinemaEmailAddresses cinemaEmailAddresses = CinemaEmailAddresses.validCinemaEmailAddresses();
            cinemaEmailAddresses.map.put(Optional.of(new Cinema("cinema2", new SomeReference<Visitor>(new Visitor("Name 2")))), Arrays.asList(new EmailAddress("valid-email-3@example.com"), new EmailAddress(" "), new EmailAddress("  ")));
            cinemaEmailAddresses.map.put(Optional.of(new Cinema("cinema3", new SomeReference<Visitor>(new Visitor("Name 3")))), Arrays.asList(new EmailAddress[]{null}));
            return cinemaEmailAddresses;
        }

        private static CinemaEmailAddresses invalidKey() {
            CinemaEmailAddresses cinemaEmailAddresses = CinemaEmailAddresses.validCinemaEmailAddresses();
            cinemaEmailAddresses.map.put(Optional.of(new Cinema("cinema4", new SomeReference<Visitor>(new Visitor()))), Arrays.asList(new EmailAddress("valid-email-4@example.com")));
            return cinemaEmailAddresses;
        }
    }

    private static class EmailAddressMap {
        private final Map<String, List<@Valid EmailAddress>> map = new LinkedHashMap<String, List<EmailAddress>>();

        private EmailAddressMap() {
        }

        private static EmailAddressMap validEmailAddressMap() {
            List<EmailAddress> validEmailAddresses = Arrays.asList(new EmailAddress("valid-email-1@example.com"), new EmailAddress("valid-email-2@example.com"));
            EmailAddressMap emailAddressMap = new EmailAddressMap();
            emailAddressMap.map.put("valid", validEmailAddresses);
            return emailAddressMap;
        }

        private static EmailAddressMap invalidEmailAddressMap() {
            List<EmailAddress> validEmailAddresses = Arrays.asList(new EmailAddress("valid-email-1@example.com"), new EmailAddress("valid-email-2@example.com"));
            List<EmailAddress> emailAddressesContainingInvalidEmails = Arrays.asList(new EmailAddress("valid-email-3@example.com"), new EmailAddress(" "), new EmailAddress("  "));
            EmailAddressMap emailAddressMap = new EmailAddressMap();
            emailAddressMap.map.put("valid", validEmailAddresses);
            emailAddressMap.map.put("invalid", emailAddressesContainingInvalidEmails);
            return emailAddressMap;
        }
    }
}

