/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ContainerElementConstraintOptionalTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ContainerElementConstraintOptionalTest.webArchiveBuilder().withTestClass(ContainerElementConstraintOptionalTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraint_specified_on_type_parameter_of_optional_gets_validated() {
        TypeWithOptional1 o = new TypeWithOptional1();
        o.stringOptional = Optional.of("");
        Set constraintViolations = this.getValidator().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("stringOptional").withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraints_specified_on_optional_and_on_type_parameter_of_optional_get_validated() {
        TypeWithOptional2 o = new TypeWithOptional2();
        o.stringOptional = Optional.of("");
        Set constraintViolations = this.getValidator().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("stringOptional").withInvalidValue(""));
        o = new TypeWithOptional2();
        o.stringOptional = null;
        constraintViolations = this.getValidator().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("stringOptional").withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void getter_constraint_provided_on_type_parameter_of_an_optional_gets_validated() {
        TypeWithOptional3 o = new TypeWithOptional3();
        o.stringOptional = Optional.of("");
        Set constraintViolations = this.getValidator().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("stringOptional").withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void return_value_constraint_provided_on_type_parameter_of_an_optional_gets_validated() throws Exception {
        Method method = TypeWithOptional4.class.getDeclaredMethod("returnStringOptional", new Class[0]);
        Set constraintViolations = this.getValidator().forExecutables().validateReturnValue((Object)new TypeWithOptional4(), method, Optional.of(""), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnStringOptional").returnValue()).withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void method_parameter_constraint_provided_as_type_parameter_of_an_optional_gets_validated() throws Exception {
        Method method = TypeWithOptional5.class.getDeclaredMethod("setValues", Optional.class);
        Object[] values = new Object[]{Optional.of("")};
        Set constraintViolations = this.getValidator().forExecutables().validateParameters((Object)new TypeWithOptional5(), method, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setValues").parameter("optionalParameter", 0)).withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constructor_parameter_constraint_provided_on_type_parameter_of_an_optional_gets_validated() throws Exception {
        Constructor constructor = TypeWithOptional6.class.getDeclaredConstructor(Optional.class);
        Object[] values = new Object[]{Optional.of("")};
        Set constraintViolations = this.getValidator().forExecutables().validateConstructorParameters(constructor, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithOptional6.class).parameter("optionalParameter", 0)).withInvalidValue(""));
    }

    private static class TypeWithOptional1 {
        private Optional<@NotBlank String> stringOptional;

        private TypeWithOptional1() {
        }
    }

    private static class TypeWithOptional2 {
        private @NotNull Optional<@NotBlank String> stringOptional;

        private TypeWithOptional2() {
        }
    }

    private static class TypeWithOptional3 {
        private Optional<String> stringOptional;

        private TypeWithOptional3() {
        }

        public Optional<@NotBlank String> getStringOptional() {
            return this.stringOptional;
        }
    }

    private static class TypeWithOptional4 {
        private Optional<String> stringOptional;

        private TypeWithOptional4() {
        }

        public Optional<@NotBlank String> returnStringOptional() {
            return this.stringOptional;
        }
    }

    private static class TypeWithOptional5 {
        private TypeWithOptional5() {
        }

        public void setValues(Optional<@NotBlank String> optionalParameter) {
        }
    }

    private static class TypeWithOptional6 {
        public TypeWithOptional6(Optional<@NotBlank String> optionalParameter) {
        }
    }
}

